/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.content;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.gson.Gson;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.plus.content.TBCachedPlacementContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

class TBContentLocalStorage {
    private static final String TAG = TBContentLocalStorage.class.getSimpleName();
    private static final String PLACEMENTS_CACHE_DIRECTORY = "placementsCache2";

    TBContentLocalStorage() {
    }

    static void cacheContent(@NonNull Context appContext, @NonNull Map<String, TBPlacement> content) {
        for (Map.Entry<String, TBPlacement> entry : content.entrySet()) {
            TBCachedPlacementContainer cachedPlacement = new TBCachedPlacementContainer(System.currentTimeMillis(), entry.getValue());
            String placementJson = new Gson().toJson((Object)cachedPlacement);
            String fileName = PLACEMENTS_CACHE_DIRECTORY + File.separator + TBContentLocalStorage.getDirectoryName(entry.getKey()) + File.separator + entry.getKey();
            File placementJsonFile = new File(appContext.getCacheDir(), fileName);
            placementJsonFile.getParentFile().mkdirs();
            try {
                FileOutputStream outputStream = new FileOutputStream(placementJsonFile);
                Throwable throwable = null;
                try {
                    outputStream.write(placementJson.getBytes());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    outputStream.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"setLastUsedPlacement: failed to save to a file");
                e.printStackTrace();
            }
        }
    }

    private static String getDirectoryName(@NonNull String placementId) {
        int spaceLastIndex = placementId.lastIndexOf(" ");
        if (spaceLastIndex == -1) {
            return placementId;
        }
        return placementId.substring(0, spaceLastIndex);
    }
}

