/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.util.Log;
import com.taboola.android.plus.shared.AllowedTimeWindows;
import java.util.Calendar;
import java.util.List;

public class ConditionCheckUtil {
    private static final String TAG = ConditionCheckUtil.class.getSimpleName();

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean isBlockedByAllowedTimeWindows(@NonNull List<AllowedTimeWindows> timeIntervals) {
        return ConditionCheckUtil.isBlockedByAllowedTimeWindows(timeIntervals, System.currentTimeMillis());
    }

    public static boolean isBlockedByAllowedTimeWindows(@NonNull @Size(min=0L) List<AllowedTimeWindows> timeIntervals, long timeToCheck) {
        if (timeIntervals.isEmpty()) {
            Log.i((String)TAG, (String)"isBlockedByAllowedTimeWindows: allowed intervals list is empty");
            return false;
        }
        for (AllowedTimeWindows interval : timeIntervals) {
            if (interval.getStartHour().equals(interval.getEndHour()) && interval.getStartMin().equals(interval.getEndMin())) {
                return false;
            }
            Calendar startTime = Calendar.getInstance();
            Calendar endTime = Calendar.getInstance();
            startTime.set(11, Integer.parseInt(interval.getStartHour()));
            startTime.set(12, Integer.parseInt(interval.getStartMin()));
            endTime.set(11, Integer.parseInt(interval.getEndHour()));
            endTime.set(12, Integer.parseInt(interval.getEndMin()));
            if (timeToCheck <= startTime.getTimeInMillis() || timeToCheck >= endTime.getTimeInMillis()) continue;
            return false;
        }
        return true;
    }

    public static boolean didMinTriggerIntervalPass(long lastShownTimestamp, long minTriggerInterval, long currentTime) {
        return currentTime - lastShownTimestamp > minTriggerInterval;
    }

    public static boolean isTriggerPerDayMaxCountReached(int maxAllowedCount, long alreadyShownCount) {
        if (maxAllowedCount == -1) {
            return false;
        }
        return alreadyShownCount >= (long)maxAllowedCount;
    }

    public static boolean shouldChangeUserGroup(int countOfEngagedActions, int engagedActionsLimit) {
        if (engagedActionsLimit == -1) {
            return false;
        }
        return countOfEngagedActions >= engagedActionsLimit;
    }
}

