/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.widget.RemoteViews;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.plus.R;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.NotificationContent;
import com.taboola.android.plus.notification.NotificationLayoutConfig;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.notification.TBNotificationStateReceiver;
import com.taboola.android.plus.notification.TBNotificationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

@RequiresApi(api=21)
class TBNotificationRenderer {
    private static final String TAG = TBNotificationRenderer.class.getSimpleName();
    static final int NOTIFICATION_ID = 64879717;
    private static final String channelId = "Taboola Content";
    static final String NOTIFICATION_INTENT_EXTRA_KEY_IMAGE_URI = "com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_IMAGE_URI";
    static final String NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT = "com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT";
    static final String NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST = "com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST";
    static final String NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT = "com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT ";
    static final String NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT = "com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT ";
    static final String INTENT_KEY_REQUEST_CODE = "intent_key_request_code";
    static final int REQUEST_CODE_COLLAPSED_PREV = 2100;
    static final int REQUEST_CODE_EXPANDED_PREV = 2200;
    static final int REQUEST_CODE_COLLAPSED_NEXT = 3100;
    static final int REQUEST_CODE_EXPANDED_NEXT = 3200;
    static final int REQUEST_CODE_AUTO_SWITCH = 3500;
    static final int REQUEST_CODE_IMAGE_LOAD_FAILED = 3600;
    static final int REQUEST_CODE_DISMISSED = 4000;
    static final int REQUEST_CODE_DEFAULT_NOTIFICATION_CLICK = 5000;
    static final int REQUEST_CODE_COLLAPSED_ITEM_CLICK = 5100;
    static final int REQUEST_CODE_EXPANDED_ITEM_CLICK = 5200;
    static final int REQUEST_CODE_COLLAPSED_ATTRIBUTION_CLICK = 6100;
    static final int REQUEST_CODE_EXPANDED_ATTRIBUTION_CLICK = 6200;
    private final Context appContext;
    private final TBNotificationManager tbNotificationManager;
    private final NotificationManager androidNotificationManager;
    private final TBNotificationUtil utils;
    private int iconId;
    @Nullable
    private Picasso picasso;

    TBNotificationRenderer(Context appContext, TBNotificationManager tbNotificationManager, TBNotificationUtil utils, int iconId) {
        this.appContext = appContext;
        this.tbNotificationManager = tbNotificationManager;
        this.utils = utils;
        this.iconId = iconId;
        this.androidNotificationManager = (NotificationManager)appContext.getSystemService("notification");
        this.createNotificationChannelIfNeeded();
    }

    RenderResult renderNotification(@NonNull NotificationContent notificationContent, @NonNull NotificationLayoutConfig notificationLayoutConfig) {
        Log.d((String)TAG, (String)"renderNotification() called");
        if (this.tbNotificationManager.handleNotificationBlockByUser()) {
            return new RenderResult(false, "User has blocked notifications for app or channel");
        }
        try {
            if (!this.doAllResourcesExist(this.appContext, this.iconId)) {
                throw new IllegalStateException("Not all resource files exist (is the app being updated?)");
            }
            TBNotificationLocalStore localStore = new TBNotificationLocalStore(this.appContext);
            localStore.setUiMode(notificationLayoutConfig.getCollapsedLayout().toString());
            Notification notification = this.buildNotification(notificationContent, notificationLayoutConfig);
            if (notification == null) {
                return new RenderResult(false, "Failed to build Notification with error: missing data for creating notification");
            }
            this.androidNotificationManager.notify(64879717, notification);
            return new RenderResult(true, null);
        }
        catch (Exception e) {
            return new RenderResult(false, "Failed to build Notification with error: " + e.getLocalizedMessage());
        }
    }

    void dismissNotification() {
        this.androidNotificationManager.cancel(64879717);
    }

    void onNotificationsDisabled() {
        if (this.picasso != null) {
            this.picasso.shutdown();
            this.picasso = null;
        }
    }

    void setNotificationIcon(int iconId) {
        this.iconId = iconId;
    }

    @Nullable
    private Notification buildNotification(@NonNull NotificationContent notificationContent, @NonNull NotificationLayoutConfig notificationLayoutConfig) {
        RemoteViews expandedView;
        RemoteViews collapsedView;
        ArrayList<Object> thumbnailsToLoad = new ArrayList<Object>();
        switch (notificationLayoutConfig.getCollapsedLayout()) {
            case SingleItemV1: {
                Object collapsedViewData = this.buildSingleItemV1CollapsedView(notificationContent, notificationLayoutConfig);
                collapsedView = (RemoteViews)collapsedViewData.first;
                thumbnailsToLoad.addAll((Collection)collapsedViewData.second);
                break;
            }
            case SingleItemV2: {
                Object collapsedViewData = this.buildSingleItemV2CollapsedView(notificationContent, notificationLayoutConfig);
                collapsedView = (RemoteViews)collapsedViewData.first;
                thumbnailsToLoad.add(collapsedViewData.second);
                break;
            }
            case MultipleThumbnails: {
                Object collapsedViewData = this.buildMultipleThumbnailsCollapsedView(notificationContent, notificationLayoutConfig);
                collapsedView = (RemoteViews)collapsedViewData.first;
                thumbnailsToLoad.addAll((Collection)collapsedViewData.second);
                break;
            }
            case SingleDefault: {
                Object collapsedViewData = this.buildDefaultCollapsedView(notificationContent, notificationLayoutConfig);
                collapsedView = (RemoteViews)collapsedViewData.first;
                thumbnailsToLoad.add(collapsedViewData.second);
                break;
            }
            case SingleTestInvalid: {
                Pair<RemoteViews, ThumbnailLoadingInfo> brokenNtofication = this.buildBrokenNtofication(notificationContent, notificationLayoutConfig);
                collapsedView = (RemoteViews)brokenNtofication.first;
                thumbnailsToLoad.add(brokenNtofication.second);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid collapsed layout variant");
            }
        }
        switch (notificationLayoutConfig.getExpandedLayout()) {
            case MultipleThumbnails: {
                Object expandedViewData = this.buildMultipleThumbnailsExpandedView(notificationContent, notificationLayoutConfig);
                expandedView = (RemoteViews)expandedViewData.first;
                thumbnailsToLoad.addAll((Collection)expandedViewData.second);
                break;
            }
            case SingleDefault: {
                Object expandedViewData = this.buildDefaultExpandedView(notificationContent, notificationLayoutConfig);
                expandedView = (RemoteViews)expandedViewData.first;
                thumbnailsToLoad.add(expandedViewData.second);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid expanded layout variant");
            }
        }
        TBRecommendationItem firstItem = (TBRecommendationItem)notificationContent.getPlacements().get(0).getItems().get(0);
        String compatTitle = this.utils.getItemTitle(firstItem);
        String compatDescription = this.utils.getItemDescription(firstItem);
        boolean didFindImgUrl = false;
        for (ThumbnailLoadingInfo thumbnailLoadingInfo : thumbnailsToLoad) {
            if (TextUtils.isEmpty((CharSequence)thumbnailLoadingInfo.thumbnailUrl)) continue;
            didFindImgUrl = true;
            break;
        }
        if (TextUtils.isEmpty((CharSequence)compatTitle) && !didFindImgUrl) {
            return null;
        }
        PendingIntent dismissIntent = this.getPendingIntentForAction(this.appContext, 4000, notificationContent.getPlacements(), notificationLayoutConfig);
        PendingIntent pendingIntent = this.getPendingIntentForClick(this.appContext, 5000, notificationContent.getPlacements().get(0), 0, notificationContent.getPlacements(), notificationLayoutConfig);
        Notification notification = new NotificationCompat.Builder(this.appContext, channelId).setSmallIcon(this.iconId).setAutoCancel(false).setSound(null).setContentIntent(pendingIntent).setContentTitle((CharSequence)compatTitle).setContentText((CharSequence)compatDescription).setCustomContentView(collapsedView).setCustomBigContentView(expandedView).setVisibility(1).setOnlyAlertOnce(true).setVibrate(new long[]{0L}).setDeleteIntent(dismissIntent).setPriority(0).build();
        for (ThumbnailLoadingInfo thumbnailLoadingInfo : thumbnailsToLoad) {
            this.requestThumbnailLoading(thumbnailLoadingInfo, notification);
        }
        return notification;
    }

    @NonNull
    private Pair<RemoteViews, ThumbnailLoadingInfo> buildBrokenNtofication(@NonNull NotificationContent notificationContent, NotificationLayoutConfig notificationLayoutConfig) {
        int currentItemIndex = 0;
        RemoteViews collapsedView = new RemoteViews(this.appContext.getPackageName(), R.layout.broken_notification_layout);
        TBPlacement placement = notificationContent.getPlacements().get(currentItemIndex);
        TBRecommendationItem item = (TBRecommendationItem)placement.getItems().get(0);
        ThumbnailLoadingInfo thumbnailLoadingInfo = new ThumbnailLoadingInfo(collapsedView, R.id.content_img_right, TBNotificationUtil.getItemThumbnailUrl(item, 64, 64), Picasso.Priority.HIGH);
        return new Pair((Object)collapsedView, (Object)thumbnailLoadingInfo);
    }

    @NonNull
    private Pair<RemoteViews, ThumbnailLoadingInfo> buildDefaultCollapsedView(@NonNull NotificationContent notificationContent, NotificationLayoutConfig notificationLayoutConfig) {
        ThumbnailLoadingInfo thumbnailLoadingInfo;
        int currentItemIndex = 0;
        NotificationConfig.LayoutSpecificConfigs.CollapsedSingleItemDefault layoutSpecificConfig = notificationLayoutConfig.getLayoutSpecificConfigs().getCollapsedSingleItemDefault();
        TBPlacement placement = notificationContent.getPlacements().get(currentItemIndex);
        TBRecommendationItem item = (TBRecommendationItem)placement.getItems().get(0);
        RemoteViews collapsedView = new RemoteViews(this.appContext.getPackageName(), R.layout.layout_notification_hint_collapsed);
        collapsedView.setTextViewText(R.id.title, (CharSequence)this.utils.getItemTitle(item));
        collapsedView.setTextViewText(R.id.brand, (CharSequence)this.utils.getItemBrand(item));
        collapsedView.setTextViewText(R.id.application_name, (CharSequence)notificationContent.getApplicationName());
        collapsedView.setImageViewResource(R.id.application_icon, this.iconId);
        if (this.utils.hasItemSponsoredContent(item)) {
            collapsedView.setTextViewText(R.id.sponsored, (CharSequence)TBDeviceInfoUtil.getLocaleStringResource(new Locale(TBDeviceInfoUtil.getSimCountry(this.appContext).toLowerCase()), R.string.sponsored_right, this.appContext));
            collapsedView.setViewVisibility(R.id.ll_container_attribution, 0);
            PendingIntent attributionIntent = this.getPendingIntentForAction(this.appContext, 6100, notificationContent.getPlacements(), notificationLayoutConfig);
            collapsedView.setOnClickPendingIntent(R.id.ll_container_attribution, attributionIntent);
        } else {
            collapsedView.setViewVisibility(R.id.ll_container_attribution, 8);
        }
        int imageWidth = (int)this.appContext.getResources().getDimension(R.dimen.tbn_collapsed_stream_image_width);
        int imageHeight = (int)this.appContext.getResources().getDimension(R.dimen.tbn_collapsed_stream_image_height);
        if (layoutSpecificConfig.shouldImagePlacedRight()) {
            collapsedView.setViewVisibility(R.id.content_image_container, 8);
            collapsedView.setViewVisibility(R.id.content_image_container_right, 0);
            collapsedView.setViewVisibility(R.id.hint, 8);
            collapsedView.setViewVisibility(R.id.hint_right, notificationContent.shouldShowHint() ? 0 : 8);
            thumbnailLoadingInfo = new ThumbnailLoadingInfo(collapsedView, R.id.content_img_right, TBNotificationUtil.getItemThumbnailUrl(item, imageWidth, imageHeight), Picasso.Priority.HIGH);
        } else {
            collapsedView.setViewVisibility(R.id.content_image_container, 0);
            collapsedView.setViewVisibility(R.id.content_image_container_right, 8);
            collapsedView.setViewVisibility(R.id.hint_right, 8);
            collapsedView.setViewVisibility(R.id.hint, notificationContent.shouldShowHint() ? 0 : 8);
            thumbnailLoadingInfo = new ThumbnailLoadingInfo(collapsedView, R.id.content_img, TBNotificationUtil.getItemThumbnailUrl(item, imageWidth, imageHeight), Picasso.Priority.HIGH);
        }
        return new Pair((Object)collapsedView, (Object)thumbnailLoadingInfo);
    }

    @NonNull
    private Pair<RemoteViews, ThumbnailLoadingInfo> buildDefaultExpandedView(@NonNull NotificationContent notificationContent, @NonNull NotificationLayoutConfig notificationLayoutConfig) {
        int currentItemIndex = 0;
        TBPlacement placement = notificationContent.getPlacements().get(currentItemIndex);
        TBRecommendationItem item = (TBRecommendationItem)placement.getItems().get(0);
        RemoteViews expandedView = new RemoteViews(this.appContext.getPackageName(), R.layout.layout_notification_expanded);
        expandedView.setTextViewText(R.id.title, (CharSequence)this.utils.getItemTitle(item));
        expandedView.setTextViewText(R.id.brand, (CharSequence)this.utils.getItemBrand(item));
        expandedView.setTextViewText(R.id.application_name, (CharSequence)notificationContent.getApplicationName());
        expandedView.setImageViewResource(R.id.application_icon, this.iconId);
        if (notificationLayoutConfig.shouldHideTime()) {
            expandedView.setViewVisibility(R.id.time_divider, 8);
            expandedView.setViewVisibility(R.id.time_img, 8);
            expandedView.setViewVisibility(R.id.time_txt, 8);
        } else {
            expandedView.setTextViewText(R.id.time_txt, (CharSequence)this.utils.getItemDate(item));
            expandedView.setViewVisibility(R.id.time_divider, 0);
            expandedView.setViewVisibility(R.id.time_img, 0);
            expandedView.setViewVisibility(R.id.time_txt, 0);
        }
        if (notificationLayoutConfig.shouldHideDescription()) {
            expandedView.setViewVisibility(R.id.description, 8);
        } else {
            expandedView.setTextViewText(R.id.description, (CharSequence)this.utils.getItemDescription(item));
        }
        if (this.utils.hasItemSponsoredContent(item)) {
            expandedView.setTextViewText(R.id.sponsored, (CharSequence)TBDeviceInfoUtil.getLocaleStringResource(new Locale(TBDeviceInfoUtil.getSimCountry(this.appContext).toLowerCase()), R.string.sponsored, this.appContext));
            expandedView.setViewVisibility(R.id.sponsored, 0);
            expandedView.setViewPadding(R.id.brand, 0, 1, 0, 0);
            PendingIntent attributionIntent = this.getPendingIntentForAction(this.appContext, 6200, notificationContent.getPlacements(), notificationLayoutConfig);
            expandedView.setOnClickPendingIntent(R.id.sponsored, attributionIntent);
            expandedView.setViewVisibility(R.id.time_divider, 8);
            expandedView.setViewVisibility(R.id.time_img, 8);
            expandedView.setViewVisibility(R.id.time_txt, 8);
        } else {
            expandedView.setViewVisibility(R.id.sponsored, 8);
        }
        if (notificationContent.hasMultiplePages()) {
            PendingIntent prevIntent = this.getPendingIntentForAction(this.appContext, 2200, notificationContent.getPlacements(), notificationLayoutConfig);
            PendingIntent nextIntent = this.getPendingIntentForAction(this.appContext, 3200, notificationContent.getPlacements(), notificationLayoutConfig);
            expandedView.setOnClickPendingIntent(R.id.prev_layout, prevIntent);
            expandedView.setOnClickPendingIntent(R.id.next_layout, nextIntent);
        } else {
            expandedView.setViewVisibility(R.id.prev_layout, 4);
            expandedView.setViewVisibility(R.id.next_layout, 4);
        }
        int imageHeight = (int)this.appContext.getResources().getDimension(R.dimen.tbn_expanded_img_height);
        ThumbnailLoadingInfo thumbnailLoadingInfo = new ThumbnailLoadingInfo(expandedView, R.id.content_img, TBNotificationUtil.getItemThumbnailUrl(item, this.utils.getScreenWidth(), imageHeight));
        return new Pair((Object)expandedView, (Object)thumbnailLoadingInfo);
    }

    @NonNull
    private Pair<RemoteViews, List<ThumbnailLoadingInfo>> buildSingleItemV1CollapsedView(NotificationContent notificationContent, NotificationLayoutConfig notificationLayoutConfig) {
        int currentItemIndex = 0;
        NotificationConfig.LayoutSpecificConfigs.CollapsedSingleItemV1 layoutSpecificConfig = notificationLayoutConfig.getLayoutSpecificConfigs().getCollapsedSingleItemV1();
        TBPlacement placement = notificationContent.getPlacements().get(currentItemIndex);
        TBRecommendationItem item = (TBRecommendationItem)placement.getItems().get(0);
        RemoteViews collapsedView = new RemoteViews(this.appContext.getPackageName(), R.layout.layout_notification_collapsed_v1);
        collapsedView.setTextViewText(R.id.application_name, (CharSequence)notificationContent.getApplicationName());
        collapsedView.setImageViewResource(R.id.application_icon, this.iconId);
        collapsedView.setTextViewText(R.id.action_next_text, (CharSequence)layoutSpecificConfig.getActionNextText());
        if (notificationLayoutConfig.shouldHideTime()) {
            collapsedView.setViewVisibility(R.id.time_divider, 8);
            collapsedView.setViewVisibility(R.id.time, 8);
        } else {
            collapsedView.setTextViewText(R.id.time, (CharSequence)this.utils.getItemDate(item));
            collapsedView.setViewVisibility(R.id.time_divider, 0);
            collapsedView.setViewVisibility(R.id.time, 0);
        }
        if (this.utils.hasItemSponsoredContent(item)) {
            collapsedView.setViewVisibility(R.id.time, 8);
            collapsedView.setViewVisibility(R.id.brand, 0);
            collapsedView.setTextViewText(R.id.brand, (CharSequence)this.utils.getItemBrand(item));
            collapsedView.setViewVisibility(R.id.time_divider, 0);
            collapsedView.setTextViewText(R.id.sponsored, (CharSequence)TBDeviceInfoUtil.getLocaleStringResource(new Locale(TBDeviceInfoUtil.getSimCountry(this.appContext).toLowerCase()), R.string.sponsored_right, this.appContext));
            collapsedView.setViewVisibility(R.id.sponsored, 0);
            PendingIntent attributionIntent = this.getPendingIntentForAction(this.appContext, 6100, notificationContent.getPlacements(), notificationLayoutConfig);
            collapsedView.setOnClickPendingIntent(R.id.sponsored, attributionIntent);
        } else {
            collapsedView.setViewVisibility(R.id.sponsored, 8);
            collapsedView.setViewVisibility(R.id.brand, 8);
        }
        if (notificationLayoutConfig.shouldHideDescription()) {
            collapsedView.setViewVisibility(R.id.description, 8);
            collapsedView.setViewVisibility(R.id.title_single_line, 8);
            collapsedView.setViewVisibility(R.id.title_two_lines, 0);
            collapsedView.setTextViewText(R.id.title_two_lines, (CharSequence)this.utils.getItemTitle(item));
        } else {
            collapsedView.setViewVisibility(R.id.description, 0);
            collapsedView.setTextViewText(R.id.description, (CharSequence)this.utils.getItemDescription(item));
            collapsedView.setViewVisibility(R.id.title_single_line, 0);
            collapsedView.setViewVisibility(R.id.title_two_lines, 8);
            collapsedView.setTextViewText(R.id.title_single_line, (CharSequence)this.utils.getItemTitle(item));
        }
        if (notificationContent.hasMultiplePages()) {
            PendingIntent nextIntent = this.getPendingIntentForAction(this.appContext, 3100, notificationContent.getPlacements(), notificationLayoutConfig);
            collapsedView.setOnClickPendingIntent(R.id.action_next_container, nextIntent);
        } else {
            collapsedView.setViewVisibility(R.id.action_next_container, 8);
        }
        int thumbnailWidth = (int)this.appContext.getResources().getDimension(R.dimen.single_collapsed_v1_thumbnail_size);
        int thumbnailHeight = (int)this.appContext.getResources().getDimension(R.dimen.single_collapsed_v1_thumbnail_size);
        ThumbnailLoadingInfo thumbnailLoadingInfo = new ThumbnailLoadingInfo(collapsedView, R.id.content_img, TBNotificationUtil.getItemThumbnailUrl(item, thumbnailWidth, thumbnailHeight), Picasso.Priority.HIGH);
        ThumbnailLoadingInfo iconNextLoadingInfo = new ThumbnailLoadingInfo(collapsedView, R.id.action_next_icon, layoutSpecificConfig.getActionNextIconUrl(), Picasso.Priority.HIGH);
        ArrayList<ThumbnailLoadingInfo> thumbnailLoadingInfoList = new ArrayList<ThumbnailLoadingInfo>(2);
        thumbnailLoadingInfoList.add(thumbnailLoadingInfo);
        thumbnailLoadingInfoList.add(iconNextLoadingInfo);
        return new Pair((Object)collapsedView, thumbnailLoadingInfoList);
    }

    @NonNull
    private Pair<RemoteViews, ThumbnailLoadingInfo> buildSingleItemV2CollapsedView(NotificationContent notificationContent, NotificationLayoutConfig notificationLayoutConfig) {
        int currentItemIndex = 0;
        NotificationConfig.LayoutSpecificConfigs.CollapsedSingleItemV2 layoutSpecificConfig = notificationLayoutConfig.getLayoutSpecificConfigs().getCollapsedSingleItemV2();
        TBPlacement placement = notificationContent.getPlacements().get(currentItemIndex);
        TBRecommendationItem item = (TBRecommendationItem)placement.getItems().get(0);
        RemoteViews collapsedView = new RemoteViews(this.appContext.getPackageName(), R.layout.layout_notification_collapserd_v2);
        collapsedView.setTextViewText(R.id.branding, (CharSequence)this.utils.getItemBrand(item));
        collapsedView.setTextViewText(R.id.application_name, (CharSequence)notificationContent.getApplicationName());
        collapsedView.setImageViewResource(R.id.application_icon, this.iconId);
        if (notificationLayoutConfig.shouldHideTime()) {
            collapsedView.setViewVisibility(R.id.time, 8);
            collapsedView.setViewVisibility(R.id.time_divider, 8);
        } else {
            collapsedView.setTextViewText(R.id.time, (CharSequence)this.utils.getItemDate(item));
            collapsedView.setViewVisibility(R.id.time_divider, 0);
            collapsedView.setViewVisibility(R.id.time, 0);
        }
        if (notificationLayoutConfig.shouldHideDescription()) {
            collapsedView.setViewVisibility(R.id.description, 8);
            collapsedView.setViewVisibility(R.id.title_single_line, 8);
            collapsedView.setViewVisibility(R.id.title_multi_line, 0);
            collapsedView.setTextViewText(R.id.title_multi_line, (CharSequence)this.utils.getItemTitle(item));
        } else {
            collapsedView.setViewVisibility(R.id.description, 0);
            collapsedView.setViewVisibility(R.id.title_single_line, 0);
            collapsedView.setViewVisibility(R.id.title_multi_line, 8);
            collapsedView.setTextViewText(R.id.description, (CharSequence)this.utils.getItemDescription(item));
            collapsedView.setTextViewText(R.id.title_single_line, (CharSequence)this.utils.getItemTitle(item));
        }
        if (this.utils.hasItemSponsoredContent(item)) {
            collapsedView.setViewVisibility(R.id.time, 8);
            collapsedView.setViewVisibility(R.id.time_divider, 8);
            collapsedView.setTextViewText(R.id.sponsored, (CharSequence)TBDeviceInfoUtil.getLocaleStringResource(new Locale(TBDeviceInfoUtil.getSimCountry(this.appContext).toLowerCase()), R.string.sponsored_right, this.appContext));
            collapsedView.setViewVisibility(R.id.sponsored, 0);
            PendingIntent attributionIntent = this.getPendingIntentForAction(this.appContext, 6100, notificationContent.getPlacements(), notificationLayoutConfig);
            collapsedView.setOnClickPendingIntent(R.id.sponsored, attributionIntent);
        } else {
            collapsedView.setViewVisibility(R.id.sponsored, 8);
        }
        collapsedView.setTextViewText(R.id.action_tv, (CharSequence)layoutSpecificConfig.getActionNextText());
        if (layoutSpecificConfig.shouldActionButtonBeTransparent()) {
            collapsedView.setImageViewResource(R.id.action_iv, R.drawable.round_corners_transparent);
        } else {
            collapsedView.setImageViewResource(R.id.action_iv, R.drawable.round_corners_blue);
        }
        int thumbnailHeight = (int)this.appContext.getResources().getDimension(R.dimen.single_collapsed_v2_thumbnail_size);
        ThumbnailLoadingInfo thumbnailLoadingInfo = new ThumbnailLoadingInfo(collapsedView, R.id.content_img, TBNotificationUtil.getItemThumbnailUrl(item, this.utils.getScreenWidth(), thumbnailHeight), Picasso.Priority.HIGH);
        return new Pair((Object)collapsedView, (Object)thumbnailLoadingInfo);
    }

    @NonNull
    private Pair<RemoteViews, List<ThumbnailLoadingInfo>> buildMultipleThumbnailsCollapsedView(NotificationContent notificationContent, NotificationLayoutConfig notificationLayoutConfig) {
        int itemCountInCurrentRow = Math.min(notificationContent.getPlacements().size(), NotificationLayoutConfig.CollapsedLayout.MultipleThumbnails.getMaxNumberOfItems());
        RemoteViews collapsedView = new RemoteViews(this.appContext.getPackageName(), R.layout.layout_multiple_notification_collapsed);
        collapsedView.removeAllViews(R.id.items_container);
        collapsedView.setImageViewResource(R.id.application_icon, this.iconId);
        ArrayList<Object> thumbnailLoadingInfoList = new ArrayList<Object>(itemCountInCurrentRow);
        ArrayList<TBPlacement> visiblePlacements = new ArrayList<TBPlacement>(notificationContent.getPlacements().subList(0, itemCountInCurrentRow));
        int rowHeight = (int)this.appContext.getResources().getDimension(R.dimen.tbn_collapsed_stream_image_height);
        for (int i = 0; i < itemCountInCurrentRow; ++i) {
            Pair<RemoteViews, ThumbnailLoadingInfo> itemData = this.buildMultipleThumbnailsItem(notificationContent.getPlacements().get(i), visiblePlacements, i, itemCountInCurrentRow, rowHeight, false, notificationLayoutConfig);
            collapsedView.addView(R.id.items_container, (RemoteViews)itemData.first);
            thumbnailLoadingInfoList.add(itemData.second);
        }
        return new Pair((Object)collapsedView, thumbnailLoadingInfoList);
    }

    @NonNull
    private Pair<RemoteViews, List<ThumbnailLoadingInfo>> buildMultipleThumbnailsExpandedView(NotificationContent notificationContent, NotificationLayoutConfig notificationLayoutConfig) {
        Pair<RemoteViews, ThumbnailLoadingInfo> itemData;
        int itemIndex;
        ArrayList<TBPlacement> placements = notificationContent.getPlacements();
        int totalItemCount = Math.min(placements.size(), NotificationLayoutConfig.ExpandedLayout.MultipleThumbnails.getMaxNumberOfItems());
        Pair<Integer, Integer> itemCountInRows = this.getItemCountInRows(totalItemCount);
        RemoteViews expandedView = new RemoteViews(this.appContext.getPackageName(), R.layout.layout_multiple_notification_expanded);
        expandedView.setImageViewResource(R.id.application_icon, this.iconId);
        expandedView.removeAllViews(R.id.top_notification_container);
        expandedView.removeAllViews(R.id.bottom_notification_container);
        ArrayList<Object> thumbnailLoadingInfoList = new ArrayList<Object>();
        int rowHeight = (int)this.appContext.getResources().getDimension(R.dimen.row_height_expanded_multiple_thumbnails);
        for (itemIndex = 0; itemIndex < (Integer)itemCountInRows.first; ++itemIndex) {
            itemData = this.buildMultipleThumbnailsItem(placements.get(itemIndex), placements, itemIndex, (Integer)itemCountInRows.first, rowHeight, true, notificationLayoutConfig);
            expandedView.addView(R.id.top_notification_container, (RemoteViews)itemData.first);
            thumbnailLoadingInfoList.add(itemData.second);
        }
        if ((Integer)itemCountInRows.second == 0) {
            expandedView.setViewVisibility(R.id.bottom_notification_container, 8);
        } else {
            for (itemIndex = ((Integer)itemCountInRows.first).intValue(); itemIndex < totalItemCount; ++itemIndex) {
                itemData = this.buildMultipleThumbnailsItem(placements.get(itemIndex), placements, itemIndex, (Integer)itemCountInRows.second, rowHeight, true, notificationLayoutConfig);
                expandedView.addView(R.id.bottom_notification_container, (RemoteViews)itemData.first);
                thumbnailLoadingInfoList.add(itemData.second);
            }
        }
        return new Pair((Object)expandedView, thumbnailLoadingInfoList);
    }

    @NonNull
    private Pair<RemoteViews, ThumbnailLoadingInfo> buildMultipleThumbnailsItem(TBPlacement itemPlacement, ArrayList<TBPlacement> visiblePlacements, int currentItemIndex, int itemCountInCurrentRow, int rowHeightPx, boolean isInExpandedLayout, NotificationLayoutConfig notificationLayoutConfig) {
        int attributionClickRequestCode;
        int itemClickRequestCode;
        TBRecommendationItem itemContent = (TBRecommendationItem)itemPlacement.getItems().get(0);
        RemoteViews itemView = new RemoteViews(this.appContext.getPackageName(), R.layout.layout_notification_item);
        itemView.setTextViewText(R.id.content_title, (CharSequence)this.utils.getItemTitle(itemContent));
        itemView.setTextViewText(R.id.branding, (CharSequence)this.utils.getItemBrand(itemContent));
        itemView.setTextViewText(R.id.notification_index, (CharSequence)String.valueOf(currentItemIndex + 1));
        if (isInExpandedLayout) {
            itemClickRequestCode = 5200;
            attributionClickRequestCode = 6200;
        } else {
            itemClickRequestCode = 5100;
            attributionClickRequestCode = 6100;
        }
        if (this.utils.hasItemSponsoredContent(itemContent)) {
            itemView.setViewVisibility(R.id.sponsored, 0);
            itemView.setTextViewText(R.id.sponsored, (CharSequence)TBDeviceInfoUtil.getLocaleStringResource(new Locale(TBDeviceInfoUtil.getSimCountry(this.appContext).toLowerCase()), R.string.sponsored, this.appContext));
            PendingIntent attributionIntent = this.getPendingIntentForAction(this.appContext, attributionClickRequestCode, visiblePlacements, notificationLayoutConfig);
            itemView.setOnClickPendingIntent(R.id.sponsored, attributionIntent);
        } else {
            itemView.setViewVisibility(R.id.sponsored, 8);
        }
        PendingIntent clickIntent = this.getPendingIntentForClick(this.appContext, itemClickRequestCode, itemPlacement, currentItemIndex, visiblePlacements, notificationLayoutConfig);
        itemView.setOnClickPendingIntent(R.id.item_root, clickIntent);
        int imageWidth = this.utils.getScreenWidth() / itemCountInCurrentRow;
        ThumbnailLoadingInfo thumbnailLoadingInfo = new ThumbnailLoadingInfo(itemView, R.id.content_image, TBNotificationUtil.getItemThumbnailUrl(itemContent, imageWidth, rowHeightPx), Picasso.Priority.HIGH);
        return new Pair((Object)itemView, (Object)thumbnailLoadingInfo);
    }

    private void requestThumbnailLoading(ThumbnailLoadingInfo thumbnailLoadingInfo, Notification notification) {
        String thumbnailUrl = thumbnailLoadingInfo.getThumbnailUrl();
        RequestCreator requestCreator = TextUtils.isEmpty((CharSequence)thumbnailUrl) ? this.getPicasso().load(R.drawable.placeholder).priority(thumbnailLoadingInfo.getPriority()) : this.getPicasso().load(thumbnailUrl).priority(thumbnailLoadingInfo.getPriority()).error(R.drawable.placeholder);
        requestCreator.into(thumbnailLoadingInfo.getRemoteViews(), thumbnailLoadingInfo.getImageViewId(), 64879717, notification);
    }

    boolean areNotificationsBlockedByUser() {
        if (this.areNotificationChannelsSupported()) {
            return this.androidNotificationManager.getNotificationChannel(channelId).getImportance() == 0;
        }
        return !NotificationManagerCompat.from((Context)this.appContext).areNotificationsEnabled();
    }

    private PendingIntent getPendingIntentForClick(@NonNull Context context, int requestCode, @NonNull TBPlacement clickedPlacement, int itemIndex, @NonNull ArrayList<TBPlacement> allVisiblePlacements, @NonNull NotificationLayoutConfig notificationLayoutConfig) {
        int requestCodeWithCounter = requestCode + itemIndex;
        Intent intent = new Intent(context, TBNotificationStateReceiver.class);
        Bundle extras = new Bundle();
        extras.putInt(INTENT_KEY_REQUEST_CODE, requestCodeWithCounter);
        extras.putParcelable(NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT, (Parcelable)clickedPlacement);
        extras.putParcelableArrayList(NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST, allVisiblePlacements);
        extras.putString(NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT, notificationLayoutConfig.getCollapsedLayout().toString());
        extras.putString(NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT, notificationLayoutConfig.getExpandedLayout().toString());
        intent.putExtras(extras);
        return PendingIntent.getBroadcast((Context)context, (int)requestCodeWithCounter, (Intent)intent, (int)0x8000000);
    }

    private PendingIntent getPendingIntentForAction(@NonNull Context context, int requestCode, @NonNull ArrayList<TBPlacement> placements, @NonNull NotificationLayoutConfig notificationLayoutConfig) {
        Intent intent = new Intent(context, TBNotificationStateReceiver.class);
        Bundle extras = new Bundle();
        extras.putInt(INTENT_KEY_REQUEST_CODE, requestCode);
        extras.putParcelableArrayList(NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST, placements);
        extras.putString(NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT, notificationLayoutConfig.getCollapsedLayout().toString());
        extras.putString(NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT, notificationLayoutConfig.getExpandedLayout().toString());
        intent.putExtras(extras);
        return PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)0x8000000);
    }

    @NonNull
    private Picasso getPicasso() {
        if (this.picasso == null) {
            Picasso.Builder builder = new Picasso.Builder(this.appContext);
            builder.listener(new Picasso.Listener(){

                public void onImageLoadFailed(Picasso picasso, Uri uri, Exception exception) {
                    Log.d((String)TAG, (String)("onImageLoadFailed() called with: uri = [" + uri + "], exception = [" + exception.getMessage() + "]"));
                    exception.printStackTrace();
                    Intent imageLoadFailedIntent = new Intent(TBNotificationRenderer.this.appContext, TBNotificationStateReceiver.class);
                    Bundle extras = new Bundle();
                    extras.putInt(TBNotificationRenderer.INTENT_KEY_REQUEST_CODE, 3600);
                    extras.putString(TBNotificationRenderer.NOTIFICATION_INTENT_EXTRA_KEY_IMAGE_URI, uri.toString());
                    imageLoadFailedIntent.putExtras(extras);
                    TBNotificationRenderer.this.appContext.sendBroadcast(imageLoadFailedIntent);
                }
            });
            this.picasso = builder.build();
        }
        return this.picasso;
    }

    private void createNotificationChannelIfNeeded() {
        if (this.areNotificationChannelsSupported()) {
            int importance = 3;
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelId, importance);
            channel.setLockscreenVisibility(1);
            channel.setSound(null, null);
            channel.enableVibration(false);
            channel.enableLights(false);
            this.androidNotificationManager.createNotificationChannel(channel);
        }
    }

    private boolean areNotificationChannelsSupported() {
        return Build.VERSION.SDK_INT >= 26;
    }

    private boolean doAllResourcesExist(@NonNull Context context, int iconId) {
        int[] layoutIds = new int[]{R.layout.layout_multiple_notification_collapsed, R.layout.layout_multiple_notification_expanded, R.layout.layout_notification_collapsed_v1, R.layout.layout_notification_expanded, R.layout.layout_notification_hint_collapsed, R.layout.layout_notification_item, R.layout.placeholder_notification_arrow};
        try {
            for (int layoutId : layoutIds) {
                context.getResources().getLayout(layoutId);
            }
            context.getResources().getDrawable(iconId, null);
            return true;
        }
        catch (Resources.NotFoundException e) {
            Log.d((String)TAG, (String)("doAllResourcesExist: " + e.getMessage()));
            return false;
        }
    }

    private Pair<Integer, Integer> getItemCountInRows(@IntRange(from=2L, to=6L) int totalItemCount) {
        int secondRowItemCount;
        int firstRowItemCount;
        switch (totalItemCount) {
            case 2: {
                firstRowItemCount = 2;
                secondRowItemCount = 0;
                break;
            }
            case 3: {
                firstRowItemCount = 1;
                secondRowItemCount = 2;
                break;
            }
            case 4: {
                firstRowItemCount = 2;
                secondRowItemCount = 2;
                break;
            }
            case 5: {
                firstRowItemCount = 2;
                secondRowItemCount = 3;
                break;
            }
            case 6: {
                firstRowItemCount = 3;
                secondRowItemCount = 3;
                break;
            }
            default: {
                firstRowItemCount = 0;
                secondRowItemCount = 0;
                Log.e((String)TAG, (String)("getItemCountInRows: totalItemCount is invalid :" + totalItemCount));
            }
        }
        return new Pair((Object)firstRowItemCount, (Object)secondRowItemCount);
    }

    private static class ThumbnailLoadingInfo {
        private final RemoteViews remoteViews;
        private final int imageViewId;
        private final String thumbnailUrl;
        private Picasso.Priority priority;

        private ThumbnailLoadingInfo(RemoteViews remoteViews, int imageViewId, String thumbnailUrl) {
            this.remoteViews = remoteViews;
            this.imageViewId = imageViewId;
            this.thumbnailUrl = thumbnailUrl;
            this.priority = Picasso.Priority.NORMAL;
        }

        public ThumbnailLoadingInfo(RemoteViews remoteViews, int imageViewId, String thumbnailUrl, Picasso.Priority priority) {
            this.remoteViews = remoteViews;
            this.imageViewId = imageViewId;
            this.thumbnailUrl = thumbnailUrl;
            this.priority = priority;
        }

        private RemoteViews getRemoteViews() {
            return this.remoteViews;
        }

        private int getImageViewId() {
            return this.imageViewId;
        }

        private String getThumbnailUrl() {
            return this.thumbnailUrl;
        }

        public Picasso.Priority getPriority() {
            return this.priority;
        }
    }

    static final class RenderResult {
        private final boolean isSuccessful;
        private final String errorMessage;

        RenderResult(boolean isSuccessful, String errorMessage) {
            this.isSuccessful = isSuccessful;
            this.errorMessage = errorMessage;
        }

        public RenderResult(boolean isSuccessful) {
            this.isSuccessful = isSuccessful;
            this.errorMessage = "";
        }

        boolean isSuccessful() {
            return this.isSuccessful;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

