/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

class TBNotificationExecutors {
    private final Executor mainThreadExecutor;
    private final Executor diskIOExecutor;

    TBNotificationExecutors() {
        this(new MainThreadExecutor(), Executors.newSingleThreadExecutor());
    }

    private TBNotificationExecutors(Executor mainThreadExecutor, Executor diskIOExecutor) {
        this.mainThreadExecutor = mainThreadExecutor;
        this.diskIOExecutor = diskIOExecutor;
    }

    Executor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }

    Executor getDiskIOExecutor() {
        return this.diskIOExecutor;
    }

    static class MainThreadExecutor
    implements Executor {
        private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());

        MainThreadExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            this.mainThreadHandler.post(command);
        }
    }
}

