/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.google.gson.annotations.SerializedName;
import com.taboola.android.plus.notification.killSwitch.KillSwitchConfig;
import com.taboola.android.plus.shared.AllowedTimeWindows;
import java.util.ArrayList;
import java.util.List;

public class NotificationConfig {
    private static final String TAG = NotificationConfig.class.getSimpleName();
    public static final String NOTIFICATIONS_CONFIG = "notificationsConfig";
    private static final String ITEMS_BATCH_SIZE = "itemsBatchSize";
    private static final String REFRESH_INTERVAL_MS = "refreshIntervalMs";
    private static final String SWITCH_CONTENT_INTERVAL_MS = "switchContentIntervalMs";
    private static final String IS_ONLY_WIFI_MODE = "isOnlyWifiMode";
    private static final String NOTIFICATION_PLACEMENT_NAME = "placementName";
    private static final String NOTIFICATION_APPLICATION_NAME = "applicationName";
    private static final String CONFIG_VARIANT = "configVariant";
    private static final String NON_CLICKABLE_URL_MARKER = "nonClickableUrlMarker";
    private static final String LAYOUT_CONFIG = "layoutConfig";
    private static final String NOTIFICATION_CATEGORIES = "notificationCategories";
    private static final String KILL_SWITCH_CONFIG = "killSwitchConfig";
    private static final String NOTIFICATION_INTERVAL = "allowedTimeWindows";
    private static final String NOTIFICATION_TRIGGERS_PER_DAY = "maxTriggerCountPerDay";
    private static final String MIN_NOTIFICATION_TRIGGER_INTERVAL_MS = "minTriggerIntervalMs";
    private static final String SMART_NOTIFICATION_FREQUENCY = "smartNotificationFrequency";
    @SerializedName(value="itemsBatchSize")
    private int itemsBatchSize = 1;
    @SerializedName(value="refreshIntervalMs")
    private int refreshIntervalMs = 900000;
    @SerializedName(value="switchContentIntervalMs")
    private int switchContentIntervalMs = 60000;
    @SerializedName(value="maxTriggerCountPerDay")
    private int maxTriggerCountPerDay = -1;
    @SerializedName(value="minTriggerIntervalMs")
    private int minTriggerIntervalMs = 0;
    @SerializedName(value="isOnlyWifiMode")
    @Nullable
    private Boolean isWifiOnlyMode = null;
    @SerializedName(value="placementName")
    @NonNull
    private String placementName = "";
    @SerializedName(value="applicationName")
    @NonNull
    private String applicationName = "";
    @SerializedName(value="configVariant")
    @NonNull
    private String configVariant = "";
    @SerializedName(value="nonClickableUrlMarker")
    @NonNull
    private String nonClickableUrlMarker = "";
    @SerializedName(value="layoutConfig")
    @NonNull
    private LayoutConfig layoutConfig = new LayoutConfig();
    @SerializedName(value="notificationCategories")
    @NonNull
    @Size(min=0L)
    private List<String> notificationCategories = new ArrayList<String>();
    @SerializedName(value="killSwitchConfig")
    @NonNull
    private KillSwitchConfig killSwitchConfig = new KillSwitchConfig();
    @SerializedName(value="smartNotificationFrequency")
    @NonNull
    private SmartNotificationFrequency smartNotificationFrequency = new SmartNotificationFrequency();
    @SerializedName(value="allowedTimeWindows")
    @NonNull
    @Size(min=0L)
    private List<AllowedTimeWindows> allowedIntervals = new ArrayList<AllowedTimeWindows>();

    @NonNull
    String getPlacementName() {
        return this.placementName;
    }

    @NonNull
    public String getApplicationName() {
        return this.applicationName;
    }

    int getItemsBatchSize() {
        return this.itemsBatchSize;
    }

    int getRefreshIntervalMs() {
        return this.refreshIntervalMs;
    }

    int getSwitchContentIntervalMs() {
        return this.switchContentIntervalMs;
    }

    public int getMaxNotificationTriggerCountPerDay() {
        return this.maxTriggerCountPerDay;
    }

    public int getMinTriggerIntervalMs() {
        return this.minTriggerIntervalMs;
    }

    @Nullable
    public Boolean isWifiOnlyMode() {
        return this.isWifiOnlyMode;
    }

    @NonNull
    public String getConfigVariant() {
        return this.configVariant;
    }

    @NonNull
    public String getNonClickableUrlMarker() {
        return this.nonClickableUrlMarker;
    }

    @NonNull
    public LayoutConfig getLayoutConfig() {
        return this.layoutConfig;
    }

    @NonNull
    @Size(min=0L)
    public List<String> getAllowedCategories() {
        return this.notificationCategories;
    }

    @NonNull
    public KillSwitchConfig getKillSwitchConfig() {
        return this.killSwitchConfig;
    }

    @NonNull
    @Size(min=0L)
    public List<AllowedTimeWindows> getAllowedIntervals() {
        return this.allowedIntervals;
    }

    @NonNull
    public NotificationConfig setMaxTriggerCountPerDay(@IntRange(from=0L) int maxTriggerCountPerDay) {
        this.maxTriggerCountPerDay = maxTriggerCountPerDay;
        return this;
    }

    @NonNull
    public NotificationConfig setMinTriggerIntervalMs(int minTriggerIntervalMs) {
        this.minTriggerIntervalMs = minTriggerIntervalMs;
        return this;
    }

    @NonNull
    public SmartNotificationFrequency getSmartNotificationFrequency() {
        return this.smartNotificationFrequency;
    }

    public void setSmartNotificationFrequency(@NonNull SmartNotificationFrequency smartNotificationFrequency) {
        this.smartNotificationFrequency = smartNotificationFrequency;
    }

    static class SmartNotificationFrequency {
        private static final String ENGAGEMENT_GROUPS = "engagementGroups";
        @SerializedName(value="engagementGroups")
        @NonNull
        @Size(min=0L)
        private List<EngagementGroup> engagementGroups = new ArrayList<EngagementGroup>();

        SmartNotificationFrequency() {
        }

        @NonNull
        @Size(min=0L)
        List<EngagementGroup> getEngagementGroups() {
            return this.engagementGroups;
        }

        public SmartNotificationFrequency setEngagementGroups(@NonNull List<EngagementGroup> engagementGroups) {
            this.engagementGroups = engagementGroups;
            return this;
        }

        public static class EngagementGroup {
            private static final String ALLOWED_TIME_WINDOWS = "allowedTimeWindows";
            private static final String MAX_TRIGGER_COUNT_PER_DAY = "maxTriggerCountPerDay";
            private static final String MIN_TRIGGER_INTERVAL_MS = "minTriggerIntervalMs";
            private static final String GROUP_NAME = "groupName";
            private static final String DISMISSED_NOTIFICATION_LIMIT = "dismissedNotificationLimit";
            private static final String ENGAGED_NOTIFICATION_LIMIT = "engagedNotificationLimit";
            private static final String UPGRADE_TO = "upgradeTo";
            private static final String DOWNGRADE_TO = "downgradeTo";
            @SerializedName(value="groupName")
            @NonNull
            private String groupName = "";
            @SerializedName(value="minTriggerIntervalMs")
            private long minTriggerIntervalMs = 0L;
            @SerializedName(value="maxTriggerCountPerDay")
            private int maxTriggerCountPerDay = -1;
            @SerializedName(value="allowedTimeWindows")
            @NonNull
            @Size(min=0L)
            private List<AllowedTimeWindows> allowedIntervals = new ArrayList<AllowedTimeWindows>();
            @SerializedName(value="engagedNotificationLimit")
            private int engagedNotificationLimit = -1;
            @SerializedName(value="dismissedNotificationLimit")
            private int dismissedNotificationLimit = -1;
            @SerializedName(value="upgradeTo")
            private String upgradeTo = "";
            @SerializedName(value="downgradeTo")
            private String downgradeTo = "";

            @NonNull
            String getGroupName() {
                return this.groupName;
            }

            public int getEngagedNotificationLimit() {
                return this.engagedNotificationLimit;
            }

            public int getDismissedNotificationLimit() {
                return this.dismissedNotificationLimit;
            }

            long getMinTriggerIntervalMs() {
                return this.minTriggerIntervalMs;
            }

            int getMaxNotificationTriggerCountPerDay() {
                return this.maxTriggerCountPerDay;
            }

            public String getUpgradeTo() {
                return this.upgradeTo;
            }

            public String getDowngradeTo() {
                return this.downgradeTo;
            }

            @NonNull
            @Size(min=0L)
            List<AllowedTimeWindows> getAllowedIntervals() {
                return this.allowedIntervals;
            }

            public EngagementGroup setGroupName(@NonNull String groupName) {
                this.groupName = groupName;
                return this;
            }

            public EngagementGroup setMinTriggerIntervalMs(long minTriggerIntervalMs) {
                this.minTriggerIntervalMs = minTriggerIntervalMs;
                return this;
            }

            public EngagementGroup setMaxTriggerCountPerDay(int maxTriggerCountPerDay) {
                this.maxTriggerCountPerDay = maxTriggerCountPerDay;
                return this;
            }

            public EngagementGroup setAllowedIntervals(@NonNull List<AllowedTimeWindows> allowedIntervals) {
                this.allowedIntervals = allowedIntervals;
                return this;
            }

            public EngagementGroup setEngagedNotificationLimit(int engagedNotificationLimit) {
                this.engagedNotificationLimit = engagedNotificationLimit;
                return this;
            }

            public EngagementGroup setDismissedNotificationLimit(int dismissedNotificationLimit) {
                this.dismissedNotificationLimit = dismissedNotificationLimit;
                return this;
            }

            public EngagementGroup setUpgradeTo(String upgradeTo) {
                this.upgradeTo = upgradeTo;
                return this;
            }

            public EngagementGroup setDowngradeTo(String downgradeTo) {
                this.downgradeTo = downgradeTo;
                return this;
            }
        }
    }

    static class LayoutSpecificConfigs {
        static final String LAYOUT_COLLAPSED_SINGLE_DEFAULT = "layout_collapsed_single_default";
        static final String LAYOUT_COLLAPSED_SINGLE_ITEM_V_1 = "layout_collapsed_single_item_v1";
        static final String LAYOUT_COLLAPSED_SINGLE_ITEM_V_2 = "layout_collapsed_single_item_v2";
        @SerializedName(value="layout_collapsed_single_default")
        private CollapsedSingleItemDefault collapsedSingleItemDefault = new CollapsedSingleItemDefault();
        @SerializedName(value="layout_collapsed_single_item_v1")
        private CollapsedSingleItemV1 collapsedSingleItemV1 = new CollapsedSingleItemV1();
        @SerializedName(value="layout_collapsed_single_item_v2")
        private CollapsedSingleItemV2 collapsedSingleItemV2 = new CollapsedSingleItemV2();

        LayoutSpecificConfigs() {
        }

        public CollapsedSingleItemDefault getCollapsedSingleItemDefault() {
            return this.collapsedSingleItemDefault;
        }

        public CollapsedSingleItemV1 getCollapsedSingleItemV1() {
            return this.collapsedSingleItemV1;
        }

        public CollapsedSingleItemV2 getCollapsedSingleItemV2() {
            return this.collapsedSingleItemV2;
        }

        static class CollapsedSingleItemV2 {
            static final String SHOULD_ACTION_BUTTON_BE_TRANSPARENT = "shouldActionButtonBeTransparent";
            private static final String CTA_BUTTON_TEXT = "ctaButtonText";
            @SerializedName(value="shouldActionButtonBeTransparent")
            private boolean shouldActionButtonBeTransparent = false;
            @SerializedName(value="ctaButtonText")
            private String actionNextText = "Open";

            CollapsedSingleItemV2() {
            }

            public boolean shouldActionButtonBeTransparent() {
                return this.shouldActionButtonBeTransparent;
            }

            public String getActionNextText() {
                return this.actionNextText;
            }
        }

        static class CollapsedSingleItemV1 {
            private static final String ACTION_NEXT_TEXT = "actionNextText";
            private static final String ACTION_NEXT_ICON_URL = "actionNextIconUrl";
            @SerializedName(value="actionNextText")
            private String actionNextText = "Change";
            @SerializedName(value="actionNextIconUrl")
            private String actionNextIconUrl = "https://s3-us-west-2.amazonaws.com/taboola-mobile-sdk/plus/res/change_icon.png";

            CollapsedSingleItemV1() {
            }

            public String getActionNextText() {
                return this.actionNextText;
            }

            public String getActionNextIconUrl() {
                return this.actionNextIconUrl;
            }
        }

        static class CollapsedSingleItemDefault {
            static final String SHOULD_IMAGE_PLACED_RIGHT = "shouldImagePlacedRight";
            @SerializedName(value="shouldImagePlacedRight")
            private boolean shouldImagePlacedRight = false;

            CollapsedSingleItemDefault() {
            }

            public boolean shouldImagePlacedRight() {
                return this.shouldImagePlacedRight;
            }
        }
    }

    static class LayoutConfig {
        static final String PREFERRED_COLLAPSED_LAYOUT = "preferredCollapsedLayout";
        static final String PREFERRED_EXPANDED_LAYOUT = "preferredExpandedLayout";
        static final String SHOULD_HIDE_TIME = "shouldHideTime";
        static final String SHOULD_HIDE_DESCRIPTION = "shouldHideDescription";
        static final String LAYOUT_SPECIFIC_CONFIGS = "layoutSpecificConfigs";
        @SerializedName(value="preferredCollapsedLayout")
        private String preferredCollapsedLayout = "layout_collapsed_single_default";
        @SerializedName(value="preferredExpandedLayout")
        private String preferredExpandedLayout = "layout_expanded_single_default";
        @SerializedName(value="shouldHideTime")
        private boolean shouldHideTime = false;
        @SerializedName(value="shouldHideDescription")
        private boolean shouldHideDescription = false;
        @SerializedName(value="layoutSpecificConfigs")
        private LayoutSpecificConfigs layoutSpecificConfigs = new LayoutSpecificConfigs();

        LayoutConfig() {
        }

        @NonNull
        public String getPreferredCollapsedLayout() {
            return this.preferredCollapsedLayout;
        }

        @NonNull
        public String getPreferredExpandedLayout() {
            return this.preferredExpandedLayout;
        }

        public boolean shouldHideTime() {
            return this.shouldHideTime;
        }

        public boolean shouldHideDescription() {
            return this.shouldHideDescription;
        }

        public LayoutSpecificConfigs getLayoutSpecificConfigs() {
            return this.layoutSpecificConfigs;
        }
    }
}

