/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.homeScreenNews;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.format.DateUtils;
import android.util.Log;
import android.view.Display;
import com.taboola.android.plus.ConfigManager;
import com.taboola.android.plus.PublicApi;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.content.LanguagesConfig;
import com.taboola.android.plus.homeScreenNews.HomeScreenConfig;
import com.taboola.android.plus.homeScreenNews.HomeScreenLocalRepository;
import com.taboola.android.plus.homeScreenNews.HomeScreenLocalStorage;
import com.taboola.android.plus.homeScreenNews.HsnRefreshJob;
import com.taboola.android.plus.homeScreenNews.HsnRetryReceiver;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import java.util.List;

@Keep
@RequiresApi(api=21)
public class TBHomeScreenNewsManager
implements PublicApi.PublicTBHomeScreenManager {
    private static final String TAG = TBHomeScreenNewsManager.class.getSimpleName();
    public static final String TB_HOME_SCREEN = "com.taboola.android.plus.homeScreen.OPEN_HOME_SCREEN";
    public static final String HOME_SCREEN_URL_TO_OPEN = "home_screen_url_to_open";
    public static final String HOME_SCREEN_PLACEMENT_TO_OPEN = "home_screen_placement_to_open";
    private static final long DEFAULT_INVITATION_REFRESH_INTERVAL_MS = 900000L;
    private static final long RETRY_INTERVAL_MS = 60000L;
    private static final int IMPORTANCE_TOP_SLEEPING_28 = 325;
    private static TBHomeScreenNewsManager singleton = null;
    private static Context appContext;
    private HomeScreenLocalStorage homeScreenLocalStorage;
    private TBNotificationLocalStore notificationLocalStore;

    private TBHomeScreenNewsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TBHomeScreenNewsManager getInstance() {
        Log.d((String)TAG, (String)"getInstance() called");
        if (singleton != null) return singleton;
        Class<TBHomeScreenNewsManager> clazz = TBHomeScreenNewsManager.class;
        synchronized (TBHomeScreenNewsManager.class) {
            if (singleton != null) return singleton;
            singleton = new TBHomeScreenNewsManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static void setApplicationContext(Context context) {
        appContext = context;
        if (appContext == null) {
            Log.e((String)TAG, (String)"setApplicationContext: context is null");
        } else {
            Log.d((String)TAG, (String)"setApplicationContext: context is not null");
        }
    }

    @Override
    @Deprecated
    public TBHomeScreenNewsManager init(@NonNull Context appContext) {
        Log.d((String)TAG, (String)("init() called with: appContext = [" + appContext + "]"));
        TBHomeScreenNewsManager.appContext = appContext;
        this.homeScreenLocalStorage = new HomeScreenLocalStorage(appContext);
        this.notificationLocalStore = new TBNotificationLocalStore(appContext);
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"init: Android version is less than LOLLIPOP. Ignoring call.");
            return this;
        }
        this.configHomeScreenFeature();
        return this;
    }

    @Override
    public TBHomeScreenNewsManager init() {
        Log.d((String)TAG, (String)("init() called with: appContext = [" + appContext + "]"));
        this.homeScreenLocalStorage = new HomeScreenLocalStorage(appContext);
        this.notificationLocalStore = new TBNotificationLocalStore(appContext);
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"init: Android version is less than LOLLIPOP. Ignoring call.");
            return this;
        }
        this.configHomeScreenFeature();
        return this;
    }

    @Override
    public boolean isInitialized() {
        if (Build.VERSION.SDK_INT < 21) {
            Log.d((String)TAG, (String)"isInitialized: Android version is less than LOLLIPOP. Ignoring call.");
            return false;
        }
        return appContext != null;
    }

    @Override
    public boolean isHomeScreenEnabled() {
        if (Build.VERSION.SDK_INT < 21) {
            Log.d((String)TAG, (String)"isInitialized: Android version is less than LOLLIPOP. Ignoring call.");
            return false;
        }
        Log.d((String)TAG, (String)"isHomeScreenEnabledByUser() called");
        return this.homeScreenLocalStorage.isHomeScreenEnabledByUser();
    }

    @Override
    public void setHomeScreenEnabled(boolean isEnabled) {
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"setHomeScreenEnabled: Android version is less than LOLLIPOP. Ignoring call.");
            return;
        }
        Log.d((String)TAG, (String)("onSwitchToggled() called with: isChecked = [" + isEnabled + "]"));
        this.homeScreenLocalStorage.setIsHomeScreenEnabledByUser(isEnabled);
        HomeScreenLocalRepository.setPeriodicInvitationEnabled(appContext, isEnabled);
        if (!isEnabled) {
            HsnRefreshJob.cancelPeriodicInvitation(appContext);
            TBHomeScreenNewsManager.cancelInvitationRetry(appContext);
        } else {
            ConfigManager.getCurrentConfigs(appContext.getApplicationContext(), this.notificationLocalStore.getPublisher(), this.notificationLocalStore.getConfigId(), new ConfigManager.OnGetAllConfigsCallback(){

                @Override
                public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                    TBHomeScreenNewsManager.this.handleHomeScreenEnabled(config.getHomeScreenConfig());
                }

                @Override
                public void onConfigsFailed(Throwable throwable) {
                    Log.e((String)TAG, (String)"onConfigsFailed: ", (Throwable)throwable);
                    if (!HsnRefreshJob.isJobRunning(appContext)) {
                        Log.i((String)TAG, (String)"onConfigsFailed: config isn't available scheduling job with default refresh interval");
                        HsnRefreshJob.schedulePeriodicInvitation(appContext, 900000L);
                    }
                }
            });
        }
    }

    private void handleHomeScreenEnabled(final HomeScreenConfig homeScreenConfig) {
        if (!homeScreenConfig.isHomeScreenFeatureEnabled()) {
            Log.i((String)TAG, (String)"onConfigsFetched: home screen is disabled in config");
            HsnRefreshJob.cancelPeriodicInvitation(appContext);
            TBHomeScreenNewsManager.cancelInvitationRetry(appContext);
            return;
        }
        if (!ConditionCheckUtil.didMinTriggerIntervalPass(this.homeScreenLocalStorage.getLastRunningHomeScreenTime(), homeScreenConfig.getHomeScreenTriggerIntervalMs(), System.currentTimeMillis())) {
            Log.i((String)TAG, (String)"onConfigsFetched: Min trigger interval isn't reached, not showing HSN");
            return;
        }
        if (ConditionCheckUtil.isTriggerPerDayMaxCountReached(homeScreenConfig.getMaxTriggerCountPerDay(), this.homeScreenLocalStorage.getCountOfRunningHomeScreenToday())) {
            Log.i((String)TAG, (String)"onConfigsFetched: Daily limit is reached, not showing HSN");
            return;
        }
        HomeScreenLocalRepository.setLastInvitationTimestamp(appContext, 0L);
        TBHomeScreenNewsManager.triggerHsnIfNeeded(appContext, homeScreenConfig);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                HsnRefreshJob.schedulePeriodicInvitation(appContext, homeScreenConfig.getHomeScreenRefreshIntervalMs());
            }
        }, 5000L);
    }

    @Override
    public void reportHomeScreenOpened() {
        if (Build.VERSION.SDK_INT < 21) {
            Log.e((String)TAG, (String)"reportHomeScreenOpened: Android version is less than LOLLIPOP. HSN Couldn't have opened.");
            return;
        }
        Log.d((String)TAG, (String)"reportHomeScreenOpened() called");
        this.updateSuccessfulOpenCounter(this.homeScreenLocalStorage.getLastRunningHomeScreenTime());
        this.homeScreenLocalStorage.setLastRunningHomeScreenTime(System.currentTimeMillis());
        TBNotificationAnalyticsManager analyticsManager = new TBNotificationAnalyticsManager(appContext.getApplicationContext(), this.notificationLocalStore);
        analyticsManager.sendHomeScreenDisplayedEvent();
    }

    private void updateSuccessfulOpenCounter(long lastRunningHomeScreenTime) {
        if (!DateUtils.isToday((long)lastRunningHomeScreenTime)) {
            this.homeScreenLocalStorage.setCountOfRunningHomeScreenToday(0);
        }
        int counter = this.homeScreenLocalStorage.getCountOfRunningHomeScreenToday();
        this.homeScreenLocalStorage.setCountOfRunningHomeScreenToday(++counter);
    }

    static boolean triggerHsnIfNeeded(@NonNull Context context, @NonNull HomeScreenConfig homeScreenConfig) {
        if (TBHomeScreenNewsManager.isDeviceLocked(context)) {
            if (TBHomeScreenNewsManager.isAppAtTheTop(context)) {
                Log.i((String)TAG, (String)"Screen is locked and invitation is already shown. No action needed");
                return true;
            }
            Log.d((String)TAG, (String)"Screen is locked and invitation is not yet shown");
            TBHomeScreenNewsManager.cancelInvitationRetry(context);
            if (ConditionCheckUtil.isBlockedByAllowedTimeWindows(homeScreenConfig.getAllowedIntervals())) {
                Log.i((String)TAG, (String)"Home Screen News is not shown because it is currently not within Allowed Time Windows");
                return true;
            }
            Log.d((String)TAG, (String)"Home Screen News trigger is allowed by Allowed Time Windows");
            TBHomeScreenNewsManager.sendHomeScreenBroadcast(context, homeScreenConfig.getUrlToOpen(), homeScreenConfig.getPlacementToOpen());
            return true;
        }
        Log.i((String)TAG, (String)"Screen is not locked, not showing HSN");
        TBHomeScreenNewsManager.retryInvitationFaster(context);
        return false;
    }

    private void configHomeScreenFeature() {
        Log.d((String)TAG, (String)"configHomeScreenFeature() called");
        ConfigManager.getCurrentConfigs(appContext, this.notificationLocalStore.getPublisher(), this.notificationLocalStore.getConfigId(), new ConfigManager.OnGetAllConfigsCallback(){

            @Override
            public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                boolean isHomeScreenEnabled = TBHomeScreenNewsManager.this.homeScreenLocalStorage.isHomeScreenEnabledByUser();
                HomeScreenConfig homeScreenConfig = config.getHomeScreenConfig();
                if (homeScreenConfig.isHomeScreenFeatureEnabled()) {
                    if (isHomeScreenEnabled) {
                        if (HsnRefreshJob.isJobRunning(appContext)) {
                            if (HomeScreenLocalRepository.getLastUsedInvitationIntervalMs(appContext) != homeScreenConfig.getHomeScreenRefreshIntervalMs()) {
                                HsnRefreshJob.reschedulePeriodicInvitation(appContext, homeScreenConfig.getHomeScreenRefreshIntervalMs());
                            }
                        } else {
                            HsnRefreshJob.schedulePeriodicInvitation(appContext, homeScreenConfig.getHomeScreenRefreshIntervalMs());
                        }
                    } else {
                        HsnRefreshJob.cancelPeriodicInvitation(appContext);
                    }
                } else {
                    Log.i((String)TAG, (String)"onConfigsFetched: home screen is disabled in config");
                    HsnRefreshJob.cancelPeriodicInvitation(appContext);
                }
            }

            @Override
            public void onConfigsFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("onConfigsFailed: " + throwable.getMessage()), (Throwable)throwable);
            }
        });
    }

    static boolean didRefreshIntervalPass(Context context, long refreshIntervalMs) {
        long timeSinceLastRefreshMs = System.currentTimeMillis() - HomeScreenLocalRepository.getLastInvitationTimestamp(context);
        return timeSinceLastRefreshMs >= refreshIntervalMs;
    }

    private static void retryInvitationFaster(Context context) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (Build.VERSION.SDK_INT >= 23) {
            alarmManager.setExactAndAllowWhileIdle(1, System.currentTimeMillis() + 60000L, TBHomeScreenNewsManager.getRetryIntent(context));
        } else {
            alarmManager.set(1, System.currentTimeMillis() + 60000L, TBHomeScreenNewsManager.getRetryIntent(context));
        }
    }

    static void cancelInvitationRetry(Context context) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.cancel(TBHomeScreenNewsManager.getRetryIntent(context));
        }
    }

    private static PendingIntent getRetryIntent(Context context) {
        Intent rescheduledIntent = new Intent(context, HsnRetryReceiver.class);
        Bundle extras = new Bundle();
        extras.putInt("intent_key_request_code", 1000);
        rescheduledIntent.putExtras(extras);
        return PendingIntent.getBroadcast((Context)context, (int)1000, (Intent)rescheduledIntent, (int)0x8000000);
    }

    private static boolean isDeviceLocked(Context context) {
        boolean isLocked = false;
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        boolean inKeyguardRestrictedInputMode = keyguardManager.inKeyguardRestrictedInputMode();
        if (inKeyguardRestrictedInputMode) {
            isLocked = true;
        } else {
            DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
            for (Display display : displayManager.getDisplays()) {
                isLocked = display.getState() != 2;
            }
        }
        return isLocked;
    }

    private static boolean isAppAtTheTop(Context context) {
        if (Build.VERSION.SDK_INT >= 28) {
            return TBHomeScreenNewsManager.isAppAtTheTop28Plus(context);
        }
        return TBHomeScreenNewsManager.isAppAtTheTopBefore28(context);
    }

    @TargetApi(value=27)
    private static boolean isAppAtTheTopBefore28(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List runningProcesses = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
            Log.v((String)TAG, (String)("isAppAtTheTopBefore28: processInfo.importance = " + processInfo.importance));
            if (processInfo.importance != 100 && processInfo.importance != 230 && processInfo.importance != 150 && processInfo.importance != 130) continue;
            for (String activeProcess : processInfo.pkgList) {
                if (!activeProcess.equals(context.getPackageName())) continue;
                return true;
            }
        }
        return false;
    }

    @RequiresApi(api=28)
    private static boolean isAppAtTheTop28Plus(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List runningProcesses = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
            Log.v((String)TAG, (String)("isAppAtTheTop28Plus: processInfo.importance = " + processInfo.importance));
            if (processInfo.importance != 100 && processInfo.importance != 325 && processInfo.importance != 230) continue;
            for (String activeProcess : processInfo.pkgList) {
                if (!activeProcess.equals(context.getPackageName())) continue;
                return true;
            }
        }
        return false;
    }

    private static void sendHomeScreenBroadcast(Context appContext, String urlToOpen, String placementName) {
        Intent intent = new Intent();
        intent.setAction(TB_HOME_SCREEN);
        intent.setPackage(appContext.getPackageName());
        intent.putExtra(HOME_SCREEN_URL_TO_OPEN, urlToOpen);
        intent.putExtra(HOME_SCREEN_PLACEMENT_TO_OPEN, placementName);
        TBNotificationLocalStore localStore = new TBNotificationLocalStore(appContext);
        TBNotificationAnalyticsManager analyticsManager = new TBNotificationAnalyticsManager(appContext, localStore);
        analyticsManager.sendHomeScreenTriggeredEvent();
        appContext.sendBroadcast(intent);
        Log.d((String)TAG, (String)"sendHomeScreenBroadcast: HSN trigger broadcast sent");
    }
}

