/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.util;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.os.StatFs;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.firebase.messaging.RemoteMessage;
import com.ocamba.hoood.OcambaHoood;
import com.ocamba.hoood.OcambaNotificationParser;
import com.ocamba.hoood.OcambaPrefManager;
import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.ocamba.hoood.util.OcambaBadger;
import com.ocamba.hoood.util.OcambaLogUtils;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class OcambaUtils {
    private static final String TAG = OcambaUtils.class.getSimpleName();

    @Nullable
    public static String getAppPackageName(Context context) {
        if (context != null) {
            return context.getPackageName();
        }
        return "";
    }

    public static String getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getApiKey(Context context) {
        try {
            ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = app.metaData;
            String apiKey = bundle.getString("com.ocamba.ApiKey");
            if (apiKey == null) {
                throw new PackageManager.NameNotFoundException("No api key provided.");
            }
            return apiKey;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            OcambaRequest.postCrash(e.toString());
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            OcambaRequest.postCrash(e.toString());
            return "";
        }
    }

    public static String getNotificationReceiver(Context context) {
        OcambaLogUtils.d(TAG, "getNotificationReceiver() called.");
        try {
            ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = app.metaData;
            String receiver = bundle.getString("com.ocamba.OcambaReceiver");
            if (receiver == null) {
                OcambaLogUtils.e(TAG, "No receiver provided.");
                return "";
            }
            OcambaLogUtils.d(TAG, "getNotificationReceiver() returned: " + receiver);
            return receiver;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            OcambaRequest.postCrash(e.toString());
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            OcambaRequest.postCrash(e.toString());
            return "";
        }
    }

    public static String getPackage(Context context) {
        try {
            ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = app.metaData;
            String receiver = bundle.getString("com.ocamba.OcambaReceiver");
            if (receiver == null) {
                OcambaLogUtils.e(TAG, "No receiver provided.");
                return "";
            }
            OcambaLogUtils.d(TAG, "getPackage() Receiver: " + receiver);
            return receiver.substring(0, receiver.lastIndexOf("."));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            OcambaRequest.postCrash(e.toString());
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            OcambaRequest.postCrash(e.toString());
            return "";
        }
    }

    public static String getSdkVersion() {
        return "1.0.9";
    }

    public static void sendNotificationClicked(Context context, OcambaNotificationObject object) {
        OcambaLogUtils.d(TAG, "sendNotificationClicked() called with: context = [" + context + "], object = [" + object + "]");
        if (context != null) {
            String notificationReceiver = OcambaUtils.getNotificationReceiver(context);
            if (!notificationReceiver.equals("")) {
                Intent intent = new Intent(OcambaUtils.getOcambaNotificationClick(context));
                intent.putExtra("ocamba_object", (Parcelable)object);
                OcambaLogUtils.i(TAG, "sendNotificationClicked: [" + notificationReceiver + "]");
                intent.setComponent(new ComponentName(context, notificationReceiver));
                context.sendBroadcast(intent);
            } else {
                OcambaLogUtils.e(TAG, "sendNotificationClicked() error");
            }
        }
    }

    public static void sendNotificationDismissed(Context context) {
        OcambaLogUtils.d(TAG, "sendNotificationDismissed() called with: context = [" + context + "]");
        if (context != null) {
            String notificationReceiver = OcambaUtils.getNotificationReceiver(context);
            if (!notificationReceiver.equals("")) {
                Intent intent = new Intent(OcambaUtils.getOcambaNotificationDismissed(context));
                OcambaLogUtils.i(TAG, "sendNotificationDismissed: [" + notificationReceiver + "]");
                intent.setComponent(new ComponentName(context, notificationReceiver));
                context.sendBroadcast(intent);
            } else {
                OcambaLogUtils.e(TAG, "sendNotificationClicked() error");
            }
        }
    }

    public static void sendEventTokenRefresh(String token) {
        OcambaLogUtils.d(TAG, "sendEventTokenRefresh() called with: context = [" + OcambaHoood.getContext() + "], token = [" + token + "]");
        Context context = OcambaHoood.getContext();
        if (context != null) {
            String notificationReceiver = OcambaUtils.getNotificationReceiver(OcambaHoood.getContext());
            if (!notificationReceiver.equals("")) {
                Intent intent = new Intent(OcambaUtils.getTokenRefresh(context));
                intent.putExtra("token", token);
                intent.setComponent(new ComponentName(context, notificationReceiver));
                context.sendBroadcast(intent);
            } else {
                OcambaLogUtils.e(TAG, "sendNotificationClicked() error");
            }
        }
    }

    public static void sendOcambaMessageReceived(Context context, OcambaNotificationObject object) {
        OcambaLogUtils.d(TAG, "sendOcambaMessageReceived() called with: context = [" + context + "], object = [" + object + "]");
        if (context != null) {
            String notificationReceiver = OcambaUtils.getNotificationReceiver(context);
            if (!notificationReceiver.equals("")) {
                Intent intent = new Intent(OcambaUtils.getOcambaNotificationReceived(context));
                intent.putExtra("ocamba_object", (Parcelable)object);
                OcambaLogUtils.i(TAG, "sendOcambaMessageReceived: [" + notificationReceiver + "]");
                intent.setComponent(new ComponentName(context, notificationReceiver));
                context.sendBroadcast(intent);
            } else {
                OcambaLogUtils.e(TAG, "sendNotificationClicked() error");
            }
        }
    }

    public static void sendOcambaCustomAction(Context context, String actions) {
        OcambaLogUtils.d(TAG, "sendOcambaCustomAction() called with: context = [" + context + "], object = [" + actions + "]");
        if (context != null) {
            String notificationReceiver = OcambaUtils.getNotificationReceiver(context);
            if (!notificationReceiver.equals("")) {
                Intent intent = new Intent(OcambaUtils.getOcambaUserAction(context));
                intent.putExtra("ocamba_custom_action", actions);
                OcambaLogUtils.i(TAG, "sendOcambaCustomAction:[" + notificationReceiver + "]");
                intent.setComponent(new ComponentName(context, notificationReceiver));
                context.sendBroadcast(intent);
            } else {
                OcambaLogUtils.e(TAG, "sendNotificationClicked() error");
            }
        }
    }

    public static void sendOcambaMultiMessageReceived(Context context) {
        OcambaLogUtils.d(TAG, "sendOcambaMultiMessageReceived() called with: context = [" + context + "]");
        if (context != null) {
            String notificationReceiver = OcambaUtils.getNotificationReceiver(context);
            if (!notificationReceiver.equals("")) {
                Intent intent = new Intent(OcambaUtils.getOcambaNotificationStoryReceived(context));
                OcambaLogUtils.i(TAG, "sendOcambaMultiMessageReceived: [" + notificationReceiver + "]");
                intent.setComponent(new ComponentName(context, notificationReceiver));
                context.sendBroadcast(intent);
            } else {
                OcambaLogUtils.e(TAG, "sendNotificationClicked() error");
            }
        }
    }

    public static void sendCustomMessageReceived(Context context, RemoteMessage remoteMessage) {
        OcambaLogUtils.d(TAG, "sendCustomMessageReceived() called with: context = [" + context + "], remoteMessage = [" + remoteMessage + "]");
        if (context != null) {
            String notificationReceiver = OcambaUtils.getNotificationReceiver(context);
            if (!notificationReceiver.equals("")) {
                Intent intent = new Intent(OcambaUtils.getCustomNotificationReceived(context));
                intent.putExtra("ocamba_user_notification_object", (Parcelable)remoteMessage);
                OcambaLogUtils.i(TAG, "sendCustomMessageReceived: [" + notificationReceiver + "]");
                intent.setComponent(new ComponentName(context, notificationReceiver));
                context.sendBroadcast(intent);
            } else {
                OcambaLogUtils.e(TAG, "sendNotificationClicked() error");
            }
        }
    }

    public static void sendOcambaActionButtons(Context context, String object) {
        OcambaLogUtils.d(TAG, "sendOcambaActions() called with: context = [" + context + "], object = [" + object + "]");
        if (context != null) {
            String notificationReceiver = OcambaUtils.getNotificationReceiver(context);
            if (!notificationReceiver.equals("")) {
                Intent intent = new Intent(OcambaUtils.getOcambaActionButtons(context));
                intent.putExtra("ocamba_action_buttons", object);
                OcambaLogUtils.i(TAG, "sendOcambaActionButtons: [" + notificationReceiver + "]");
                intent.setComponent(new ComponentName(context, notificationReceiver));
                context.sendBroadcast(intent);
            } else {
                OcambaLogUtils.e(TAG, "sendNotificationClicked() error");
            }
        }
    }

    private static String getOcambaNotificationClick(Context context) {
        return OcambaUtils.getPackage(context) + ".OCAMBA_NOTIFICATION_CLICK";
    }

    private static String getOcambaNotificationDismissed(Context context) {
        return OcambaUtils.getPackage(context) + ".OCAMBA_NOTIFICATION_DISMISSED";
    }

    private static String getCustomNotificationReceived(Context context) {
        return OcambaUtils.getPackage(context) + ".OCAMBA_NOTIFICATION_USER";
    }

    private static String getOcambaNotificationReceived(Context context) {
        return OcambaUtils.getPackage(context) + ".OCAMBA_NOTIFICATION_RECEIVED";
    }

    private static String getOcambaUserAction(Context context) {
        return OcambaUtils.getPackage(context) + ".OCAMBA_NOTIFICATION_CUSTOM_ACTION";
    }

    private static String getOcambaNotificationStoryReceived(Context context) {
        return OcambaUtils.getPackage(context) + ".OCAMBA_NOTIFICATION_MULTI_MESSAGE_RECEIVED";
    }

    private static String getTokenRefresh(Context context) {
        return OcambaUtils.getPackage(context) + ".OCAMBA_NOTIFICATION_TOKEN";
    }

    private static String getOcambaActionButtons(Context context) {
        return OcambaUtils.getPackage(context) + ".OCAMBA_NOTIFICATION_ACTION_BUTTONS";
    }

    public static String notification(Context context, Intent intent) {
        String pkgName = OcambaUtils.getPackage(context);
        String action = intent.getAction();
        if (action == null) {
            return null;
        }
        return action.replace(pkgName, "");
    }

    public static void sentNotificationMessage(RemoteMessage remoteMessage) {
        OcambaLogUtils.d(TAG, "sentNotificationMessage() called with: context = [" + OcambaHoood.getContext() + "], remoteMessage = [" + remoteMessage + "]");
        if (OcambaHoood.getBuilder().isPushDisabled()) {
            OcambaLogUtils.w(TAG, "Push is not enabled!");
            return;
        }
        Context context = OcambaHoood.getContext();
        if (context != null) {
            new OcambaNotificationParser(context).parseRemoteMessage(remoteMessage);
        } else {
            OcambaLogUtils.e(TAG, "Context is null!");
        }
    }

    private static boolean isNetworkAvailable(Context context) {
        if (context == null) {
            return false;
        }
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null) {
                if (Build.VERSION.SDK_INT >= 28) {
                    NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
                    if (capabilities != null) {
                        if (capabilities.hasTransport(0)) {
                            return true;
                        }
                        if (capabilities.hasTransport(1)) {
                            return true;
                        }
                        if (capabilities.hasTransport(3)) {
                            return true;
                        }
                    }
                } else {
                    NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
                    if (activeNetworkInfo != null && activeNetworkInfo.isConnected()) {
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void countRequests(Exception e, Context context) {
        if (!OcambaUtils.isNetworkAvailable(context) && e.toString().contains("java.net.UnknownHostException")) {
            OcambaPrefManager.setCountRequests(OcambaPrefManager.getCountRequests() + 1);
        }
    }

    public static void sendRequests(int code) {
        try {
            int numb = OcambaPrefManager.getCountRequests();
            OcambaLogUtils.i(TAG, "Number: " + numb + ", Code: " + code);
            if (numb > 0 && numb <= 9) {
                for (int i = 0; i < numb; ++i) {
                    OcambaRequest.postActivity(code);
                }
                OcambaPrefManager.setCountRequests(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long getAvailableInternalMemorySize() {
        try {
            long availableBlocks;
            long blockSize;
            File path = Environment.getDataDirectory();
            StatFs stat = new StatFs(path.getPath());
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = stat.getBlockSizeLong();
                availableBlocks = stat.getAvailableBlocksLong();
            } else {
                blockSize = stat.getBlockSize();
                availableBlocks = stat.getAvailableBlocks();
            }
            return availableBlocks * blockSize;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long getTotalInternalMemorySize() {
        try {
            long totalBlocks;
            long blockSize;
            File path = Environment.getDataDirectory();
            StatFs stat = new StatFs(path.getPath());
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = stat.getBlockSizeLong();
                totalBlocks = stat.getBlockCountLong();
            } else {
                blockSize = stat.getBlockSize();
                totalBlocks = stat.getBlockCount();
            }
            return totalBlocks * blockSize;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean checkLocationPermissions(Context context) {
        if (context == null) {
            return false;
        }
        int permissionState = ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION");
        return permissionState == 0;
    }

    public static boolean isGooglePlayServicesAvailable(Context context) {
        if (context == null) {
            return false;
        }
        try {
            int resultCode = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            if (resultCode != 0) {
                OcambaLogUtils.e(TAG, "Google Play services is unavailable.");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void enableLocationPermission(final Activity activity) {
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)activity);
        alertBuilder.setCancelable(false);
        alertBuilder.setTitle((CharSequence)"Enable location permission?");
        alertBuilder.setMessage((CharSequence)"We need location permission to build up better experience for you.");
        alertBuilder.setPositiveButton(17039379, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)0);
            }
        });
        alertBuilder.setNegativeButton(17039369, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        alertBuilder.show();
    }

    public static ComponentName getComponent(Context context) {
        Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (launchIntent == null) {
            OcambaLogUtils.e(TAG, "Unable to find launch intent for package " + context.getPackageName());
            return null;
        }
        return launchIntent.getComponent();
    }

    public static String getResolverInfo(Context context) {
        if (context == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        if (resolveInfo == null || resolveInfo.activityInfo.name.toLowerCase().contains("resolver")) {
            return null;
        }
        return resolveInfo.activityInfo.packageName;
    }

    public static void setBadgeCount(Context context, int count) {
        try {
            OcambaLogUtils.d(TAG, "setBadgeCount() Disble: " + OcambaHoood.getBuilder().isBadgeDisabled() + ", Pref: " + OcambaPrefManager.getNotificationCount() + ", Count: " + count);
            if (context == null) {
                return;
            }
            if (OcambaHoood.getBuilder().isBadgeDisabled()) {
                if (OcambaPrefManager.getNotificationCount() != 0) {
                    OcambaPrefManager.setNotificationCount(0);
                    OcambaBadger.setBadge(context, 0);
                }
                return;
            }
            if (OcambaPrefManager.getNotificationCount() != count && count >= 0) {
                OcambaPrefManager.setNotificationCount(count);
                OcambaBadger.setBadge(context, count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isOcambaMessage(RemoteMessage remoteMessage) {
        OcambaLogUtils.d(TAG, "isOcambaMessage() called with: remoteMessage = [" + remoteMessage + "]");
        try {
            JSONObject jsonObject = new JSONObject(remoteMessage.getData());
            if (jsonObject.has("notification")) {
                try {
                    JSONObject jsonCheck = new JSONObject(jsonObject.getString("notification"));
                    OcambaLogUtils.i(TAG, "isOcambaMessage() JSON: " + jsonCheck);
                    return jsonCheck.has("c") || jsonCheck.has("a") || jsonCheck.has("n") || jsonCheck.has("e") || jsonCheck.has("gl") || jsonCheck.has("bl");
                }
                catch (JSONException e) {
                    OcambaLogUtils.e(TAG, "isOcambaMessage: Unable to parse remote message", (Exception)((Object)e));
                    e.printStackTrace();
                }
            }
            return false;
        }
        catch (Exception e) {
            OcambaRequest.postCrash(e.getMessage());
            return false;
        }
    }

    public static JSONObject createJsonObject(String object) {
        if (!object.equals("")) {
            try {
                return new JSONObject(object);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static boolean hasMediaSessionCompat() {
        try {
            Class.forName("android.support.v4.media.session.MediaSessionCompat");
            return true;
        }
        catch (ClassNotFoundException ex) {
            OcambaLogUtils.e(TAG, "No MediaSessionCompat!" + ex);
            ex.printStackTrace();
            return false;
        }
    }
}

