/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.notifications;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.google.firebase.messaging.RemoteMessage;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.ocamba.hoood.util.OcambaLogUtils;
import com.ocamba.hoood.util.OcambaUtils;

public abstract class OcambaNotificationReceiver
extends BroadcastReceiver {
    private static final String TAG = OcambaNotificationReceiver.class.getSimpleName();

    public void onReceive(Context context, Intent intent) {
        String action = OcambaUtils.notification(context, intent);
        if (action == null) {
            OcambaLogUtils.e(TAG, "Intent action not defined");
            return;
        }
        OcambaLogUtils.d(TAG, String.format("Received intent with action %s", action));
        switch (action) {
            case ".OCAMBA_NOTIFICATION_TOKEN": {
                this.ocambaNewToken(intent.getStringExtra("token"), context);
                break;
            }
            case ".OCAMBA_NOTIFICATION_USER": {
                RemoteMessage remoteMessage = (RemoteMessage)intent.getParcelableExtra("ocamba_user_notification_object");
                this.ocambaNotificationUser(remoteMessage, context);
                break;
            }
            case ".OCAMBA_NOTIFICATION_RECEIVED": {
                this.ocambaNotificationReceived((OcambaNotificationObject)intent.getParcelableExtra("ocamba_object"), context);
                break;
            }
            case ".OCAMBA_NOTIFICATION_CLICK": {
                this.ocambaNotificationClick((OcambaNotificationObject)intent.getParcelableExtra("ocamba_object"), context);
                break;
            }
            case ".OCAMBA_NOTIFICATION_ACTION_BUTTONS": {
                this.ocambaNotificationActionButtons(intent.getStringExtra("ocamba_action_buttons"), context);
                break;
            }
            case ".OCAMBA_NOTIFICATION_DISMISSED": {
                this.ocambaNotificationDismissed(context);
                break;
            }
            case ".OCAMBA_NOTIFICATION_MULTI_MESSAGE_RECEIVED": {
                this.ocambaNotificationMultiMessageReceived();
                break;
            }
            case ".OCAMBA_NOTIFICATION_CUSTOM_ACTION": {
                this.ocambaNotificationCustomAction(intent.getStringExtra("ocamba_custom_action"), context);
                break;
            }
            default: {
                OcambaLogUtils.w(TAG, String.format("Ignoring intent with unsupported action %s", action));
            }
        }
    }

    public abstract void ocambaNewToken(String var1, Context var2);

    public abstract void ocambaNotificationUser(RemoteMessage var1, Context var2);

    public abstract void ocambaNotificationReceived(OcambaNotificationObject var1, Context var2);

    public abstract void ocambaNotificationClick(OcambaNotificationObject var1, Context var2);

    public abstract void ocambaNotificationActionButtons(String var1, Context var2);

    public abstract void ocambaNotificationDismissed(Context var1);

    public abstract void ocambaNotificationMultiMessageReceived();

    public abstract void ocambaNotificationCustomAction(String var1, Context var2);
}

