/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.geo;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.ocamba.hoood.geo.OcambaGeofence;
import com.ocamba.hoood.geo.OcambaGeofenceBroadcastReceiver;
import com.ocamba.hoood.geo.OcambaGeofenceError;
import com.ocamba.hoood.geo.OcambaGeofencePrefManager;
import com.ocamba.hoood.util.OcambaLogUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class OcambaGeofenceUtils {
    private static final String TAG = OcambaGeofenceUtils.class.getSimpleName();
    private static OcambaGeofenceUtils mOcambaGeofenceUtils;
    private static Context mContext;
    private static PendingIntent mGeofencePendingIntent;
    private static List<Geofence> mGeofenceList;
    private static ArrayList<String> mGeofenceListId;
    private static GeofencingClient mGeofencingClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void init(Context context) {
        if (mOcambaGeofenceUtils == null) {
            Class<OcambaGeofenceUtils> clazz = OcambaGeofenceUtils.class;
            // MONITORENTER : com.ocamba.hoood.geo.OcambaGeofenceUtils.class
            OcambaLogUtils.i(TAG, "init new");
            mOcambaGeofenceUtils = new OcambaGeofenceUtils(context);
            // MONITOREXIT : clazz
        }
        OcambaLogUtils.i(TAG, "init exist");
    }

    private OcambaGeofenceUtils(Context context) {
        if (context == null) {
            return;
        }
        mContext = context;
        mGeofencingClient = LocationServices.getGeofencingClient((Context)context);
    }

    public static void addGeofenceToList(String id2, double lat, double lng, float radius, long expire) {
        OcambaGeofenceUtils.addGeofenceToList(id2, lat, lng, radius, expire, null);
    }

    public static void addGeofenceToList(String id2, double lat, double lng, float radius, long expire, ArrayList<String> polygon) {
        OcambaLogUtils.d(TAG, "addGeofenceToList() called with: id = [" + id2 + "], lat = [" + lat + "], lng = [" + lng + "], radius = [" + radius + "], expire = [" + expire + "], polygon = [" + polygon + "]");
        if (mGeofenceList != null && mGeofenceListId != null) {
            OcambaLogUtils.i(TAG, mGeofenceListId.toString());
            mGeofenceListId.clear();
            mGeofenceListId.addAll(OcambaGeofencePrefManager.getGeofencesIds());
            mGeofenceList.add(OcambaGeofenceUtils.buildGeofence(id2, lat, lng, radius, expire, 3, polygon));
            OcambaGeofenceUtils.addGeofences();
        }
    }

    public static void removeGeofences(ArrayList<String> geofencesToRemove) {
        OcambaLogUtils.d(TAG, "removeGeofences: " + geofencesToRemove);
        if (mGeofenceListId != null && mGeofencingClient != null && mGeofenceList != null) {
            mGeofenceListId.clear();
            mGeofenceListId.addAll(OcambaGeofencePrefManager.getGeofencesIds());
            mGeofencingClient.removeGeofences(geofencesToRemove);
            for (String id2 : geofencesToRemove) {
                OcambaGeofencePrefManager.clearGeofence(id2);
                mGeofenceListId.remove(id2);
            }
            mGeofenceList.clear();
            OcambaGeofencePrefManager.setGeofenceIds(new HashSet<String>(mGeofenceListId));
        }
    }

    private static void addGeofences() {
        OcambaLogUtils.d(TAG, "addGeofences() called");
        OcambaGeofencePrefManager.setGeofenceIds(new HashSet<String>(mGeofenceListId));
        if (mGeofencingClient != null) {
            try {
                mGeofencingClient.addGeofences(OcambaGeofenceUtils.getGeofencingRequest(), OcambaGeofenceUtils.getGeofenceTransitionPendingIntent()).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

                    public void onComplete(@NonNull Task<Void> task) {
                        if (task.isSuccessful()) {
                            OcambaLogUtils.i(TAG, "Successful added geofences!");
                            mGeofenceList.clear();
                        } else {
                            String errorMessage = OcambaGeofenceError.getErrorString(mContext, task.getException());
                            OcambaLogUtils.e(TAG, errorMessage);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static GeofencingRequest getGeofencingRequest() {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        OcambaLogUtils.i(TAG, "getGeofencingRequest() called [" + mGeofenceList + "]");
        builder.addGeofences(mGeofenceList);
        return builder.build();
    }

    private static Geofence buildGeofence(String id2, double lat, double lng, float radius, long expire, int transition, ArrayList<String> polygon) {
        OcambaLogUtils.d(TAG, "buildGeofence() called with: id = [" + id2 + "], lat = [" + lat + "], lng = [" + lng + "], radius = [" + radius + "], expire = [" + expire + "], transition = [" + transition + "], polygon = [" + polygon + "]");
        OcambaLogUtils.i(TAG, mGeofenceListId + "");
        OcambaGeofence geofenceObj = new OcambaGeofence(id2, lat, lng, radius, expire, transition, polygon);
        if (!mGeofenceListId.contains(id2)) {
            mGeofenceListId.add(id2);
        }
        OcambaGeofencePrefManager.setGeofence(geofenceObj);
        return geofenceObj.toGeofence();
    }

    private static PendingIntent getGeofenceTransitionPendingIntent() {
        OcambaLogUtils.d(TAG, "getGeofenceTransitionPendingIntent() called");
        if (mGeofencePendingIntent != null) {
            return mGeofencePendingIntent;
        }
        if (mContext == null) {
            return null;
        }
        Intent intent = new Intent(mContext, OcambaGeofenceBroadcastReceiver.class);
        mGeofencePendingIntent = PendingIntent.getBroadcast((Context)mContext, (int)0, (Intent)intent, (int)0x8000000);
        return mGeofencePendingIntent;
    }

    static {
        mGeofenceList = new ArrayList<Geofence>();
        mGeofenceListId = new ArrayList();
    }
}

