/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood;

import android.content.Context;
import android.webkit.URLUtil;
import com.ocamba.hoood.OcambaHoood;
import com.ocamba.hoood.OcambaNotificationParser;
import com.ocamba.hoood.OcambaPrefManager;
import com.ocamba.hoood.transport.OcambaResponseCallback;
import com.ocamba.hoood.transport.OcambaSendRequest;
import com.ocamba.hoood.transport.OcambaThreadPool;
import com.ocamba.hoood.util.OcambaLogUtils;
import com.ocamba.hoood.util.OcambaUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class OcambaRequest {
    private static final String TAG = OcambaRequest.class.getSimpleName();
    private static String URL_USERS = "https://t.hoood.info/v1/users?type=mobile";
    private static String URL_ACTIVITY = "https://t.hoood.info/v1/activity?type=mobile";
    private static String URL_CRASH = "https://t.hoood.info/v1/activity";

    static void postUser(String token, final OcambaResponseCallback ocambaResponseCallback) {
        OcambaLogUtils.d(TAG, "postUser() called with: token = [" + token + "]");
        OcambaThreadPool.getInstance().add(new OcambaSendRequest(OcambaHoood.getContext(), 0, token, URL_USERS, new OcambaResponseCallback(){

            @Override
            public void onFailure(Exception e) {
                OcambaHoood.mSendUser = true;
                OcambaLogUtils.e(TAG, "User onFailure(): " + e);
                if (ocambaResponseCallback != null) {
                    ocambaResponseCallback.onFailure(e);
                }
                e.printStackTrace();
            }

            @Override
            public void onResponse(int code, String response) {
                OcambaLogUtils.i(TAG, "USER response code: " + code + ", response: " + response);
                if (code >= 200 && code < 300) {
                    if (ocambaResponseCallback != null) {
                        ocambaResponseCallback.onResponse(code, response);
                    }
                    OcambaPrefManager.setPushInitialized(true);
                } else if (ocambaResponseCallback != null) {
                    ocambaResponseCallback.onFailure(new Exception(response));
                }
            }
        }));
    }

    static void patchUserExtraTrack(String token, final JSONObject trackData) {
        OcambaLogUtils.d(TAG, "patchUserExtraTrack() called with: token = [" + token + "]");
        OcambaThreadPool.getInstance().add(new OcambaSendRequest(OcambaHoood.getContext(), 3, token, URL_USERS, new OcambaResponseCallback(){

            @Override
            public void onFailure(Exception e) {
                OcambaLogUtils.e(TAG, "Patch user extra track onFailure(): " + e);
                e.printStackTrace();
                OcambaPrefManager.setTrackerMap(trackData.toString());
            }

            @Override
            public void onResponse(int code, String response) {
                OcambaPrefManager.setTrackerMap("");
                OcambaLogUtils.i(TAG, "Patch user extra track response code: " + code + ", response: " + response);
            }
        }, trackData));
    }

    static void patchUserLocationTrack(String token, JSONObject trackData) {
        OcambaLogUtils.d(TAG, "patchUserLocationTrack() called with: token = [" + token + "]");
        long lastTimeSent = OcambaPrefManager.getLocationTime() + 300000L;
        long currentTimeMillis = System.currentTimeMillis();
        if (lastTimeSent < currentTimeMillis) {
            OcambaThreadPool.getInstance().add(new OcambaSendRequest(OcambaHoood.getContext(), 4, token, URL_USERS, new OcambaResponseCallback(){

                @Override
                public void onFailure(Exception e) {
                    OcambaLogUtils.e(TAG, "Patch user location track onFailure(): " + e);
                    e.printStackTrace();
                }

                @Override
                public void onResponse(int code, String response) {
                    OcambaLogUtils.i(TAG, "Patch user location track response code: " + code + ", response: " + response);
                    OcambaPrefManager.setLocationTime(System.currentTimeMillis());
                }
            }, trackData));
        }
    }

    static void patchUserAppUpdate(String token) {
        OcambaLogUtils.d(TAG, "patchUserAppUpdate() called with: token = [" + token + "]");
        OcambaThreadPool.getInstance().add(new OcambaSendRequest(OcambaHoood.getContext(), 5, token, URL_USERS, new OcambaResponseCallback(){

            @Override
            public void onFailure(Exception e) {
                OcambaLogUtils.e(TAG, "Patch user app update onFailure(): " + e);
                e.printStackTrace();
            }

            @Override
            public void onResponse(int code, String response) {
                OcambaLogUtils.i(TAG, "Patch user app update response code: " + code + ", response: " + response);
            }
        }));
    }

    public static void postActivity(final int code) {
        OcambaLogUtils.d(TAG, "postActivity() called with: code = [" + code + "]");
        final Context context = OcambaHoood.getContext();
        OcambaThreadPool.getInstance().add(new OcambaSendRequest(context, code, OcambaPrefManager.getToken(), URL_ACTIVITY, new OcambaResponseCallback(){

            @Override
            public void onFailure(Exception e) {
                OcambaLogUtils.e(TAG, "Activity onFailure(): " + e);
                e.printStackTrace();
                if (code == 205) {
                    OcambaUtils.countRequests(e, context);
                }
            }

            @Override
            public void onResponse(int responseCode, String response) {
                JSONObject e;
                OcambaLogUtils.i(TAG, "Activity response code: " + responseCode + ", response: " + response);
                if (code == 201) {
                    OcambaPrefManager.setAppFirstLaunch();
                }
                if (code == 205) {
                    OcambaUtils.sendRequests(code);
                }
                if ((e = OcambaUtils.createJsonObject(OcambaPrefManager.getTrackerMap())) != null && e.length() > 0) {
                    OcambaRequest.patchUserExtraTrack(OcambaPrefManager.getToken(), e);
                }
            }
        }));
    }

    public static void geofenceTransition(int code, String id2) {
        OcambaLogUtils.d(TAG, "geofenceTransition() called with: code = [" + code + "], [" + id2 + "]");
        OcambaThreadPool.getInstance().add(new OcambaSendRequest(OcambaHoood.getContext(), code, id2, URL_ACTIVITY, new OcambaResponseCallback(){

            @Override
            public void onFailure(Exception e) {
                OcambaLogUtils.e(TAG, "Geofence onFailure(): " + e);
                e.printStackTrace();
            }

            @Override
            public void onResponse(int responseCode, String response) {
                OcambaLogUtils.i(TAG, "Geofence response code: " + responseCode + ", response: " + response);
            }
        }));
    }

    public static void beaconProximity(String id2) {
        OcambaLogUtils.d(TAG, "beaconProximity() called with: code = [" + id2 + "]");
        OcambaThreadPool.getInstance().add(new OcambaSendRequest(OcambaHoood.getContext(), 230, id2, URL_ACTIVITY, new OcambaResponseCallback(){

            @Override
            public void onFailure(Exception e) {
                OcambaLogUtils.e(TAG, "Beacon onFailure(): " + e);
                e.printStackTrace();
            }

            @Override
            public void onResponse(int responseCode, String response) {
                OcambaLogUtils.i(TAG, "Beacon response code: " + responseCode + ", response: " + response);
            }
        }));
    }

    public static void getTracker(String tracker) {
        OcambaLogUtils.d(TAG, "getTracker() called with: tracker = [" + tracker + "]");
        OcambaThreadPool.getInstance().add(new OcambaSendRequest(null, 1, "", tracker, new OcambaResponseCallback(){

            @Override
            public void onFailure(Exception e) {
                OcambaLogUtils.e(TAG, "Tracker onFailure(): " + e);
                e.printStackTrace();
            }

            @Override
            public void onResponse(int code, String response) {
                OcambaLogUtils.i(TAG, "Tracker response code: " + code + ", response: " + response);
            }
        }));
    }

    public static void getTracker(String tracker, OcambaResponseCallback callback) {
        OcambaLogUtils.d(TAG, "getTracker() called with: tracker = [" + tracker + "]");
        if (tracker != null && tracker.length() > 0 && URLUtil.isValidUrl((String)tracker)) {
            OcambaLogUtils.d(TAG, "getTracker(): Tracker is valid!");
            OcambaThreadPool.getInstance().add(new OcambaSendRequest(null, 1, "", tracker, callback));
        }
    }

    static void getNotification(String url) {
        url = url.concat("&ver=1.0.3");
        OcambaLogUtils.d(TAG, "getNotification() called with: url = [" + url + "]");
        OcambaThreadPool.getInstance().add(new OcambaSendRequest(null, 2, "", url, new OcambaResponseCallback(){

            @Override
            public void onFailure(Exception e) {
                OcambaLogUtils.e(TAG, "Notification onFailure(): " + e);
                e.printStackTrace();
            }

            @Override
            public void onResponse(int code, String response) {
                OcambaLogUtils.i(TAG, "Notification response code: " + code + ", response: " + response);
                try {
                    if (response.length() == 0) {
                        return;
                    }
                    new OcambaNotificationParser(OcambaHoood.getContext()).parseMultiMessage(new JSONObject(response));
                }
                catch (JSONException e) {
                    OcambaLogUtils.e(TAG, "JSONException: " + e.getMessage());
                    e.printStackTrace();
                    OcambaRequest.postCrash(e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    OcambaRequest.postCrash(e.toString());
                }
            }
        }));
    }

    public static void postCrash(String message) {
        OcambaRequest.postCrash(message, false);
    }

    public static void postCrash(String message, boolean isCrashDisabled) {
        OcambaLogUtils.d(TAG, "postCrash() called with: [" + isCrashDisabled + "][" + message + "]");
        if (isCrashDisabled) {
            OcambaLogUtils.w(TAG, "postCrash: Crash is not enabled!");
            return;
        }
        OcambaThreadPool.getInstance().add(new OcambaSendRequest(OcambaHoood.getContext(), 599, message, URL_CRASH, new OcambaResponseCallback(){

            @Override
            public void onFailure(Exception e) {
                OcambaLogUtils.e(TAG, "Crash onFailure(): " + e);
                e.printStackTrace();
            }

            @Override
            public void onResponse(int code, String response) {
                OcambaLogUtils.i(TAG, "Crash response code: " + code + ", response: " + response);
            }
        }));
    }
}

