/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.ocamba.hoood.OcambaHoood;
import com.ocamba.hoood.geo.OcambaGeofence;
import com.ocamba.hoood.geo.OcambaGeofencePrefManager;
import com.ocamba.hoood.geo.OcambaGeofenceUtils;
import com.ocamba.hoood.util.OcambaLogUtils;
import com.ocamba.hoood.util.OcambaUtils;

public class OcambaRebootReceiver
extends BroadcastReceiver {
    public static final String TAG = OcambaRebootReceiver.class.getSimpleName();

    public void onReceive(Context context, Intent intent) {
        OcambaLogUtils.d(TAG, "OcambaRebootReceiver");
        if (intent.getAction() == null || !intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {
            return;
        }
        try {
            if (OcambaHoood.getBuilder().isGeofenceDisabled()) {
                return;
            }
            if (!OcambaUtils.isGooglePlayServicesAvailable(context)) {
                return;
            }
            if (!OcambaUtils.checkLocationPermissions(context)) {
                OcambaLogUtils.w(TAG, "initGeofence: Please, enable location permission!");
                return;
            }
            OcambaGeofenceUtils.init(context);
            for (String geofenceId : OcambaGeofencePrefManager.getGeofencesIds()) {
                OcambaLogUtils.d(TAG, "OcambaRebootReceiver id: " + geofenceId);
                OcambaGeofence ocambaGeofence = OcambaGeofencePrefManager.getGeofence(geofenceId);
                OcambaGeofenceUtils.addGeofenceToList(ocambaGeofence.getId(), ocambaGeofence.getLatitude(), ocambaGeofence.getLongitude(), ocambaGeofence.getRadius(), ocambaGeofence.getExpirationDuration(), ocambaGeofence.getPolygon());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

