/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.images;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.os.Environment;
import android.util.LruCache;
import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.images.IOcambaImageLoader;
import com.ocamba.hoood.images.OcambaDiskCache;
import com.ocamba.hoood.images.OcambaImageCallable;
import com.ocamba.hoood.images.OcambaImageHelper;
import com.ocamba.hoood.transport.OcambaThreadPool;
import com.ocamba.hoood.util.OcambaLogUtils;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class OcambaLruImageLoader
implements IOcambaImageLoader {
    private static final String TAG = OcambaLruImageLoader.class.getSimpleName();
    private LruCache<String, Bitmap> memoryCache;
    private OcambaDiskCache ocambaDiskCache;
    private final Object diskCacheLock = new Object();
    private boolean diskCacheStarting = true;
    private static final long DISK_CACHE_SIZE = 0x500000L;
    private static final String DISK_CACHE_SUBDIR = "ocamba.imageloader.disk.cache";

    public OcambaLruImageLoader(Context context) {
        try {
            int maxCacheSize = OcambaImageHelper.getImageLoaderCacheSize();
            this.memoryCache = new LruCache<String, Bitmap>(maxCacheSize){

                protected int sizeOf(String key, Bitmap value) {
                    return value.getByteCount();
                }
            };
            File diskCacheDir = OcambaLruImageLoader.getDiskCacheDir(context, DISK_CACHE_SUBDIR);
            new InitDiskCacheTask().execute(new File[]{diskCacheDir});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Bitmap getLocalBitmap(String url) {
        if (this.memoryCache != null) {
            Bitmap bitmap = (Bitmap)this.memoryCache.get((Object)url);
            if (bitmap != null) {
                return bitmap;
            }
            bitmap = this.getBitmapFromDiskCache(url);
            if (bitmap != null) {
                this.putBitmapToMemoryCache(url, bitmap);
                return bitmap;
            }
            return null;
        }
        return null;
    }

    private Bitmap getBitmapFromMemoryCache(String url) {
        if (this.memoryCache != null) {
            return (Bitmap)this.memoryCache.get((Object)url);
        }
        return null;
    }

    private void putBitmapToMemoryCache(String url, Bitmap bitmap) {
        if (this.memoryCache != null) {
            this.memoryCache.put((Object)url, (Object)bitmap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap getBitmapFromDiskCache(String url) {
        Object object = this.diskCacheLock;
        synchronized (object) {
            if (this.diskCacheStarting) {
                return null;
            }
            return this.ocambaDiskCache != null && this.ocambaDiskCache.doesDiskCacheForKeyExist(url) ? this.ocambaDiskCache.getBitmapFromDiskCache(url) : null;
        }
    }

    private Bitmap downloadBitmap(Context context, String imageUri, int imageType) throws ExecutionException, InterruptedException {
        OcambaImageCallable callable = new OcambaImageCallable(context, imageUri, imageType);
        Future<Bitmap> future = OcambaThreadPool.getInstance().add(callable);
        return future.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBitmapToCache(String url, Bitmap bitmap) {
        if (this.getBitmapFromMemoryCache(url) == null && this.memoryCache != null) {
            this.memoryCache.put((Object)url, (Object)bitmap);
        }
        Object object = this.diskCacheLock;
        synchronized (object) {
            if (this.ocambaDiskCache != null && !this.ocambaDiskCache.doesDiskCacheForKeyExist(url)) {
                this.ocambaDiskCache.addBitmapToDiskCache(url, bitmap);
            }
        }
    }

    @Override
    public Bitmap getBitmapFromUrl(Context context, String url, int type) {
        try {
            Bitmap bitmap = this.getLocalBitmap(url);
            if (bitmap != null) {
                return bitmap;
            }
            bitmap = this.downloadBitmap(context, url, type);
            if (bitmap != null) {
                this.addBitmapToCache(url, bitmap);
            }
            return bitmap;
        }
        catch (Throwable t) {
            OcambaLogUtils.e(TAG, "Failed to get bitmap from url. Url: " + url + "][" + t.getMessage() + "]");
            OcambaRequest.postCrash(t.getMessage());
            return null;
        }
    }

    private static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return new File(cachePath + File.separator + uniqueName);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    class InitDiskCacheTask
    extends AsyncTask<File, Void, Void> {
        InitDiskCacheTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(File ... params) {
            Object object = OcambaLruImageLoader.this.diskCacheLock;
            synchronized (object) {
                File cacheDir = params[0];
                try {
                    OcambaLruImageLoader.this.ocambaDiskCache = new OcambaDiskCache(cacheDir, 1, 1, 0x500000L);
                }
                catch (Exception e) {
                    OcambaLogUtils.e(TAG, "Unable to create new disk cache. ", e);
                    OcambaRequest.postCrash(e.getMessage());
                }
                OcambaLruImageLoader.this.diskCacheStarting = false;
                OcambaLruImageLoader.this.diskCacheLock.notifyAll();
                return null;
            }
        }
    }
}

