/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.beacon;

import android.content.SharedPreferences;
import com.ocamba.hoood.OcambaPrefManager;
import com.ocamba.hoood.beacon.OcambaBeacon;
import java.util.Set;

class OcambaBeaconPrefManager
extends OcambaPrefManager {
    private static final String KEY_PREFIX_BEACON = "ocamba_beacon";
    private static final String KEY_BEACON_ID = "unique_id";
    private static final String KEY_NAMESPACE = "namespace_id";
    private static final String KEY_INSTANCE_ID = "instance_id";
    private static final String KEY_DISTANCE = "distance";
    private static final String KEY_TIME = "time";

    OcambaBeaconPrefManager() {
    }

    static void setBeaconsIds(Set<String> set) {
        OcambaBeaconPrefManager.setGeofenceOrBeaconIds(KEY_BEACON_ID, set);
    }

    private static void removeBeaconId(String value) {
        OcambaBeaconPrefManager.removeGeofenceOrBeaconId(KEY_BEACON_ID, value);
    }

    static Set<String> getBeaconId() {
        return OcambaBeaconPrefManager.getGeofenceOrBeaconId(KEY_BEACON_ID);
    }

    static void setBeacon(OcambaBeacon beacon) {
        if (OcambaBeaconPrefManager.getSharedPreferences() != null) {
            SharedPreferences.Editor prefsEditor = OcambaBeaconPrefManager.getSharedPreferences().edit();
            String id2 = beacon.getUniqueId();
            prefsEditor.putString(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_NAMESPACE), beacon.getNamespaceId());
            prefsEditor.putString(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_INSTANCE_ID), beacon.getInstanceId());
            prefsEditor.putLong(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_DISTANCE), (long)beacon.getDistance());
            prefsEditor.apply();
        }
    }

    static OcambaBeacon getBeacon(String id2) {
        if (OcambaBeaconPrefManager.getSharedPreferences() != null) {
            return new OcambaBeacon(id2, OcambaBeaconPrefManager.getSharedPreferences().getString(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_NAMESPACE), ""), OcambaBeaconPrefManager.getSharedPreferences().getString(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_INSTANCE_ID), ""), OcambaBeaconPrefManager.getSharedPreferences().getLong(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_DISTANCE), 0L));
        }
        return null;
    }

    static void clearBeacon(String id2) {
        if (OcambaBeaconPrefManager.getSharedPreferences() != null) {
            SharedPreferences.Editor prefsEditor = OcambaBeaconPrefManager.getSharedPreferences().edit();
            prefsEditor.remove(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_NAMESPACE));
            prefsEditor.remove(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_INSTANCE_ID));
            prefsEditor.remove(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, id2, KEY_DISTANCE));
            prefsEditor.apply();
            OcambaBeaconPrefManager.removeBeaconId(id2);
        }
    }

    static void setBeaconSentTime(String beaconId, long time) {
        if (OcambaBeaconPrefManager.getSharedPreferences() != null) {
            SharedPreferences.Editor editor = OcambaBeaconPrefManager.getSharedPreferences().edit();
            editor.putLong(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, beaconId, KEY_TIME), time);
            editor.apply();
        }
    }

    static long getBeaconSentTime(String beaconId) {
        if (OcambaBeaconPrefManager.getSharedPreferences() != null) {
            return OcambaBeaconPrefManager.getSharedPreferences().getLong(OcambaBeaconPrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX_BEACON, beaconId, KEY_TIME), 0L);
        }
        return 0L;
    }
}

