/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.geo;

import android.content.SharedPreferences;
import com.ocamba.hoood.OcambaPrefManager;
import com.ocamba.hoood.geo.OcambaGeofence;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class OcambaGeofencePrefManager
extends OcambaPrefManager {
    public static final String TAG = OcambaGeofencePrefManager.class.getSimpleName();
    private static final String KEY_PREFIX = "ocamba_geo";
    private static final String KEY_ID = "ocamba_geo_id";
    private static final String KEY_LATITUDE = "ocamba_latitude";
    private static final String KEY_LONGITUDE = "ocamba_longitude";
    private static final String KEY_RADIUS = "ocamba_radius";
    private static final String KEY_EXPIRATION_DURATION = "ocamba_expiration";
    private static final String KEY_TRANSITION_TYPE = "ocamba_transition";
    private static final String KEY_POLYGON = "ocamba_polygon";

    static void setGeofenceIds(Set<String> set) {
        OcambaGeofencePrefManager.setGeofenceOrBeaconIds(KEY_ID, set);
    }

    private static void removeGeofenceId(String value) {
        OcambaGeofencePrefManager.removeGeofenceOrBeaconId(KEY_ID, value);
    }

    public static Set<String> getGeofencesIds() {
        return OcambaGeofencePrefManager.getGeofenceOrBeaconId(KEY_ID);
    }

    static void setGeofence(OcambaGeofence geofence) {
        SharedPreferences shared = OcambaGeofencePrefManager.getSharedPreferences();
        if (shared != null) {
            try {
                SharedPreferences.Editor prefsEditor = shared.edit();
                String id2 = geofence.getId();
                prefsEditor.putFloat(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_LATITUDE), (float)geofence.getLatitude());
                prefsEditor.putFloat(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_LONGITUDE), (float)geofence.getLongitude());
                prefsEditor.putFloat(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_RADIUS), geofence.getRadius());
                prefsEditor.putLong(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_EXPIRATION_DURATION), geofence.getExpirationDuration());
                prefsEditor.putInt(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_TRANSITION_TYPE), geofence.getTransitionType());
                if (geofence.isPolygon()) {
                    prefsEditor.putStringSet(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_POLYGON), geofence.getPolygonSet());
                }
                prefsEditor.apply();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static OcambaGeofence getGeofence(String id2) {
        SharedPreferences shared = OcambaGeofencePrefManager.getSharedPreferences();
        if (shared != null) {
            try {
                OcambaGeofence ocambaGeofence = new OcambaGeofence(id2, shared.getFloat(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_LATITUDE), 0.0f), shared.getFloat(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_LONGITUDE), 0.0f), shared.getFloat(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_RADIUS), 0.0f), shared.getLong(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_EXPIRATION_DURATION), 0L), shared.getInt(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_TRANSITION_TYPE), 0));
                if (OcambaGeofencePrefManager.isGeofencePolygon(id2)) {
                    ArrayList<String> points = new ArrayList<String>(OcambaGeofencePrefManager.getGeofencePolygon(id2));
                    points.add(0, points.get(points.size() - 1));
                    ocambaGeofence.setPolygon(points);
                }
                return ocambaGeofence;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static boolean isGeofencePolygon(String id2) {
        SharedPreferences shared = OcambaGeofencePrefManager.getSharedPreferences();
        if (shared != null) {
            Set polygonPoints = shared.getStringSet(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_POLYGON), new HashSet());
            return polygonPoints != null && polygonPoints.size() > 0;
        }
        return false;
    }

    private static Set<String> getGeofencePolygon(String id2) {
        SharedPreferences shared = OcambaGeofencePrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getStringSet(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_POLYGON), new HashSet());
        }
        return new HashSet<String>();
    }

    public static void clearGeofence(String id2) {
        SharedPreferences shared = OcambaGeofencePrefManager.getSharedPreferences();
        if (shared != null) {
            SharedPreferences.Editor prefsEditor = shared.edit();
            prefsEditor.remove(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_LATITUDE));
            prefsEditor.remove(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_LONGITUDE));
            prefsEditor.remove(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_RADIUS));
            prefsEditor.remove(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_EXPIRATION_DURATION));
            prefsEditor.remove(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_TRANSITION_TYPE));
            prefsEditor.remove(OcambaGeofencePrefManager.getGeofenceOrBeaconFieldKey(KEY_PREFIX, id2, KEY_POLYGON));
            prefsEditor.apply();
            OcambaGeofencePrefManager.removeGeofenceId(id2);
        }
    }
}

