/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.util;

import android.util.Log;
import com.ocamba.hoood.OcambaHoood;
import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.util.OcambaLogUtils;

public class OcambaExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = OcambaExceptionHandler.class.getSimpleName();
    private Thread.UncaughtExceptionHandler mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();

    public static void init() {
        if (!(Thread.getDefaultUncaughtExceptionHandler() instanceof OcambaExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new OcambaExceptionHandler());
        }
    }

    private OcambaExceptionHandler() {
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (OcambaHoood.isSdkEnabled()) {
            OcambaRequest.postCrash(Log.getStackTraceString((Throwable)e), OcambaHoood.getBuilder().isCrashDisabled());
        } else {
            OcambaLogUtils.w(TAG, "uncaughtException() called with: t = [" + t + "], e = [" + e + "], but Ocamba Hoood SDK is disabled. Please, re-enable SDK to use Ocamba features.");
        }
        this.mDefaultHandler.uncaughtException(t, e);
    }
}

