/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.transport;

import android.content.Context;
import android.os.Build;
import com.ocamba.hoood.OcambaPrefManager;
import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.transport.OcambaResponseCallback;
import com.ocamba.hoood.util.OcambaLogUtils;
import com.ocamba.hoood.util.OcambaUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class OcambaSendRequest
implements Runnable {
    private static final String TAG = OcambaSendRequest.class.getSimpleName();
    public static final int CODE_INIT_USER = 0;
    public static final int CODE_TRACKER = 1;
    public static final int CODE_NOTIFICATION = 2;
    public static final int CODE_PATCH_USER_EXTRA_TRACK = 3;
    public static final int CODE_PATCH_USER_LOCATION = 4;
    public static final int CODE_PATCH_USER_APP_UPDATE = 5;
    public static final int CODE_UNSUBSCRIBE_USER = 6;
    public static final int CODE_INSTALL = 201;
    public static final int CODE_OPEN = 205;
    public static final int CODE_CRASH = 599;
    public static final int GEOFENCE_ENTER = 220;
    public static final int GEOFENCE_EXIT = 221;
    public static final int BEACON_PROXIMITY = 230;
    public static final int CODE_ENABLE_SDK = 240;
    public static final int BEACONS = 250;
    private Context mContext;
    private int mCode;
    private String mVar;
    private String mUrl;
    private OcambaResponseCallback iResponseCallback;
    private JSONObject mJsonObject;
    private String mUtm;

    public OcambaSendRequest(Context context, int code, String var, String url, OcambaResponseCallback responseCallback) {
        OcambaLogUtils.v(TAG, "OcambaSendRequest() called with:\ncode = [" + code + "],\nvar = [" + var + "],\nurl = [" + url + "]");
        this.mUtm = OcambaPrefManager.getUtm();
        this.mContext = context;
        this.mCode = code;
        this.mVar = var;
        this.mUrl = url;
        this.iResponseCallback = responseCallback;
    }

    public OcambaSendRequest(Context context, int code, String var, String url, OcambaResponseCallback responseCallback, JSONObject jsonObject) {
        OcambaLogUtils.v(TAG, "OcambaSendRequest() called with:\ncode = [" + code + "],\nvar = [" + var + "],\nurl = [" + url + "],\njsonObject = [" + jsonObject + "]");
        this.mUtm = OcambaPrefManager.getUtm();
        this.mContext = context;
        this.mCode = code;
        this.mVar = var;
        this.mUrl = url;
        this.iResponseCallback = responseCallback;
        this.mJsonObject = jsonObject;
    }

    @Override
    public void run() {
        if (this.mUtm.equals("")) {
            OcambaLogUtils.w("No api key provided.");
            return;
        }
        switch (this.mCode) {
            case 0: 
            case 201: 
            case 205: 
            case 220: 
            case 221: 
            case 230: 
            case 599: {
                this.post("POST");
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 240: {
                this.post("PUT");
                break;
            }
            case 1: 
            case 2: 
            case 250: {
                this.get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(String method) {
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(this.mUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod(method);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setConnectTimeout(5000);
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.connect();
            DataOutputStream wr = new DataOutputStream(urlConnection.getOutputStream());
            wr.writeBytes(this.jsonObject().toString());
            wr.flush();
            wr.close();
            if (this.iResponseCallback != null) {
                this.iResponseCallback.onResponse(urlConnection.getResponseCode(), urlConnection.getResponseMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.iResponseCallback != null) {
                this.iResponseCallback.onFailure(e);
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get() {
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(this.mUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("GET");
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setConnectTimeout(5000);
            urlConnection.connect();
            String response = urlConnection.getResponseMessage();
            if (this.mCode == 2) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                br.close();
                response = sb.toString();
            }
            if (this.iResponseCallback != null) {
                this.iResponseCallback.onResponse(urlConnection.getResponseCode(), response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.iResponseCallback != null) {
                this.iResponseCallback.onFailure(e);
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    private JSONObject jsonObject() {
        JSONObject postData = new JSONObject();
        try {
            switch (this.mCode) {
                case 0: {
                    this.setJsonData(postData);
                    this.setJsonExtraData(postData);
                    postData.put("token", (Object)this.mVar);
                    break;
                }
                case 3: 
                case 4: {
                    this.setJsonExtraData(postData);
                    postData.put("utm", (Object)this.mUtm);
                    postData.put("app", (Object)(this.mContext != null ? OcambaUtils.getAppPackageName(this.mContext) : ""));
                    postData.put("token", (Object)this.mVar);
                    break;
                }
                case 5: {
                    postData.put("utm", (Object)this.mUtm);
                    postData.put("app", (Object)(this.mContext != null ? OcambaUtils.getAppPackageName(this.mContext) : ""));
                    postData.put("token", (Object)this.mVar);
                    postData.put("app_version", (Object)(this.mContext != null ? OcambaUtils.getAppVersion(this.mContext) : ""));
                    postData.put("sdk_version", (Object)OcambaUtils.getSdkVersion());
                    break;
                }
                case 201: 
                case 205: {
                    this.setJsonData(postData);
                    postData.put("token", (Object)this.mVar);
                    postData.put("code", this.mCode);
                    break;
                }
                case 599: {
                    this.setJsonData(postData);
                    postData.put("tm", OcambaUtils.getTotalInternalMemorySize());
                    postData.put("am", OcambaUtils.getAvailableInternalMemorySize());
                    postData.put("msg", (Object)this.mVar);
                    break;
                }
                case 220: 
                case 221: 
                case 230: {
                    this.setJsonData(postData);
                    postData.put("token", (Object)OcambaPrefManager.getToken());
                    postData.put("id", (Object)this.mVar);
                    postData.put("code", this.mCode);
                    break;
                }
                case 6: 
                case 240: {
                    postData.put("token", (Object)OcambaPrefManager.getToken());
                    postData.put("utm", (Object)this.mUtm);
                    postData.put("app", (Object)(this.mContext != null ? OcambaUtils.getAppPackageName(this.mContext) : ""));
                    postData.put("push", (Object)this.mVar);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            OcambaRequest.postCrash(e.toString());
        }
        return postData;
    }

    private void setJsonData(JSONObject postData) throws JSONException {
        postData.put("app", (Object)(this.mContext != null ? OcambaUtils.getAppPackageName(this.mContext) : ""));
        postData.put("app_version", (Object)(this.mContext != null ? OcambaUtils.getAppVersion(this.mContext) : ""));
        postData.put("sdk_version", (Object)OcambaUtils.getSdkVersion());
        postData.put("os", (Object)"android");
        postData.put("version", (Object)Build.VERSION.RELEASE);
        postData.put("mfg", (Object)Build.MANUFACTURER);
        postData.put("model", (Object)Build.MODEL);
        postData.put("sdk", Build.VERSION.SDK_INT);
        postData.put("ts_current", System.currentTimeMillis() / 1000L);
        postData.put("lang", (Object)Locale.getDefault().getDisplayLanguage());
        postData.put("utm", (Object)this.mUtm);
    }

    private void setJsonExtraData(JSONObject postData) throws JSONException {
        if (this.mJsonObject != null && this.mJsonObject.length() > 0) {
            postData.put("e", (Object)this.mJsonObject);
        }
    }
}

