/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood;

import android.app.Application;
import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.media.session.MediaSessionCompat;
import android.widget.RemoteViews;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.RemoteMessage;
import com.ocamba.hoood.OcambaPrefManager;
import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.images.OcambaLruImageLoader;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.ocamba.hoood.notifications.OcambaNotificationRenderer;
import com.ocamba.hoood.transport.OcambaResponseCallback;
import com.ocamba.hoood.util.OcambaAnalytics;
import com.ocamba.hoood.util.OcambaExceptionHandler;
import com.ocamba.hoood.util.OcambaLogUtils;
import com.ocamba.hoood.util.OcambaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class OcambaHoood {
    private static final String TAG = OcambaHoood.class.getSimpleName();
    private OcambaHoood mOcambaHoood;
    private static Context mContext;
    private static String mToken;
    private static ConcurrentHashMap<String, Object> mTrackMap;
    private static Builder mOcambaBuilder;
    private static Notification mOcambaNotification;
    private static OcambaLruImageLoader sOcambaLruImageLoader;
    private static OcambaResponseCallback iOcambaResponseCallback;
    private static MediaSessionCompat sMediaSessionCompat;
    private static OcambaAnalytics sOcambaAnalytics;
    private static boolean sInitialized;
    static boolean mSendUser;

    public OcambaHoood() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setContextProvider(Context context) {
        if (context == null) {
            return;
        }
        if (this.mOcambaHoood == null) {
            Class<OcambaHoood> clazz = OcambaHoood.class;
            synchronized (OcambaHoood.class) {
                OcambaLogUtils.i(TAG, "init new");
                this.mOcambaHoood = new OcambaHoood(context);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            OcambaLogUtils.i(TAG, "init exist");
        }
    }

    private OcambaHoood(Context context) {
        try {
            mContext = context;
            if (context == null) {
                return;
            }
            OcambaPrefManager.setSharedPreferences(context);
            sOcambaLruImageLoader = new OcambaLruImageLoader(context);
            if (OcambaUtils.isMediaSessionCompatPresent()) {
                sMediaSessionCompat = new MediaSessionCompat(context, TAG);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void init(Builder builder, String apiKey) {
        try {
            if (mContext == null) {
                return;
            }
            sOcambaAnalytics = new OcambaAnalytics();
            ((Application)OcambaHoood.getContext().getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sOcambaAnalytics);
            mToken = OcambaPrefManager.getToken();
            mOcambaBuilder = builder;
            OcambaHoood.initApiKey(apiKey);
            OcambaHoood.initPush(mOcambaBuilder.mPush);
            if (mOcambaBuilder.mCrash) {
                OcambaHoood.initCrash();
            }
            if (mOcambaBuilder.mBeacon) {
                OcambaHoood.initBeacon();
            }
            OcambaHoood.setUniqueId();
            OcambaRequest.patchUserEnabledSdk(true);
            sInitialized = true;
            OcambaHoood.notification().showReceivedMessages();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initApiKey(String apiKey) {
        String aKey = apiKey == null || apiKey.equals("") ? OcambaUtils.getApiKey(OcambaHoood.getContext()) : apiKey;
        OcambaLogUtils.i(TAG, "Api Key: " + aKey);
        if (aKey == null || aKey.equals("")) {
            return;
        }
        OcambaPrefManager.setUtm(aKey);
    }

    public static void sendAnalytics() {
        try {
            if (!OcambaHoood.getBuilder().isAnalyticDisabled()) {
                if (!OcambaHoood.isSdkEnabled()) {
                    OcambaLogUtils.w(TAG, "sendAnalytics() called, but Ocamba Hoood SDK is disabled. Please, re-enable SDK to use Ocamba features.");
                    return;
                }
                if (OcambaPrefManager.isAppFirstLaunch()) {
                    if (mToken.equals("") && OcambaUtils.isFirebasePresent()) {
                        FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<InstanceIdResult>(){

                            public void onSuccess(InstanceIdResult instanceIdResult) {
                                mToken = instanceIdResult.getToken();
                                OcambaPrefManager.setToken(mToken);
                                OcambaRequest.postActivity(201);
                                OcambaRequest.postActivity(205);
                            }
                        });
                    } else {
                        OcambaRequest.postActivity(201);
                        OcambaRequest.postActivity(205);
                    }
                } else {
                    OcambaRequest.postActivity(205);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initPush(boolean initializePush) {
        if (!OcambaNotificationRenderer.canShowNotifications(OcambaHoood.getContext())) {
            OcambaHoood.unsubscribeUser(mToken);
            OcambaLogUtils.e(TAG, "Notifications are disabled or channel 'Ocamba Push'!");
            return;
        }
        boolean isPushInitializedBefore = OcambaPrefManager.isPushInitialized();
        if (initializePush) {
            if (!OcambaUtils.isFirebasePresent()) {
                return;
            }
            if (!isPushInitializedBefore) {
                if (mToken.equals("")) {
                    FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<InstanceIdResult>(){

                        public void onSuccess(InstanceIdResult instanceIdResult) {
                            mToken = instanceIdResult.getToken();
                            OcambaPrefManager.setToken(mToken);
                            OcambaHoood.sendUser(mToken);
                        }
                    });
                } else {
                    OcambaHoood.sendUser(mToken);
                }
            } else {
                if (OcambaPrefManager.isUserUnsubscribed(mToken)) {
                    OcambaHoood.subscribeUser(mToken);
                }
                if (!(mContext == null || OcambaPrefManager.getAppVersion().equals("") || OcambaPrefManager.getAppVersion().equals(OcambaUtils.getAppVersion(mContext)) || mToken.equals(""))) {
                    OcambaRequest.patchUserAppUpdate(mToken);
                }
            }
        }
    }

    private static void initCrash() {
        OcambaLogUtils.d(TAG, "initCrash() called");
        OcambaExceptionHandler.init();
    }

    private static void initBeacon() {
        OcambaLogUtils.d(TAG, "initBeacon() called");
    }

    private static void setUniqueId() {
        if (OcambaPrefManager.getUniqueId().equals("")) {
            String uniqueID = UUID.randomUUID().toString();
            OcambaLogUtils.i(TAG, "New unique ID is: [" + uniqueID + "]");
            OcambaPrefManager.setUniqueId(uniqueID);
        } else {
            OcambaLogUtils.d(TAG, "Unique ID is: [" + OcambaPrefManager.getUniqueId() + "]");
        }
    }

    public static void track(String key, String value) {
        try {
            OcambaLogUtils.d(TAG, "Tracker key: " + key + ", value: " + value);
            if (OcambaHoood.getBuilder().isPushDisabled()) {
                OcambaLogUtils.w(TAG, "Push is disabled!");
                return;
            }
            mTrackMap.put(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void track(String key, int value) {
        try {
            OcambaLogUtils.d(TAG, "Tracker key: " + key + ", value: " + value);
            if (OcambaHoood.getBuilder().isPushDisabled()) {
                OcambaLogUtils.w(TAG, "Push is disabled!");
                return;
            }
            mTrackMap.put(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void track(HashMap<String, Object> hashMap) {
        try {
            OcambaLogUtils.d(TAG, "Tracker key: " + hashMap.size());
            if (OcambaHoood.getBuilder().isPushDisabled()) {
                OcambaLogUtils.w(TAG, "Push is disabled!");
                return;
            }
            if (Build.VERSION.SDK_INT >= 19) {
                for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
                    if (JSONObject.wrap((Object)entry.getValue()) == null) {
                        JSONObject object = new JSONObject();
                        object.put(entry.getKey(), entry.getValue());
                        OcambaHoood.track(object);
                        continue;
                    }
                    mTrackMap.put(entry.getKey(), entry.getValue());
                }
            } else {
                mTrackMap.putAll(hashMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void track(JSONObject jsonObject) {
        try {
            OcambaLogUtils.d(TAG, "Tracker key: " + jsonObject.length());
            if (OcambaHoood.getBuilder().isPushDisabled()) {
                OcambaLogUtils.w(TAG, "Push is disabled!");
                return;
            }
            Iterator keysItr = jsonObject.keys();
            while (keysItr.hasNext()) {
                String key = (String)keysItr.next();
                String value = String.valueOf(jsonObject.get(key));
                mTrackMap.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeTrack() {
        if (mTrackMap != null) {
            mTrackMap.clear();
        }
    }

    public static void removeTrack(String key) {
        if (mTrackMap != null && mTrackMap.containsKey(key)) {
            mTrackMap.remove(key);
        } else {
            OcambaLogUtils.w(TAG, "This key not exist!");
        }
    }

    public static void sendTrack() {
        OcambaHoood.sendTrack(null);
    }

    public static void sendTrack(OcambaResponseCallback ocambaResponseCallback) {
        if (OcambaHoood.getBuilder().isPushDisabled()) {
            OcambaLogUtils.w(TAG, "Push is disabled!");
            return;
        }
        if (!OcambaHoood.isSdkEnabled()) {
            OcambaLogUtils.w(TAG, "sendTrack() called, , but Ocamba Hoood SDK is disabled. Please, re-enable SDK to use Ocamba features.");
            return;
        }
        if (mToken != null && !mToken.equals("")) {
            try {
                OcambaRequest.patchUserExtraTrack(mToken, new JSONObject(mTrackMap), ocambaResponseCallback);
            }
            catch (Exception e) {
                OcambaRequest.postCrash(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static String getTrack() {
        if (mTrackMap != null) {
            return mTrackMap.toString();
        }
        return "";
    }

    public static String getTrack(String key) {
        OcambaLogUtils.d(TAG, "getTrack() called with: key = [" + key + "]");
        try {
            if (mTrackMap != null && mTrackMap.containsKey(key)) {
                return mTrackMap.get(key).toString();
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void trackLocation(Location location) {
        try {
            if (OcambaHoood.getBuilder().isPushDisabled()) {
                OcambaLogUtils.w(TAG, "Push is disabled!");
                return;
            }
            if (!OcambaHoood.isSdkEnabled()) {
                OcambaLogUtils.w(TAG, "trackLocation() called with: location = [" + location + "], but Ocamba Hoood SDK is disabled. Please, re-enable SDK to use Ocamba features.");
                return;
            }
            mTrackMap.put("lat", location.getLatitude());
            mTrackMap.put("lng", location.getLongitude());
            if (mToken != null && !mToken.equals("")) {
                OcambaLogUtils.i(TAG, "SendLocationUpdate: " + location);
                OcambaRequest.patchUserLocationTrack(mToken, new JSONObject(mTrackMap));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int countNotifications() {
        return OcambaPrefManager.getNotificationCount();
    }

    public static void setCountNotifications(int count) {
        OcambaUtils.setBadgeCount(OcambaHoood.getContext(), OcambaPrefManager.getNotificationCount() + count);
    }

    private static synchronized void sendUser(String token) {
        try {
            OcambaLogUtils.v(TAG, "sendUser() called with: token = [" + token + "]");
            if (!OcambaNotificationRenderer.canShowNotifications(OcambaHoood.getContext())) {
                OcambaLogUtils.e(TAG, "Notifications are disabled or channel 'Ocamba Push'!");
                OcambaHoood.unsubscribeUser(token);
                return;
            }
            if (!OcambaHoood.isSdkEnabled()) {
                OcambaLogUtils.w(TAG, "sendUser() called with: token = [" + token + "], but Ocamba Hoood SDK is disabled. Please, re-enable SDK to use Ocamba features.");
                return;
            }
            if (mSendUser && token != null) {
                if (OcambaHoood.getBuilder().isPushDisabled()) {
                    OcambaLogUtils.e(TAG, "Push is disabled!");
                    return;
                }
                if (!token.equals(mToken)) {
                    mToken = token;
                }
                if (mToken.equals("")) {
                    OcambaLogUtils.e(TAG, "Token cannot be empty String!");
                    return;
                }
                mSendUser = false;
                OcambaLogUtils.d(TAG, "FCM token: " + mToken);
                if (mContext != null) {
                    OcambaPrefManager.setAppVersion(OcambaUtils.getAppVersion(mContext));
                }
                OcambaRequest.postUser(mToken, iOcambaResponseCallback);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static synchronized void subscribeUser(String token) {
        OcambaHoood.updateUserSubscriptionStatus(token, true);
    }

    private static synchronized void unsubscribeUser(String token) {
        OcambaHoood.updateUserSubscriptionStatus(token, false);
    }

    private static synchronized void updateUserSubscriptionStatus(String token, boolean isSubscribed) {
        OcambaLogUtils.d(TAG, "updateUserSubscriptionStatus() called with: token = [" + token + "], isSubscribed = [" + isSubscribed + "]");
        try {
            if (token != null) {
                if (!isSubscribed && OcambaPrefManager.isUserUnsubscribed(token)) {
                    OcambaLogUtils.i(TAG, "This user is already unsubscribed. [" + token + "]");
                    return;
                }
                if (!OcambaPrefManager.isPushInitialized()) {
                    OcambaLogUtils.w(TAG, "This token [" + token + "] hasn't been subscribed.");
                    return;
                }
                if (!token.equals(mToken)) {
                    mToken = token;
                }
                if (mToken.equals("")) {
                    OcambaLogUtils.e(TAG, "Token cannot be empty String!");
                    return;
                }
                OcambaRequest.patchUpdateSubscription(isSubscribed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Context getContext() {
        return mContext;
    }

    public static MediaSessionCompat getMediaSessionCompat() {
        return sMediaSessionCompat;
    }

    public static String getFcmToken() {
        try {
            if (OcambaHoood.getBuilder().isPushDisabled()) {
                OcambaLogUtils.e(TAG, "Push is disabled!");
                return "Push is disabled!";
            }
            if (!OcambaNotificationRenderer.canShowNotifications(OcambaHoood.getContext())) {
                OcambaLogUtils.e(TAG, "Notifications are disabled or channel 'Ocamba Push'!");
                return "Notifications are disabled or channel 'Ocamba Push'!";
            }
            mToken = OcambaPrefManager.getToken();
            if (!OcambaUtils.isFirebasePresent()) {
                return mToken;
            }
            if (mToken.equals("") && !FirebaseApp.getApps((Context)OcambaHoood.getContext()).isEmpty()) {
                FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

                    public void onComplete(@NonNull Task<InstanceIdResult> task) {
                        if (!task.isSuccessful()) {
                            OcambaLogUtils.w(TAG, "getInstanceId failed: " + task.getException());
                            return;
                        }
                        if (task.getResult() != null) {
                            mToken = ((InstanceIdResult)task.getResult()).getToken();
                            OcambaLogUtils.d(TAG, "getInstanceId mToken: " + mToken);
                        }
                    }
                });
            }
            return mToken;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static OcambaLruImageLoader getOcambaLruImageLoader() {
        return sOcambaLruImageLoader;
    }

    public static Builder getBuilder() {
        if (mOcambaBuilder == null) {
            mOcambaBuilder = new Builder();
        }
        return mOcambaBuilder;
    }

    public static Notification notification() {
        if (mOcambaNotification == null) {
            mOcambaNotification = new Notification();
        }
        return mOcambaNotification;
    }

    public static Builder analytics(boolean analytics) {
        mOcambaBuilder = OcambaHoood.getBuilder();
        return mOcambaBuilder.analytics(analytics);
    }

    public static Builder push() {
        mOcambaBuilder = OcambaHoood.getBuilder();
        return mOcambaBuilder.push();
    }

    public static Builder push(boolean badge) {
        mOcambaBuilder = OcambaHoood.getBuilder();
        return mOcambaBuilder.push(badge);
    }

    public static Builder setPushResponse(OcambaResponseCallback ocambaResponseCallback) {
        mOcambaBuilder = OcambaHoood.getBuilder();
        return mOcambaBuilder.setPushResponse(ocambaResponseCallback);
    }

    public static Builder crash() {
        mOcambaBuilder = OcambaHoood.getBuilder();
        return mOcambaBuilder.crash();
    }

    public static Builder geofence() {
        mOcambaBuilder = OcambaHoood.getBuilder();
        return mOcambaBuilder.geofence();
    }

    public static Builder becons() {
        mOcambaBuilder = OcambaHoood.getBuilder();
        return mOcambaBuilder.beacons();
    }

    public static Builder trackLocation() {
        mOcambaBuilder = OcambaHoood.getBuilder();
        return mOcambaBuilder.trackLocation();
    }

    public static void enableSdk() {
        try {
            if (mOcambaBuilder == null) {
                OcambaLogUtils.w(TAG, "enableSdk() called, but Ocamba Hoood SDK is disabled. Please, re-enable SDK to use Ocamba features.");
                return;
            }
            if (sInitialized) {
                OcambaHoood.setSdkEnabled(true);
                ((Application)OcambaHoood.getContext().getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sOcambaAnalytics);
                if (!mOcambaBuilder.isGeofenceDisabled() || !mOcambaBuilder.isTrackLocationDisabled()) {
                    sOcambaAnalytics.initLocationTracking();
                    sOcambaAnalytics.requestLocationUpdates();
                }
            } else {
                OcambaLogUtils.w(TAG, "enableSdk() called, , but Ocamba Hoood is not initialized.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void disableSdk() {
        try {
            if (mOcambaBuilder == null) {
                OcambaLogUtils.w(TAG, "disableSdk() called, but Ocamba Hoood SDK is disabled. Please, re-enable SDK to use Ocamba features.");
                return;
            }
            if (sInitialized) {
                OcambaHoood.setSdkEnabled(false);
                if (!mOcambaBuilder.isGeofenceDisabled() || !mOcambaBuilder.isTrackLocationDisabled()) {
                    sOcambaAnalytics.removeLocationUpdates();
                }
                ((Application)OcambaHoood.getContext().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sOcambaAnalytics);
            } else {
                OcambaLogUtils.w(TAG, "disableSdk() called, but Ocamba Hoood is not initialized.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setSdkEnabled(boolean isEnabled) {
        OcambaLogUtils.d(TAG, "setSdkEnabled() called with: isEnabled = [" + isEnabled + "]");
        OcambaRequest.patchUserEnabledSdk(isEnabled);
        OcambaHoood.getBuilder().enableSdk(isEnabled);
    }

    public static boolean isSdkEnabled() {
        return OcambaHoood.getBuilder().isSdkEnabled();
    }

    public static void fineLocationPermissionGranted() {
        try {
            if (!OcambaHoood.isSdkEnabled()) {
                OcambaLogUtils.w(TAG, "fineLocationPermissionGranted() called, but Ocamba Hoood SDK is disabled. Please, re-enable SDK to use Ocamba features.");
                return;
            }
            OcambaLogUtils.d(TAG, "fineLocationPermissionGranted() called");
            if (OcambaHoood.getBuilder().isGeofenceDisabled() && OcambaHoood.getBuilder().isTrackLocationDisabled()) {
                OcambaLogUtils.w(TAG, "Neither geofence or location tracking is enabled in Ocamba Hoood SDK.");
                return;
            }
            if (!OcambaUtils.checkLocationPermissions(mContext)) {
                OcambaLogUtils.d(TAG, "fineLocationPermissionGranted() called, but ACCESS_FINE_LOCATION permission not granted!.");
                return;
            }
            if (sOcambaAnalytics != null) {
                sOcambaAnalytics.initLocationTracking();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() {
        mOcambaBuilder = OcambaHoood.getBuilder();
        mOcambaBuilder.init();
    }

    public static void init(String apiKey) {
        mOcambaBuilder = OcambaHoood.getBuilder();
        mOcambaBuilder.init(apiKey);
    }

    public static void resetPushCallback() {
        OcambaLogUtils.d(TAG, "resetPushCallback() called");
        iOcambaResponseCallback = null;
    }

    static {
        mTrackMap = new ConcurrentHashMap();
        sInitialized = false;
        mSendUser = true;
    }

    public static class Notification {
        private static boolean mCustomLayout = false;
        private static boolean mCustomTrack = false;
        private static boolean mCustomActionButtons = false;
        private static ArrayList<RemoteMessage> remoteMessageList = new ArrayList();

        private Notification() {
        }

        public void customLayout() {
            mCustomLayout = true;
        }

        void showReceivedMessages() {
            for (RemoteMessage m : remoteMessageList) {
                this.onMessageReceived(m);
            }
            remoteMessageList.clear();
        }

        public void customTrack() {
            mCustomTrack = true;
            this.customLayout();
        }

        public boolean isCustomLayout() {
            return mCustomLayout;
        }

        public boolean isCustomTrack() {
            return mCustomTrack;
        }

        public boolean isOcambaMessage(RemoteMessage remoteMessage) {
            return OcambaUtils.isOcambaMessage(remoteMessage);
        }

        public void createCustomNotification(RemoteViews collapsedView, RemoteViews expandedView, OcambaNotificationObject ocambaNotificationObject) {
            if (OcambaHoood.getContext() != null && mCustomLayout) {
                new OcambaNotificationRenderer(OcambaHoood.getContext()).createCustomUserNotification(collapsedView, expandedView, ocambaNotificationObject);
            }
        }

        public void customActionButtons() {
            mCustomActionButtons = true;
        }

        public boolean isCustomActionButtons() {
            return mCustomActionButtons;
        }

        public void pushToken(String token) {
            try {
                OcambaLogUtils.d(TAG, "pushToken() called with: token = [" + token + "]");
                OcambaPrefManager.setPushInitialized(false);
                OcambaPrefManager.setToken(token);
                OcambaHoood.sendUser(token);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onMessageReceived(RemoteMessage remoteMessage) {
            try {
                if (OcambaHoood.isSdkEnabled()) {
                    if (OcambaHoood.getBuilder().isPushDisabled()) {
                        remoteMessageList.add(remoteMessage);
                    } else {
                        OcambaUtils.sentNotificationMessage(remoteMessage);
                    }
                } else {
                    OcambaLogUtils.w(TAG, "onMessageReceived() called with: remoteMessage = [" + remoteMessage + "], but Ocamba Hoood SDK is disabled. Please, re-enable SDK to use Ocamba features.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class Builder {
        private boolean mAnalytics = true;
        private boolean mCrash = false;
        private boolean mPush = false;
        private boolean mGeofence = false;
        private boolean mBeacon = false;
        private boolean mBadge = false;
        private boolean mTrackLocation = false;
        private boolean mEnableSdk = true;

        private Builder() {
        }

        public Builder analytics(boolean set) {
            this.mAnalytics = set;
            return this;
        }

        public Builder push() {
            this.mPush = true;
            return this;
        }

        public Builder push(boolean badge) {
            this.mBadge = badge;
            this.mPush = true;
            return this;
        }

        public Builder crash() {
            this.mCrash = true;
            return this;
        }

        public Builder geofence() {
            this.mGeofence = true;
            return this;
        }

        public Builder beacons() {
            this.mBeacon = true;
            return this;
        }

        public Builder trackLocation() {
            this.mTrackLocation = true;
            return this;
        }

        private void enableSdk(boolean enable) {
            this.mEnableSdk = enable;
        }

        public Builder setPushResponse(OcambaResponseCallback ocambaResponseCallback) {
            try {
                iOcambaResponseCallback = ocambaResponseCallback;
                OcambaLogUtils.d(TAG, "setPushResponse() Is push initialized: " + OcambaPrefManager.isPushInitialized());
                if (!OcambaNotificationRenderer.canShowNotifications(OcambaHoood.getContext())) {
                    if (iOcambaResponseCallback != null) {
                        iOcambaResponseCallback.onResponse(401, "Fail : Firebase is not present!");
                    }
                    return this;
                }
                if (!OcambaUtils.isFirebasePresent()) {
                    if (iOcambaResponseCallback != null) {
                        iOcambaResponseCallback.onResponse(401, "Fail : Firebase is not present!");
                    }
                    return this;
                }
                FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

                    public void onComplete(@NonNull Task<InstanceIdResult> task) {
                        if (!task.isSuccessful()) {
                            OcambaLogUtils.w(TAG, "getInstanceId failed: " + task.getException());
                            return;
                        }
                        if (task.getResult() != null && OcambaPrefManager.isPushInitialized() && OcambaPrefManager.getToken().equals(((InstanceIdResult)task.getResult()).getToken()) && iOcambaResponseCallback != null) {
                            iOcambaResponseCallback.onResponse(201, "Success");
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }

        public void init() {
            this.init(null);
        }

        public void init(String apiKey) {
            OcambaHoood.init(this, apiKey);
        }

        public boolean isAnalyticDisabled() {
            return !this.mAnalytics;
        }

        public boolean isPushDisabled() {
            return !this.mPush;
        }

        public boolean isCrashDisabled() {
            return !this.mCrash;
        }

        public boolean isGeofenceDisabled() {
            return !this.mGeofence;
        }

        public boolean isBeaconsDisabled() {
            return !this.mBeacon;
        }

        public boolean isBadgeDisabled() {
            return !this.mBadge;
        }

        public boolean isTrackLocationDisabled() {
            return !this.mTrackLocation;
        }

        private boolean isSdkEnabled() {
            return this.mEnableSdk;
        }
    }
}

