/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.geo;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.support.annotation.RequiresApi;
import com.google.android.gms.location.LocationResult;
import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.geo.OcambaGeofence;
import com.ocamba.hoood.geo.OcambaGeofencePolygonUtils;
import com.ocamba.hoood.geo.OcambaGeofencePrefManager;
import com.ocamba.hoood.util.OcambaLogUtils;

public class OcambaLocationUpdateBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = OcambaLocationUpdateBroadcastReceiver.class.getSimpleName();

    @RequiresApi(api=16)
    public void onReceive(Context context, Intent intent) {
        if (LocationResult.hasResult((Intent)intent)) {
            String geofenceId = intent.getAction();
            LocationResult locationResult = LocationResult.extractResult((Intent)intent);
            Location location = locationResult.getLastLocation();
            if (location != null) {
                OcambaLogUtils.d(TAG, "lat: " + location.getLatitude() + " lon: " + location.getLongitude());
                OcambaGeofence geofence = OcambaGeofencePrefManager.getGeofence(geofenceId);
                if (geofence == null) {
                    OcambaLogUtils.w(TAG, "onReceive() called but Ocamba Geofence object is null! Returning.");
                    return;
                }
                if (!geofence.isPolygon()) {
                    return;
                }
                if (OcambaGeofencePolygonUtils.containsLocation(location.getLatitude(), location.getLongitude(), geofence.getPolygonLatLng(), true)) {
                    OcambaLogUtils.w(TAG, "POLYGON ENTER, id = [" + geofenceId + "]");
                    OcambaRequest.geofenceTransition(220, geofenceId);
                }
            }
        }
    }
}

