/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.infra.inappupdate.internals;

import android.app.Activity;
import com.google.android.play.core.appupdate.AppUpdateInfo;
import com.google.android.play.core.appupdate.AppUpdateManager;
import com.google.android.play.core.appupdate.AppUpdateOptions;
import com.google.android.play.core.tasks.Task;
import com.taboola.android.infra.inappupdate.Configuration;
import com.taboola.android.infra.inappupdate.InAppUpdateException;
import com.taboola.android.infra.inappupdate.TriggerEventsCallback;
import com.taboola.android.infra.inappupdate.UpdateFlowException;
import com.taboola.android.infra.utilities.Executor2;

abstract class UpdateRunner
implements Runnable {
    private final Executor2 uiExecutor;
    private final AppUpdateInfo updateInfo;
    private final Configuration configuration;
    private final TriggerEventsCallback callback;
    private final AppUpdateManager appUpdateManager;
    private final Activity activity;

    public UpdateRunner(Executor2 uiExecutor, AppUpdateInfo updateInfo, Configuration configuration, TriggerEventsCallback callback, AppUpdateManager appUpdateManager, Activity activity) {
        this.uiExecutor = uiExecutor;
        this.updateInfo = updateInfo;
        this.configuration = configuration;
        this.callback = callback;
        this.appUpdateManager = appUpdateManager;
        this.activity = activity;
    }

    @Override
    public void run() {
        AppUpdateOptions appUpdateOptions = AppUpdateOptions.defaultOptions((int)this.configuration.getUpdateType());
        Task flowResult = this.appUpdateManager.startUpdateFlow(this.updateInfo, this.activity, appUpdateOptions);
        flowResult.addOnCompleteListener(this.uiExecutor::submit, task -> {
            try {
                if (!task.isSuccessful()) {
                    throw new UpdateFlowException("started with disallowed update type", InAppUpdateException.ErrorCode.UPDATE_NOT_STARTED);
                }
                int result = (Integer)task.getResult();
                if (result != -1) {
                    throw new UpdateFlowException("failed with error " + result, this.getErrorCode(result));
                }
                this.callback.onUserAcceptedUpdate();
                this.startMonitoringUpdateInProgress();
            }
            catch (InAppUpdateException e) {
                this.callback.onUpdateFlowFailed(e);
            }
        });
    }

    private InAppUpdateException.ErrorCode getErrorCode(int result) {
        if (result == 1) {
            return InAppUpdateException.ErrorCode.UPDATE_FAILED;
        }
        if (result == 0) {
            return InAppUpdateException.ErrorCode.UPDATE_CANCELLED;
        }
        return InAppUpdateException.ErrorCode.ERROR_UNEXPECTED;
    }

    protected abstract void startMonitoringUpdateInProgress();
}

