/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.infra.inappupdate.internals;

import androidx.annotation.AnyThread;
import androidx.core.util.Consumer;
import com.google.android.play.core.appupdate.AppUpdateInfo;
import com.google.android.play.core.appupdate.AppUpdateManager;
import com.google.android.play.core.install.InstallState;
import com.google.android.play.core.install.InstallStateUpdatedListener;
import com.google.android.play.core.install.model.InstallStatus;
import com.google.android.play.core.tasks.Task;
import com.taboola.android.infra.inappupdate.InAppUpdateException;
import com.taboola.android.infra.inappupdate.TriggerEventsCallback;
import com.taboola.android.infra.inappupdate.UpdateFlowException;
import com.taboola.android.infra.utilities.Executor2;
import java.util.Locale;

class UpdateInProgressMonitor
implements Runnable {
    private final Executor2 uiExecutor;
    private final TriggerEventsCallback callback;
    private final AppUpdateManager updateManager;
    private final InstallStateUpdatedListener installStateUpdatedListener;

    UpdateInProgressMonitor(Executor2 uiExecutor, TriggerEventsCallback callback, AppUpdateManager updateManager) {
        this.uiExecutor = uiExecutor;
        this.callback = callback;
        this.updateManager = updateManager;
        this.installStateUpdatedListener = state -> {
            int status = state.installStatus();
            switch (status) {
                case 2: {
                    long bytesDownloaded = state.bytesDownloaded();
                    long totalBytesToDownload = state.totalBytesToDownload();
                    this.notifyCaller((Consumer<TriggerEventsCallback>)((Consumer)it -> it.onDownloadProgress(bytesDownloaded, totalBytesToDownload)));
                    break;
                }
                case 11: {
                    this.notifyCaller((Consumer<TriggerEventsCallback>)((Consumer)cb -> cb.onUpdateReadyToInstall(() -> {
                        Task completeUpdate = this.updateManager.completeUpdate();
                        completeUpdate.addOnCompleteListener(task -> {
                            if (!task.isSuccessful()) {
                                this.notifyCaller((Consumer<TriggerEventsCallback>)((Consumer)it -> it.onUpdateFlowFailed(new InAppUpdateException(task.getException(), InAppUpdateException.ErrorCode.ERROR_UNEXPECTED))));
                            } else {
                                this.notifyCaller((Consumer<TriggerEventsCallback>)((Consumer)TriggerEventsCallback::onUpdateCompleted));
                            }
                        });
                    })));
                    this.onFinalState();
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    this.notifyCaller((Consumer<TriggerEventsCallback>)((Consumer)TriggerEventsCallback::onInstalling));
                    this.onFinalState();
                    break;
                }
                default: {
                    this.notifyCaller((Consumer<TriggerEventsCallback>)((Consumer)it -> it.onUpdateFlowFailed(new UpdateFlowException(String.format(Locale.US, "install monitor reported failure: state=%d code=%s", status, state.installErrorCode()), this.getErrorCode(status)))));
                    this.onFinalState();
                }
            }
        };
    }

    private InAppUpdateException.ErrorCode getErrorCode(@InstallStatus int status) {
        if (status == 6) {
            return InAppUpdateException.ErrorCode.UPDATE_CANCELLED;
        }
        return InAppUpdateException.ErrorCode.UPDATE_FAILED;
    }

    @Override
    public void run() {
        this.updateManager.getAppUpdateInfo().addOnSuccessListener(info -> {
            int availability = info.updateAvailability();
            if (availability != 3) {
                this.notifyCaller((Consumer<TriggerEventsCallback>)((Consumer)it -> it.onPreconditionsCheckFailed(new UpdateFlowException("unexpected availability at this point: " + availability, InAppUpdateException.ErrorCode.ERROR_UNEXPECTED))));
            }
            this.updateManager.registerListener(this.installStateUpdatedListener);
            this.installStateUpdatedListener.onStateUpdate((Object)this.createInstallState((AppUpdateInfo)info));
        });
    }

    private InstallState createInstallState(final AppUpdateInfo info) {
        return new InstallState(){

            public int installStatus() {
                return info.installStatus();
            }

            public long bytesDownloaded() {
                return info.bytesDownloaded();
            }

            public long totalBytesToDownload() {
                return info.totalBytesToDownload();
            }

            public int installErrorCode() {
                return 0;
            }

            public String packageName() {
                return info.packageName();
            }
        };
    }

    private void onFinalState() {
        this.updateManager.unregisterListener(this.installStateUpdatedListener);
    }

    @AnyThread
    private void notifyCaller(Consumer<TriggerEventsCallback> withCallback) {
        this.uiExecutor.submit(() -> withCallback.accept((Object)this.callback));
    }
}

