/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.infra.inappupdate.internals;

import android.annotation.SuppressLint;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.arch.core.util.Function;
import androidx.core.util.Consumer;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.google.android.play.core.appupdate.AppUpdateInfo;
import com.google.android.play.core.tasks.Task;
import com.taboola.android.infra.inappupdate.Configuration;
import com.taboola.android.infra.inappupdate.InAppUpdateException;
import com.taboola.android.infra.inappupdate.PreconditionNotMetException;
import com.taboola.android.infra.inappupdate.TriggerEventsCallback;
import com.taboola.android.infra.inappupdate.internals.AppData;
import com.taboola.android.infra.persistence.PersistentResource;
import com.taboola.android.infra.utilities.Executor2;
import java.util.Date;
import java.util.concurrent.TimeUnit;

@SuppressLint(value={"Assert"})
abstract class PreconditionsChecker
implements Runnable {
    @Nullable
    private final Configuration maybeConfiguration;
    private final TriggerEventsCallback triggerEventsCallback;
    private final Executor2 uiExecutor;
    private final PersistentResource<Long> lastAppearanceTime;
    private final PersistentResource<Integer> appearancesCount;
    private Configuration configuration;

    PreconditionsChecker(@Nullable Configuration configuration, TriggerEventsCallback triggerEventsCallback, Executor2 uiExecutor, PersistentResource<Long> lastAppearanceTime, PersistentResource<Integer> appearancesCount) {
        this.maybeConfiguration = configuration;
        this.triggerEventsCallback = triggerEventsCallback;
        this.uiExecutor = uiExecutor;
        this.lastAppearanceTime = lastAppearanceTime;
        this.appearancesCount = appearancesCount;
    }

    @Override
    @WorkerThread
    public void run() {
        try {
            this.configuration = this.checkConfiguration();
            this.checkVersion();
            this.checkTotalCap();
            this.checkAppearancesInterval();
            this.inquireUpdateAvailability((Consumer<AppUpdateInfo>)((Consumer)this::afterUpdateInfoRetrieved));
        }
        catch (InAppUpdateException e) {
            this.notifyCallbackFailure(e);
        }
    }

    private void afterUpdateInfoRetrieved(AppUpdateInfo updateInfo) {
        this.notifyCallback((Consumer<TriggerEventsCallback>)((Consumer)it -> it.onUpdateAvailable(updateInfo)));
        assert (updateInfo.updateAvailability() == 2);
        try {
            this.checkVersionStaleness(updateInfo);
            this.checkUpdateTypeAllowed(updateInfo);
            this.checkHostAppIsShowing();
            this.notifyCallback((Consumer<TriggerEventsCallback>)((Consumer)TriggerEventsCallback::onUpdateDialogShown));
            this.updateAppearanceData();
            this.onAllChecksPassed(updateInfo);
        }
        catch (InAppUpdateException e) {
            this.notifyCallbackFailure(e);
        }
    }

    protected abstract void onAllChecksPassed(AppUpdateInfo var1);

    private void checkUpdateTypeAllowed(AppUpdateInfo updateInfo) throws InAppUpdateException {
        int wantedType = this.configuration.getUpdateType();
        if (!updateInfo.isUpdateTypeAllowed(wantedType)) {
            throw new PreconditionNotMetException("wanted update type not allowed: " + wantedType, InAppUpdateException.ErrorCode.PRECONDITION_UPDATE_TYPE);
        }
    }

    private void checkHostAppIsShowing() throws InAppUpdateException {
        boolean appInForeground = this.isAppInForeground();
        if (!appInForeground) {
            throw new PreconditionNotMetException("app is in background", InAppUpdateException.ErrorCode.PRECONDITION_APP_BACKGROUND);
        }
    }

    @VisibleForTesting
    boolean isAppInForeground() {
        return ProcessLifecycleOwner.get().getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.RESUMED);
    }

    private void checkVersionStaleness(AppUpdateInfo updateInfo) throws InAppUpdateException {
        Integer clientVersionStalenessDays = updateInfo.clientVersionStalenessDays();
        if (clientVersionStalenessDays != null && this.configuration.getAvailabilityDelayDays() > clientVersionStalenessDays) {
            throw new PreconditionNotMetException("availability delay", InAppUpdateException.ErrorCode.PRECONDITION_AVAILABILITY_DELAY);
        }
    }

    @AnyThread
    private void notifyCallbackFailure(InAppUpdateException exception) {
        this.notifyCallback((Consumer<TriggerEventsCallback>)((Consumer)it -> it.onPreconditionsCheckFailed(exception)));
    }

    private void notifyCallback(Consumer<TriggerEventsCallback> what) {
        this.uiExecutor.submit(() -> what.accept((Object)this.triggerEventsCallback));
    }

    @SuppressLint(value={"Assert"})
    private void inquireUpdateAvailability(Consumer<AppUpdateInfo> onUpdateAvailable) {
        this.getAppUpdateInfoTask().addOnCompleteListener(task -> {
            if (!task.isSuccessful()) {
                Exception exception = task.getException();
                assert (exception != null);
                this.notifyCallbackFailure(new InAppUpdateException(exception, InAppUpdateException.ErrorCode.PRECONDITION_NO_UPDATE_INFO));
                return;
            }
            AppUpdateInfo appUpdateInfo = (AppUpdateInfo)task.getResult();
            int availability = appUpdateInfo.updateAvailability();
            switch (availability) {
                case 2: {
                    onUpdateAvailable.accept((Object)appUpdateInfo);
                    break;
                }
                case 3: {
                    this.startMonitoringUpdateInProgress();
                    break;
                }
                case 0: 
                case 1: {
                    this.notifyCallbackFailure(new InAppUpdateException("no app update available: status=" + availability, InAppUpdateException.ErrorCode.PRECONDITION_NO_UPDATE_AVAILABLE));
                    break;
                }
                default: {
                    assert (false) : "unhandled case " + availability;
                    this.notifyCallbackFailure(new InAppUpdateException("unexpected error", InAppUpdateException.ErrorCode.ERROR_UNEXPECTED));
                }
            }
        });
    }

    protected abstract void startMonitoringUpdateInProgress();

    @NonNull
    protected abstract Task<AppUpdateInfo> getAppUpdateInfoTask();

    @NonNull
    private Configuration checkConfiguration() throws InAppUpdateException {
        if (this.maybeConfiguration == null) {
            throw new PreconditionNotMetException("no configuration", InAppUpdateException.ErrorCode.PRECONDITION_CONFIGURATION_NOT_SET);
        }
        this.maybeConfiguration.validate();
        return this.maybeConfiguration;
    }

    private void checkVersion() throws InAppUpdateException {
        AppData appData = this.getAppData();
        if (appData.getVersionCode() >= this.configuration.getTargetVersion()) {
            throw new PreconditionNotMetException("target version lower than current", InAppUpdateException.ErrorCode.PRECONDITION_TARGET_VERSION);
        }
    }

    @NonNull
    protected abstract AppData getAppData() throws InAppUpdateException;

    private void checkTotalCap() throws InAppUpdateException {
        int appearancesCount = this.getAppearancesCount();
        if (appearancesCount >= this.configuration.getTotalAppearancesCap()) {
            throw new PreconditionNotMetException("total appearances cap exceeded", InAppUpdateException.ErrorCode.PRECONDITION_TOTAL_CAP);
        }
    }

    private void checkAppearancesInterval() throws InAppUpdateException {
        Date now;
        Date nextPermittedAppearanceTime = this.getNextPermittedAppearanceTime();
        if (nextPermittedAppearanceTime.after(now = this.now())) {
            long timeLeftSeconds = TimeUnit.MILLISECONDS.toSeconds(nextPermittedAppearanceTime.getTime() - now.getTime());
            throw new PreconditionNotMetException("not allowed to appear for the next " + timeLeftSeconds, InAppUpdateException.ErrorCode.PRECONDITION_APPEARANCE_INTERVAL);
        }
    }

    @VisibleForTesting
    Date now() {
        return new Date();
    }

    @NonNull
    private Date getNextPermittedAppearanceTime() {
        long lastAppearanceTimeEpoch = this.lastAppearanceTime.get();
        long nextPermittedAppearanceTimeEpoch = lastAppearanceTimeEpoch + TimeUnit.MINUTES.toMillis(this.configuration.getMinimalAppearanceIntervalMinutes());
        return new Date(nextPermittedAppearanceTimeEpoch);
    }

    private int getAppearancesCount() {
        return this.appearancesCount.get();
    }

    private void updateAppearanceData() {
        this.lastAppearanceTime.set(this.now().getTime());
        this.appearancesCount.transact((Function<Integer, Integer>)((Function)it -> it + 1));
    }
}

