package com.taboola.android.infra.persistence;

import android.content.SharedPreferences;

import androidx.annotation.NonNull;

/**
 * Created by ronk on 2017-02-09.
 */
public class IntegerPersistentResource extends AbstractPersistentResource<Integer> {

    public IntegerPersistentResource(Builder<Integer> builder) {
        super(builder);
    }

    @Override
    protected Integer getStoredValue() {
        return getSharedPreferences().getInt(getStorageKey(), -1);
    }

    @Override
    protected void storeValue(@NonNull SharedPreferences.Editor editor, Integer value) {
         editor.putInt(getStorageKey(), value);
    }

}
