package com.taboola.android.infra.persistence;

import android.content.SharedPreferences;

/**
 * Created by ronk on 2017-02-13.
 */
public class BooleanPersistentResource extends AbstractPersistentResource<Boolean> {

    public BooleanPersistentResource(Builder<Boolean> builder) {
        super(builder);
    }

    @Override
    protected Boolean getStoredValue() {
        return getSharedPreferences().getBoolean(getStorageKey(), false /*this value is ignored*/);
    }

    @Override
    protected void storeValue(  SharedPreferences.Editor editor, Boolean value) {
        editor.putBoolean(getStorageKey(), value);
    }

}
