package com.taboola.android.infra.inappupdate;

import androidx.annotation.Keep;
import androidx.annotation.UiThread;

import com.google.android.play.core.appupdate.AppUpdateInfo;

@Keep
@UiThread
public interface TriggerEventsCallback {

    TriggerEventsCallback NULL = new TriggerEventsCallbackDefault() {
    };

    void onPreconditionsCheckFailed(InAppUpdateException exception);

    void onUpdateAvailable(AppUpdateInfo updateInfo);

    void onUpdateDialogShown();

    void onUserAcceptedUpdate();

    void onUpdateFlowFailed(InAppUpdateException exception);

    void onDownloadProgress(long bytesDownloaded, long totalBytesToDownload);

    void onUpdateReadyToInstall(Runnable acknowledgeToInstall);

    void onInstalling();

}