package com.taboola.android.infra.inappupdate;

import android.app.Activity;
import android.content.Context;

import androidx.annotation.AnyThread;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;

import com.taboola.android.infra.inappupdate.internals.Sdk;


@SuppressWarnings("unused")
@Keep
public class InAppUpdate {
    @AnyThread
    public static void initialize(Context context,
                                  @Nullable Configuration configuration,
                                  @Nullable TriggerEventsCallback triggerEventsCallback) {
        Sdk.initialize(context);
        if (configuration != null) {
            Sdk.getInstance().setConfiguration(configuration);
        }
        if (triggerEventsCallback != null) {
            Sdk.getInstance().setTriggerEventsCallback(triggerEventsCallback);
        }
    }

    @AnyThread
    public static void setConfiguration(@Nullable Configuration configuration) {
        Sdk.getInstance().setConfiguration(configuration);
    }

    public static void resetCounters(){
        Sdk.getInstance().resetCounters();
    }

    // TODO: 2020-10-28 add support for providing configuration as JSON
    @AnyThread
    public static void setTriggerEventsCallback(@Nullable TriggerEventsCallback triggerEventsCallback) {
        Sdk.getInstance().setTriggerEventsCallback(triggerEventsCallback);
    }

    @AnyThread
    public static void onTriggerOccurred(Activity activity) {
        Sdk.getInstance().onTriggerOccurred(activity);
    }
    // TODO: 2020-10-28 add helpers for different types of triggers: Activity::onResume, on specific time of day
}
