/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.infra.utilities;

import androidx.core.util.Predicate;
import androidx.core.util.Supplier;
import com.taboola.android.infra.inappupdate.ValidationException;

public class Validators {
    private static final Predicate<Long> IS_NON_NEGATIVE = n -> n >= 0L;

    public static long isNonNegative(String parameterName, long subject) throws ValidationException {
        return Validators.validate((Supplier<String>)((Supplier)() -> parameterName + " cannot be negative"), subject, IS_NON_NEGATIVE);
    }

    public static <T> T validate(Supplier<String> validationError, T subject, Predicate<T> predicate) throws ValidationException {
        if (!predicate.test(subject)) {
            throw new ValidationException((String)validationError.get());
        }
        return subject;
    }
}

