/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.infra.inappupdate;

import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.google.android.play.core.install.model.AppUpdateType;
import com.taboola.android.infra.inappupdate.ValidationException;
import com.taboola.android.infra.utilities.Validators;
import java.util.Arrays;

@Keep
public class Configuration {
    private final long targetVersion;
    private final int totalAppearancesCap;
    private final int minimalAppearanceIntervalMinutes;
    private final int availabilityDelayDays;
    private final int updateType;

    public Configuration(@IntRange(from=0L) long targetVersion, @IntRange(from=0L) int totalAppearancesCap, @IntRange(from=0L) int minimalAppearanceIntervalMinutes, @IntRange int availabilityDelayDays, @AppUpdateType int updateType) throws ValidationException {
        this.targetVersion = targetVersion;
        this.totalAppearancesCap = totalAppearancesCap;
        this.minimalAppearanceIntervalMinutes = minimalAppearanceIntervalMinutes;
        this.availabilityDelayDays = availabilityDelayDays;
        this.updateType = updateType;
        this.validate();
    }

    public long getTargetVersion() {
        return this.targetVersion;
    }

    public int getTotalAppearancesCap() {
        return this.totalAppearancesCap;
    }

    public int getMinimalAppearanceIntervalMinutes() {
        return this.minimalAppearanceIntervalMinutes;
    }

    public int getAvailabilityDelayDays() {
        return this.availabilityDelayDays;
    }

    public int getUpdateType() {
        return this.updateType;
    }

    public void validate() throws ValidationException {
        Validators.isNonNegative("targetVersion", this.targetVersion);
        Validators.isNonNegative("totalAppearancesCap", this.totalAppearancesCap);
        Validators.isNonNegative("minimalAppearanceIntervalMinutes", this.minimalAppearanceIntervalMinutes);
        if (!Arrays.asList(0, 1).contains(this.updateType)) {
            throw new ValidationException("invalid update type: " + this.updateType);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        if (this.targetVersion != that.targetVersion) {
            return false;
        }
        if (this.totalAppearancesCap != that.totalAppearancesCap) {
            return false;
        }
        if (this.minimalAppearanceIntervalMinutes != that.minimalAppearanceIntervalMinutes) {
            return false;
        }
        if (this.availabilityDelayDays != that.availabilityDelayDays) {
            return false;
        }
        return this.updateType == that.updateType;
    }

    public int hashCode() {
        int result = (int)(this.targetVersion ^ this.targetVersion >>> 32);
        result = 31 * result + this.totalAppearancesCap;
        result = 31 * result + this.minimalAppearanceIntervalMinutes;
        result = 31 * result + this.availabilityDelayDays;
        result = 31 * result + this.updateType;
        return result;
    }

    @NonNull
    public String toString() {
        return "{targetVersion=" + this.targetVersion + ", totalAppearancesCap=" + this.totalAppearancesCap + ", minimalAppearanceIntervalMinutes=" + this.minimalAppearanceIntervalMinutes + ", availabilityDelayDays=" + this.availabilityDelayDays + ", updateType=" + this.updateType + '}';
    }
}

