/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.url_components;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taboola.android.global_components.network.url_components.PathParam;
import com.taboola.android.global_components.network.url_components.UrlParameter;
import com.taboola.android.global_components.network.url_components.UrlParameters;
import java.util.ArrayList;

public class MutableUrl {
    private static final String STRUCTURE = "%s%s";
    private static final boolean UTF8_BY_DEFAULT = true;
    @NonNull
    private String mBaseUrl;
    @Nullable
    private UrlParameters mQueryParameters;
    @Nullable
    private ArrayList<PathParam> mPathParams;

    public MutableUrl(@NonNull String baseUrl) {
        if (TextUtils.isEmpty((CharSequence)baseUrl)) {
            throw new RuntimeException("constructor | baseUrl cannot be null.");
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.mBaseUrl = baseUrl;
    }

    public MutableUrl addPathParam(@NonNull PathParam pathParam) {
        if (this.mPathParams == null) {
            this.mPathParams = new ArrayList();
        }
        this.mPathParams.add(pathParam);
        return this;
    }

    private String getBaseUrlWithParams() {
        String baseUrl = this.mBaseUrl;
        if (this.mPathParams != null) {
            for (PathParam pathParam : this.mPathParams) {
                baseUrl = baseUrl.replace(pathParam.getOldVal(), Uri.encode((String)pathParam.getNewVal()));
            }
        }
        return baseUrl;
    }

    public MutableUrl addQueryParameter(@NonNull UrlParameter queryParameter) {
        if (this.mQueryParameters == null) {
            this.mQueryParameters = new UrlParameters();
        }
        this.mQueryParameters.addParameters(queryParameter);
        return this;
    }

    private String getQueryParams() {
        if (this.mQueryParameters == null || this.mQueryParameters.isEmpty()) {
            return "";
        }
        return "?" + this.mQueryParameters.getString(true);
    }

    public String getUrl() {
        return String.format(STRUCTURE, this.getBaseUrlWithParams(), this.getQueryParams());
    }
}

