/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.network;

import android.os.Looper;
import android.support.annotation.Nullable;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class VerifierHttpManager {
    private static final String TAG = "IntegrationVerifier";
    private static final int DEFAULT_TIMEOUT_MILLIS = 5000;

    public void get(final String url, final NetworkResponse networkResponse) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    VerifierHttpManager.this.httpGetRequest(url, networkResponse);
                }
            }).start();
        } else {
            this.httpGetRequest(url, networkResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void httpGetRequest(String url, NetworkResponse networkResponse) {
        HttpURLConnection connection = null;
        try {
            if (url.contains("https://")) {
                connection = (HttpsURLConnection)new URL(url).openConnection();
            } else if (url.contains("http://")) {
                connection = (HttpURLConnection)new URL(url).openConnection();
            } else {
                if (networkResponse == null) return;
                networkResponse.onError("url must begin with http:// or https://");
                return;
            }
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(5000);
            connection.connect();
            int status = connection.getResponseCode();
            switch (status) {
                case 200: 
                case 201: {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        response.append(line + "\n");
                    }
                    br.close();
                    if (networkResponse == null) return;
                    networkResponse.onResponse(response.toString());
                    return;
                }
                default: {
                    if (networkResponse == null) return;
                    networkResponse.onError("Invalid response code: " + status);
                    return;
                }
            }
        }
        catch (MalformedURLException e) {
            if (networkResponse == null) return;
            networkResponse.onError("MalformedURLException: " + e.getLocalizedMessage());
            return;
        }
        catch (IOException e) {
            if (networkResponse == null) return;
            networkResponse.onError("IOException: " + e.getLocalizedMessage());
            return;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void post(final String url, final @Nullable JSONObject jsonBody, final NetworkResponse networkResponse) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    VerifierHttpManager.this.httpPostRequest(url, jsonBody, networkResponse);
                }
            }).start();
        } else {
            this.httpPostRequest(url, jsonBody, networkResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void httpPostRequest(String url, @Nullable JSONObject jsonBody, NetworkResponse networkResponse) {
        HttpURLConnection connection = null;
        try {
            if (url.contains("https://")) {
                connection = (HttpsURLConnection)new URL(url).openConnection();
            } else if (url.contains("http://")) {
                connection = (HttpURLConnection)new URL(url).openConnection();
            } else {
                if (networkResponse == null) return;
                networkResponse.onError("url must begin with http:// or https://");
                return;
            }
            connection.setConnectTimeout(5000);
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            if (jsonBody != null && jsonBody.length() > 0) {
                DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
                writer.writeBytes(jsonBody.toString());
                writer.flush();
                writer.close();
            }
            int status = connection.getResponseCode();
            switch (status) {
                case 200: 
                case 201: {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        response.append(line + "\n");
                    }
                    br.close();
                    if (networkResponse == null) return;
                    networkResponse.onResponse(response.toString());
                    return;
                }
                default: {
                    if (networkResponse == null) return;
                    networkResponse.onError("Invalid response code: " + status);
                    return;
                }
            }
        }
        catch (NullPointerException e) {
            if (networkResponse == null) return;
            networkResponse.onError("NullPointerException: " + e.getLocalizedMessage());
            return;
        }
        catch (IOException e) {
            if (networkResponse == null) return;
            networkResponse.onError("IOException: " + e.getLocalizedMessage());
            return;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static interface NetworkResponse {
        public void onResponse(String var1);

        public void onError(String var1);
    }
}

