/*
 * Decompiled with CFR 0.152.
 */
package com.t1.cloud.http;

import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import com.t1.cloud.http.HTTP;
import com.t1.cloud.http.HttpAgentResults;
import com.t1.cloud.http.JsonArrayCallback;
import com.t1.cloud.http.JsonCallback;
import com.t1.cloud.http.StringCallback;
import com.t1.cloud.http.SuccessCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class HttpAgent
extends AsyncTask<Void, Void, String> {
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private final String TAG = ((Object)((Object)this)).getClass().getName();
    private String mUrl;
    private HttpURLConnection mConnection;
    private String mVerb;
    private Map<String, String> mQueryParams = new HashMap<String, String>();
    private int mTimeOut = 10000;
    private String mBody;
    private boolean mHasBody = false;
    private String mContentType = "application/json";
    private HttpAgentResults mCallback;
    private String mErrorMessage = "";

    private HttpAgent(String url, String httpVerb) {
        this.mUrl = url;
        this.mVerb = httpVerb;
    }

    public static HttpAgent get(String url) {
        return new HttpAgent(url, HTTP.GET);
    }

    public static HttpAgent post(String url) {
        return new HttpAgent(url, HTTP.POST);
    }

    public static HttpAgent put(String url) {
        return new HttpAgent(url, HTTP.PUT);
    }

    public static HttpAgent delete(String url) {
        return new HttpAgent(url, HTTP.DELETE);
    }

    private static String createQueryStringForParameters(Map<String, String> parameters) {
        if (parameters == null) {
            return "";
        }
        Uri.Builder builder = new Uri.Builder();
        for (String key : parameters.keySet()) {
            builder.appendQueryParameter(key, parameters.get(key));
        }
        String query = builder.build().getEncodedQuery();
        if (query == null) {
            query = "";
        }
        if (query.trim().length() > 0) {
            query = "?" + query;
        }
        return query;
    }

    public HttpAgent queryParams(Map<String, String> stringMap) {
        for (String key : stringMap.keySet()) {
            this.mQueryParams.put(key, stringMap.get(key));
        }
        return this;
    }

    public HttpAgent queryParams(String ... queryParams) {
        if (queryParams.length % 2 != 0) {
            Log.e((String)this.TAG, (String)"query params must be even number");
            return this;
        }
        for (int i = 0; i < queryParams.length; i += 2) {
            this.mQueryParams.put(queryParams[i], queryParams[i + 1]);
        }
        return this;
    }

    private void setTimeOut(int timeOutInMillis) {
        this.mTimeOut = timeOutInMillis;
    }

    public HttpAgent contentType(String contentType) {
        this.mContentType = contentType;
        return this;
    }

    public HttpAgent withBody(String body) {
        this.mBody = body;
        this.mHasBody = !TextUtils.isEmpty((CharSequence)this.mBody);
        return this;
    }

    public void go(SuccessCallback callback) {
        this.mCallback = callback;
        this.execute(new Void[0]);
    }

    public void goJson(JsonCallback callback) {
        this.mCallback = callback;
        this.execute(new Void[0]);
    }

    public void goJsonArray(JsonArrayCallback callback) {
        this.mCallback = callback;
        this.execute(new Void[0]);
    }

    public void goString(StringCallback callback) {
        this.mCallback = callback;
        this.execute(new Void[0]);
    }

    protected void onPreExecute() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doInBackground(Void ... params) {
        try {
            String line;
            int mResponseCode;
            String queryParams = HttpAgent.createQueryStringForParameters(this.mQueryParams);
            String urlWithParams = this.mUrl + queryParams;
            this.mConnection = (HttpURLConnection)new URL(urlWithParams).openConnection();
            this.mConnection.setRequestMethod(this.mVerb);
            this.mConnection.setReadTimeout(this.mTimeOut);
            this.mConnection.setDoInput(true);
            this.mConnection.setDoOutput(this.mHasBody);
            this.mConnection.setRequestProperty("Content-Type", this.mContentType);
            this.mConnection.connect();
            Log.d((String)this.TAG, (String)("sending request to:\n" + urlWithParams + (this.mHasBody ? "\nwith body:\n" + this.mBody : "")));
            if (this.mHasBody) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.mConnection.getOutputStream(), Charset.forName("UTF-8")));
                writer.write(this.mBody);
                ((Writer)writer).close();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((mResponseCode = this.mConnection.getResponseCode()) >= 400 ? this.mConnection.getErrorStream() : this.mConnection.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
            if (mResponseCode >= 400) {
                this.mErrorMessage = stringBuilder.toString();
                String string = null;
                return string;
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            this.mErrorMessage = e.getMessage();
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                this.mErrorMessage = e.getMessage();
            }
        }
        finally {
            if (this.mConnection != null) {
                this.mConnection.disconnect();
            }
        }
        return null;
    }

    protected void onPostExecute(String result) {
        if (!TextUtils.isEmpty((CharSequence)this.mErrorMessage)) {
            if (this.mCallback != null) {
                HttpAgentResults.errorMessage = this.mErrorMessage;
                this.mCallback.notify(null);
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)result)) {
            Log.d((String)this.TAG, (String)("Server Response: " + result));
            if (this.mCallback != null) {
                HttpAgentResults.stringResults = result;
                this.mCallback.notify(result.trim());
            }
        }
    }
}

