package com.t1.cloud.utils;

import com.t1.cloud.T1Cloud;
import java.util.Map;

/**
 * HTTP Parameter add...
 *
 * @author hico
 */
public class ParameterUtils {
  private volatile static ParameterUtils parameterUtils = null;

  /**
   * HTTP Parameter 判断是否存在 key
   */
  private String[] mUserParameter = new String[] {
      "imei", "custom", "invite", "jf", "money",
      "msg", "newpass", "num", "nowpage", "pagenum",
      "orderid", "goodsid", "title", "text", "who",
  };

  /**
   * HTTP Parameter 里面的 key 进行 MD5 加密
   */
  private String[] mTokenParameter = new String[] {
      "user", "pass", "imei", "custom", "jf", "money",
      "msg", "newpass", "num", "nowpage", "pagenum",
      "orderid", "goodsid", "title", "text", "who",
  };

  /**
   * HTTP Parameter Pay
   */
  private String[] mPayParameter = new String[] {
      "key", "paytype", "orderid", "paymsg", "money",
      "goodsid", "goodsval"
  };

  /**
   * HTTP Parameter SMS
   */
  private String[] mSMSParameter = new String[] {
      "key", "tel", "num"
  };

  // 对象实例化
  public static ParameterUtils getInstance() {
    if (parameterUtils == null) {
      synchronized (ParameterUtils.class) {
        if (parameterUtils == null) {
          parameterUtils = new ParameterUtils();
        }
      }
    }
    return parameterUtils;
  }

  /**
   * HTTP Parameter 处理
   *
   * @param IsUserPass is add user pass
   * @param map HTTP Parameter
   * @return HTTP Parameter
   */
  public Map<String, String> getSignOfMap(boolean IsUserPass, Map<String, String> map) {
    // 添加固定 Parameter
    map.put("key", T1Cloud.APP_KEY);
    if (IsUserPass) {
      map.put("user", map.get("user"));
      map.put("pass", map.get("pass"));
    }

    // 判断是否存在 key
    for (String s : mUserParameter) {
      if (map.containsKey(s)) {
        map.put(s, map.get(s));
      }
    }

    // key MD5 加密
    StringBuilder stringBuffer = new StringBuilder();
    stringBuffer.append(T1Cloud.APP_KEY);
    for (String s : mTokenParameter) {
      if (map.containsKey(s)) {
        stringBuffer.append(map.get(s));
      }
    }
    stringBuffer.append(T1Cloud.APP_TOKEN);

    String token = MD5Utils.signMD5(stringBuffer.toString());
    map.put("token", token);
    return map;
  }

  /**
   * HTTP Parameter 处理
   *
   * @param url append url
   * @param map HTTP Parameter
   * @return HTTP Parameter
   */
  public String getSignOfStr(String url, Map<String, String> map) {
    StringBuilder stringBuffer = new StringBuilder();
    for (String s : mPayParameter) {
      if (map.containsKey(s)) {
        stringBuffer
            .append(s)
            .append("=")
            .append(map.get(s))
            .append("&");
      }
    }
    stringBuffer
        .append("token")
        .append("=")
        .append(MD5Utils.signOfStringAllMD5(stringBuffer.toString()));

    return url + "?" + stringBuffer.toString();
  }

  /**
   * HTTP Parameter 处理
   *
   * @param map HTTP Parameter
   * @return 加密好的 Str
   */
  public String getSignOfStrSMS(Map<String, String> map) {
    StringBuilder stringBuffer = new StringBuilder();
    for (String s : mSMSParameter) {
      if (map.containsKey(s)) {
        stringBuffer.append(map.get(s));
      }
    }
    return MD5Utils.signOfStringAllMD5(stringBuffer.toString());
  }

}