package com.t1.cloud.http;

import org.json.JSONObject;

/**
 * HttpAgent Json 接口回调
 *
 * @author PopApp_laptop
 */
public abstract class JsonCallback extends HttpAgentResults {
  abstract void onDone(boolean success, JSONObject jsonResults);

  @Override
  protected void notify(String results) {
    if (hasError()) {
      onDone(false, null);
      return;
    }
    try {
      JSONObject jsonObject = new JSONObject(results);
      onDone(!hasError(), jsonObject);
    } catch (Exception ex) {
      errorMessage = ex.getMessage();
      onDone(false, null);
    }
  }
}