package com.t1.cloud;

import com.t1.cloud.http.HTTP;
import com.t1.cloud.http.HttpAgent;
import com.t1.cloud.http.HttpAgentResults;
import com.t1.cloud.http.JsonArrayCallback;
import com.t1.cloud.listener.T1CloudListener;
import com.t1.cloud.utils.ParameterUtils;
import java.util.HashMap;
import java.util.Map;

/**
 * T1Cloud User
 *
 * @author hico
 */
public class T1CloudUser {
  private Map<String, String> stringHashMap = new HashMap<>();

  public void put(String key, Object value) {
    stringHashMap.put(key, (String) value);
  }

  /**
   * 登录账号
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void login(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "info");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 修改积分
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void integral(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "edu_jf");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 修改余额
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void balance(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "edu_money");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 修改自定义参数
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void custom(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "edu_custom");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 修改密码
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void password(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "changepass");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 每日签到
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void sign(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "qd");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 余额兑换会员
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void changeMember(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "mtv");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 余额兑换积分
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void changeIntegral(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "mtj");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 余额记录查询
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void recordBalance(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "money_log");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 会员记录查询
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void recordMember(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "vip_log");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 积分记录查询
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void recordIntegral(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "jf_log");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 抽奖
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void lottery(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "cj");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * 抽奖记录
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void recordLottery(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "cj_list");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_ALTER, stringHashMap, cloudListener);
  }

  /**
   * HttpAgent get
   *
   * @param url HTTP
   * @param map HTTP Parameter
   * @param cloudListener T1CloudListener 接口
   */
  private void mHttpAgentData(String url, Map<String, String> map, final T1CloudListener cloudListener) {
    HttpAgent.get(url).queryParams(map).goJsonArray(new JsonArrayCallback() {
      @Override
      protected void onDone(boolean success, String json) {
        if (success) {
          cloudListener.onDone(json);
        } else {
          cloudListener.onError(HttpAgentResults.getErrorMessage());
        }
      }
    });
  }

}