package com.t1.cloud;

import com.t1.cloud.http.HTTP;
import com.t1.cloud.http.HttpAgent;
import com.t1.cloud.http.HttpAgentResults;
import com.t1.cloud.http.JsonArrayCallback;
import com.t1.cloud.listener.T1CloudListener;
import com.t1.cloud.utils.ParameterUtils;
import java.util.HashMap;
import java.util.Map;

/**
 * T1Cloud 注册
 *
 * @author hico
 */
public class T1CloudRegister {
  private Map<String, String> stringHashMap = new HashMap<>();

  public void put(String key, Object value) {
    stringHashMap.put(key, (String) value);
  }

  /**
   * 用户注册
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void register(final T1CloudListener cloudListener) {
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(true, stringHashMap);
    HttpAgent.post(HTTP.HTTP_URL_CLOUD_REGISTER)
        .queryParams(stringHashMap)
        .goJsonArray(new JsonArrayCallback() {
          @Override
          protected void onDone(boolean success, String json) {
            if (success) {
              cloudListener.onDone(json);
            } else {
              cloudListener.onError(HttpAgentResults.getErrorMessage());
            }
          }
        });
  }

}
