package com.t1.cloud;

import com.t1.cloud.http.HTTP;
import com.t1.cloud.http.HttpAgent;
import com.t1.cloud.http.HttpAgentResults;
import com.t1.cloud.http.JsonArrayCallback;
import com.t1.cloud.listener.T1CloudListener;
import com.t1.cloud.utils.ParameterUtils;
import java.util.HashMap;
import java.util.Map;

/**
 * T1Cloud Pay
 *
 * @author hico
 */
public class T1CloudPay {
  private Map<String, String> stringHashMap = new HashMap<>();

  public void put(String key, Object value) {
    stringHashMap.put(key, (String) value);
  }

  /**
   * 发起支付
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void initiatePay(final T1CloudListener cloudListener) {
    stringHashMap.put("key", T1Cloud.APP_KEY);
    cloudListener.onDone(ParameterUtils.getInstance().getSignOfStr(HTTP.HTTP_URL_CLOUD_PAY, stringHashMap));
  }

  /**
   * 商品系统下单
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void documentPay(final T1CloudListener cloudListener) {
    stringHashMap.put("key", T1Cloud.APP_KEY);
    cloudListener.onDone(ParameterUtils.getInstance().getSignOfStr(HTTP.HTTP_URL_CLOUD_PAY, stringHashMap));
  }

  /**
   * 订单查询
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void recordOrderPay(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "getpay");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(false, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_DATA, stringHashMap, cloudListener);
  }

  /**
   * 商品查询详情
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void recordDetailedPay(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "get_goods_info");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(false, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_DATA, stringHashMap, cloudListener);
  }

  /**
   * 自动发货查询
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void recordShipPay(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "get_km");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(false, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_DATA, stringHashMap, cloudListener);
  }

  /**
   * HttpAgent get
   *
   * @param url HTTP
   * @param map HTTP Parameter
   * @param cloudListener T1CloudListener 接口
   */
  private void mHttpAgentData(String url, Map<String, String> map, final T1CloudListener cloudListener) {
    HttpAgent.get(url).queryParams(map).goJsonArray(new JsonArrayCallback() {
      @Override
      protected void onDone(boolean success, String json) {
        if (success) {
          cloudListener.onDone(json);
        } else {
          cloudListener.onError(HttpAgentResults.getErrorMessage());
        }
      }
    });
  }

}
