package com.t1.cloud;

import com.t1.cloud.http.HTTP;
import com.t1.cloud.http.HttpAgent;
import com.t1.cloud.http.HttpAgentResults;
import com.t1.cloud.http.JsonArrayCallback;
import com.t1.cloud.listener.T1CloudListener;
import java.util.HashMap;
import java.util.Map;

/**
 * T1Cloud Object
 *
 * @author hico
 */
public class T1CloudObject {
  private Map<String, String> stringHashMap = new HashMap<>();

  /**
   * 获取平台数据
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void getCloud(final T1CloudListener cloudListener) {
    stringHashMap.put("key", T1Cloud.APP_KEY);
    stringHashMap.put("type", "online");

    HttpAgent.get(HTTP.HTTP_URL_CLOUD_DATA)
        .queryParams(stringHashMap)
        .goJsonArray(new JsonArrayCallback() {
          @Override
          protected void onDone(boolean success, String json) {
            if (success) {
              cloudListener.onDone(json);
            } else {
              cloudListener.onError(HttpAgentResults.getErrorMessage());
            }
          }
        });
  }

}