package com.t1.cloud;

import com.t1.cloud.http.HTTP;
import com.t1.cloud.http.HttpAgent;
import com.t1.cloud.http.HttpAgentResults;
import com.t1.cloud.http.JsonArrayCallback;
import com.t1.cloud.listener.T1CloudListener;
import com.t1.cloud.utils.ParameterUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/**
 * T1Cloud interface
 *
 * @author hico
 */
public class T1CloudFeatures {
  private Map<String, String> stringHashMap = new HashMap<>();

  public void put(String key, Object value) {
    stringHashMap.put(key, (String) value);
  }

  /**
   * 邮箱发件
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void sendEmail(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "sendmail");
    stringHashMap = ParameterUtils.getInstance().getSignOfMap(false, stringHashMap);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_DATA, stringHashMap, cloudListener);
  }

  /**
   * 云文档
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void cloudDocument(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "text");
    stringHashMap.put("key", T1Cloud.APP_KEY);
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_DATA, stringHashMap, cloudListener);
  }

  /**
   * PING
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void ping(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "ping");
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_API, stringHashMap, cloudListener);
  }

  /**
   * IP 信息查询
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void ipQuery(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "ipinfo");
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_API, stringHashMap, cloudListener);
  }

  /**
   * 当前客户端 IP 查询
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void ipCloudQuery(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "get_ip");
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_API, stringHashMap, cloudListener);
  }

  /**
   * 最近七天天气获取
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void cloudWeather(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "weather");
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_API, stringHashMap, cloudListener);
  }

  /**
   * 短信轰炸_添加号码
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void cloudSMSAdd(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "telboom_add");
    stringHashMap.put("key", T1Cloud.APP_KEY);
    stringHashMap.put("token", ParameterUtils.getInstance().getSignOfStrSMS(stringHashMap));
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_DATA, stringHashMap, cloudListener);
  }

  /**
   * 短信轰炸_查询进度
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void cloudSMSSchedule(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "telboom_sel");
    stringHashMap.put("key", T1Cloud.APP_KEY);
    stringHashMap.put("token", ParameterUtils.getInstance().getSignOfStrSMS(stringHashMap));
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_DATA, stringHashMap, cloudListener);
  }

  /**
   * 短信轰炸_暂停执行
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void cloudSMSPause(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "telboom_stop");
    stringHashMap.put("key", T1Cloud.APP_KEY);
    stringHashMap.put("token", ParameterUtils.getInstance().getSignOfStrSMS(stringHashMap));
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_DATA, stringHashMap, cloudListener);
  }

  /**
   * 短信轰炸白名单_添加号码
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void cloudSMSListAdd(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "bmd_add");
    stringHashMap.put("key", T1Cloud.APP_KEY);
    stringHashMap.put("token", ParameterUtils.getInstance().getSignOfStrSMS(stringHashMap));
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_DATA, stringHashMap, cloudListener);
  }

  /**
   * 短信轰炸白名单_移除号码
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void cloudSMSListRemove(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "bmd_del");
    stringHashMap.put("key", T1Cloud.APP_KEY);
    stringHashMap.put("token", ParameterUtils.getInstance().getSignOfStrSMS(stringHashMap));
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_DATA, stringHashMap, cloudListener);
  }

  /**
   * 短信轰炸白名单_号码查询
   *
   * @param cloudListener T1CloudListener 接口
   */
  public void cloudSMSQuery(final T1CloudListener cloudListener) {
    stringHashMap.put("type", "bmd_sel");
    stringHashMap.put("key", T1Cloud.APP_KEY);
    stringHashMap.put("token", ParameterUtils.getInstance().getSignOfStrSMS(stringHashMap));
    mHttpAgentData(HTTP.HTTP_URL_CLOUD_DATA, stringHashMap, cloudListener);
  }

  /**
   * HttpAgent get
   *
   * @param url HTTP
   * @param map HTTP Parameter
   * @param cloudListener T1CloudListener 接口
   */
  private void mHttpAgentData(String url, Map<String, String> map, final T1CloudListener cloudListener) {
    HttpAgent.get(url).queryParams(map).goJsonArray(new JsonArrayCallback() {
      @Override
      protected void onDone(boolean success, String json) {
        if (success) {
          cloudListener.onDone(json);
        } else {
          cloudListener.onError(HttpAgentResults.getErrorMessage());
        }
      }
    });
  }

}
