/*
 * Decompiled with CFR 0.152.
 */
package com.synnapps.carouselview;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import com.synnapps.carouselview.CarouselViewPagerScroller;
import com.synnapps.carouselview.ImageClickListener;
import java.lang.reflect.Field;

public class CarouselViewPager
extends ViewPager {
    private ImageClickListener imageClickListener;
    private float oldX = 0.0f;
    private float newX = 0.0f;
    private float sens = 5.0f;
    private CarouselViewPagerScroller mScroller = null;

    public void setImageClickListener(ImageClickListener imageClickListener) {
        this.imageClickListener = imageClickListener;
    }

    public CarouselViewPager(Context context) {
        super(context);
        this.postInitViewPager();
    }

    public CarouselViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.postInitViewPager();
    }

    private void postInitViewPager() {
        try {
            Class<ViewPager> viewpager = ViewPager.class;
            Field scroller = viewpager.getDeclaredField("mScroller");
            scroller.setAccessible(true);
            Field interpolator = viewpager.getDeclaredField("sInterpolator");
            interpolator.setAccessible(true);
            this.mScroller = new CarouselViewPagerScroller(this.getContext(), (Interpolator)interpolator.get(null));
            scroller.set((Object)this, (Object)this.mScroller);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTransitionVelocity(int scrollFactor) {
        this.mScroller.setmScrollDuration(scrollFactor);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.oldX = ev.getX();
                break;
            }
            case 1: {
                this.newX = ev.getX();
                if (Math.abs(this.oldX - this.newX) < this.sens) {
                    if (this.imageClickListener != null) {
                        this.imageClickListener.onClick(this.getCurrentItem());
                    }
                    return true;
                }
                this.oldX = 0.0f;
                this.newX = 0.0f;
            }
        }
        return super.onTouchEvent(ev);
    }
}

