/*
 * Decompiled with CFR 0.152.
 */
package com.sygic.maps.module.common.extensions;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.location.LocationManager;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.sygic.maps.module.common.R;
import com.sygic.maps.module.common.delegate.ApplicationComponentDelegate;
import com.sygic.maps.module.common.delegate.FragmentsComponentDelegate;
import com.sygic.maps.module.common.di.BaseFragmentComponent;
import com.sygic.maps.module.common.di.util.ModuleBuilder;
import com.sygic.maps.module.common.listener.OnMapClickListener;
import com.sygic.maps.uikit.viewmodels.common.extensions.SdkExtensionsKt;
import com.sygic.maps.uikit.views.common.utils.LogUtilsKt;
import com.sygic.sdk.map.object.ViewObject;
import com.sygic.sdk.position.GeoCoordinates;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001aA\u0010\u0006\u001a\u00020\u0001\"\b\b\u0000\u0010\u0007*\u00020\u0002\"\u000e\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\u00070\t\"\u000e\b\u0002\u0010\n*\b\u0012\u0004\u0012\u0002H\b0\u000b*\u0002H\u00072\u0006\u0010\f\u001a\u0002H\n\u00a2\u0006\u0002\u0010\r\u001a\f\u0010\u000e\u001a\u00020\u000f*\u0004\u0018\u00010\u0010\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0002\u001a\f\u0010\u0011\u001a\u00020\u000f*\u0004\u0018\u00010\u0010\u001a\n\u0010\u0011\u001a\u00020\u000f*\u00020\u0002\u001a\f\u0010\u0012\u001a\u00020\u000f*\u0004\u0018\u00010\u0010\u001a\u0016\u0010\u0013\u001a\u00020\u000f*\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0019"}, d2={"createGoogleApiLocationRequest", "", "Landroidx/fragment/app/Fragment;", "requestCode", "", "Landroidx/fragment/app/FragmentActivity;", "executeInjector", "F", "C", "Lcom/sygic/maps/module/common/di/BaseFragmentComponent;", "M", "Lcom/sygic/maps/module/common/di/util/ModuleBuilder;", "moduleBuilder", "(Landroidx/fragment/app/Fragment;Lcom/sygic/maps/module/common/di/util/ModuleBuilder;)V", "isGooglePlayServicesAvailable", "", "Landroid/content/Context;", "isGpsEnabled", "isGpsNotEnabled", "onMapClick", "Lcom/sygic/maps/module/common/listener/OnMapClickListener;", "viewObject", "Lcom/sygic/sdk/map/object/ViewObject;", "showGenericNoGpsDialog", "Landroidx/appcompat/app/AlertDialog;", "module-common-1.3.7_release"})
public final class CommonExtensionsKt {
    public static final boolean onMapClick(@NotNull OnMapClickListener $this$onMapClick, @NotNull ViewObject<?> viewObject) {
        Intrinsics.checkParameterIsNotNull((Object)$this$onMapClick, (String)"$this$onMapClick");
        Intrinsics.checkParameterIsNotNull(viewObject, (String)"viewObject");
        int n = SdkExtensionsKt.getSelectionType(viewObject);
        GeoCoordinates geoCoordinates = viewObject.getPosition();
        Intrinsics.checkExpressionValueIsNotNull((Object)geoCoordinates, (String)"viewObject.position");
        double d = geoCoordinates.getLatitude();
        GeoCoordinates geoCoordinates2 = viewObject.getPosition();
        Intrinsics.checkExpressionValueIsNotNull((Object)geoCoordinates2, (String)"viewObject.position");
        return $this$onMapClick.onMapClick(n, d, geoCoordinates2.getLongitude());
    }

    public static final <F extends Fragment, C extends BaseFragmentComponent<F>, M extends ModuleBuilder<C>> void executeInjector(@NotNull F $this$executeInjector, @NotNull M moduleBuilder) {
        Intrinsics.checkParameterIsNotNull($this$executeInjector, (String)"$this$executeInjector");
        Intrinsics.checkParameterIsNotNull(moduleBuilder, (String)"moduleBuilder");
        moduleBuilder.plus(FragmentsComponentDelegate.INSTANCE.getComponent($this$executeInjector, ApplicationComponentDelegate.INSTANCE)).build().inject($this$executeInjector);
    }

    public static final boolean isGooglePlayServicesAvailable(@NotNull Fragment $this$isGooglePlayServicesAvailable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isGooglePlayServicesAvailable, (String)"$this$isGooglePlayServicesAvailable");
        return CommonExtensionsKt.isGooglePlayServicesAvailable($this$isGooglePlayServicesAvailable.requireContext());
    }

    public static final boolean isGooglePlayServicesAvailable(@Nullable Context $this$isGooglePlayServicesAvailable) {
        boolean bl;
        Context context = $this$isGooglePlayServicesAvailable;
        if (context != null) {
            Context context2 = context;
            boolean bl2 = false;
            boolean bl3 = false;
            Context it = context2;
            boolean bl4 = false;
            bl = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable($this$isGooglePlayServicesAvailable) == 0;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isGpsEnabled(@NotNull Fragment $this$isGpsEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isGpsEnabled, (String)"$this$isGpsEnabled");
        return CommonExtensionsKt.isGpsEnabled($this$isGpsEnabled.requireContext());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGpsEnabled(@Nullable Context $this$isGpsEnabled) {
        Context context = $this$isGpsEnabled;
        Object object = context;
        if (context == null) return false;
        Context context2 = object;
        boolean bl = false;
        boolean bl2 = false;
        Context it = context2;
        boolean bl3 = false;
        Context $this$locationManager$iv = it;
        boolean $i$f$getLocationManager = false;
        Object object2 = $this$locationManager$iv.getSystemService("location");
        if (!(object2 instanceof LocationManager)) {
            object2 = null;
        }
        LocationManager locationManager = (LocationManager)object2;
        if (locationManager == null) return false;
        Boolean bl4 = locationManager.isProviderEnabled("gps");
        object = bl4;
        if (bl4 == null) return false;
        boolean bl5 = (Boolean)object;
        return bl5;
    }

    public static final boolean isGpsNotEnabled(@Nullable Context $this$isGpsNotEnabled) {
        return !CommonExtensionsKt.isGpsEnabled($this$isGpsNotEnabled);
    }

    public static final void createGoogleApiLocationRequest(@NotNull Fragment $this$createGoogleApiLocationRequest, int requestCode) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createGoogleApiLocationRequest, (String)"$this$createGoogleApiLocationRequest");
        FragmentActivity fragmentActivity = $this$createGoogleApiLocationRequest.requireActivity();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"requireActivity()");
        CommonExtensionsKt.createGoogleApiLocationRequest(fragmentActivity, requestCode);
    }

    public static final void createGoogleApiLocationRequest(@NotNull FragmentActivity $this$createGoogleApiLocationRequest, int requestCode) {
        LocationRequest locationRequest;
        Intrinsics.checkParameterIsNotNull((Object)$this$createGoogleApiLocationRequest, (String)"$this$createGoogleApiLocationRequest");
        LocationRequest locationRequest2 = locationRequest = LocationRequest.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)locationRequest2, (String)"locationRequest");
        locationRequest2.setPriority(100);
        LocationSettingsRequest.Builder locationSettingsRequestBuilder = new LocationSettingsRequest.Builder().setAlwaysShow(true).addLocationRequest(locationRequest);
        Task responseTask = LocationServices.getSettingsClient((Activity)((Activity)$this$createGoogleApiLocationRequest)).checkLocationSettings(locationSettingsRequestBuilder.build());
        responseTask.addOnCompleteListener((Activity)$this$createGoogleApiLocationRequest, (OnCompleteListener)new OnCompleteListener<LocationSettingsResponse>($this$createGoogleApiLocationRequest, requestCode){
            final /* synthetic */ FragmentActivity $this_createGoogleApiLocationRequest;
            final /* synthetic */ int $requestCode;

            public final void onComplete(@NotNull Task<LocationSettingsResponse> task) {
                Intrinsics.checkParameterIsNotNull(task, (String)"task");
                try {
                    task.getResult(ApiException.class);
                }
                catch (ApiException exception) {
                    switch (exception.getStatusCode()) {
                        case 6: {
                            try {
                                ApiException apiException = exception;
                                if (apiException == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type com.google.android.gms.common.api.ResolvableApiException");
                                }
                                PendingIntent pendingIntent = ((ResolvableApiException)apiException).getResolution();
                                Intrinsics.checkExpressionValueIsNotNull((Object)pendingIntent, (String)"(exception as ResolvableApiException).resolution");
                                this.$this_createGoogleApiLocationRequest.startIntentSenderForResult(pendingIntent.getIntentSender(), this.$requestCode, null, 0, 0, 0, null);
                                break;
                            }
                            catch (IntentSender.SendIntentException ignored) {
                                LogUtilsKt.logError((String)"RequesterWrapper -> SendIntentException");
                                break;
                            }
                            catch (ClassCastException ignored) {
                                LogUtilsKt.logError((String)"RequesterWrapper -> ClassCastException");
                            }
                        }
                    }
                }
            }
            {
                this.$this_createGoogleApiLocationRequest = fragmentActivity;
                this.$requestCode = n;
            }
        });
    }

    @NotNull
    public static final AlertDialog showGenericNoGpsDialog(@NotNull Fragment $this$showGenericNoGpsDialog, int requestCode) {
        Intrinsics.checkParameterIsNotNull((Object)$this$showGenericNoGpsDialog, (String)"$this$showGenericNoGpsDialog");
        FragmentActivity fragmentActivity = $this$showGenericNoGpsDialog.requireActivity();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"requireActivity()");
        return CommonExtensionsKt.showGenericNoGpsDialog(fragmentActivity, requestCode);
    }

    @NotNull
    public static final AlertDialog showGenericNoGpsDialog(@NotNull FragmentActivity $this$showGenericNoGpsDialog, int requestCode) {
        Intrinsics.checkParameterIsNotNull((Object)$this$showGenericNoGpsDialog, (String)"$this$showGenericNoGpsDialog");
        AlertDialog alertDialog = new AlertDialog.Builder((Context)$this$showGenericNoGpsDialog).setTitle(R.string.enable_gps_dialog_title).setMessage(R.string.enable_gps_dialog_text).setNegativeButton(R.string.cancel, null).setPositiveButton(R.string.settings, new DialogInterface.OnClickListener($this$showGenericNoGpsDialog, requestCode){
            final /* synthetic */ FragmentActivity $this_showGenericNoGpsDialog;
            final /* synthetic */ int $requestCode;

            public final void onClick(DialogInterface $noName_0, int $noName_1) {
                this.$this_showGenericNoGpsDialog.startActivityForResult(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"), this.$requestCode);
            }
            {
                this.$this_showGenericNoGpsDialog = fragmentActivity;
                this.$requestCode = n;
            }
        }).show();
        Intrinsics.checkExpressionValueIsNotNull((Object)alertDialog, (String)"AlertDialog.Builder(this\u2026stCode)\n    }\n    .show()");
        return alertDialog;
    }
}

