/*
 * Decompiled with CFR 0.152.
 */
package com.sygic.maps.module.common.theme;

import android.app.Activity;
import android.app.Application;
import android.content.res.Resources;
import android.os.Bundle;
import com.sygic.maps.module.common.theme.ThemeManager;
import com.sygic.maps.module.common.theme.ThemeManagerImplKt;
import com.sygic.maps.uikit.viewmodels.common.sdk.model.ExtendedMapDataModel;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/sygic/maps/module/common/theme/ThemeManagerImpl;", "Lcom/sygic/maps/module/common/theme/ThemeManager;", "app", "Landroid/app/Application;", "mapDataModel", "Lcom/sygic/maps/uikit/viewmodels/common/sdk/model/ExtendedMapDataModel;", "(Landroid/app/Application;Lcom/sygic/maps/uikit/viewmodels/common/sdk/model/ExtendedMapDataModel;)V", "currentNightMode", "", "getCurrentMapMode", "", "resources", "Landroid/content/res/Resources;", "setSkinAtLayer", "", "skinLayer", "Lcom/sygic/maps/module/common/theme/ThemeManager$SkinLayer;", "desiredSkin", "module-common-1.0.3_release"})
public final class ThemeManagerImpl
implements ThemeManager {
    private int currentNightMode;
    private final ExtendedMapDataModel mapDataModel;

    @Override
    public void setSkinAtLayer(@NotNull ThemeManager.SkinLayer skinLayer, @NotNull String desiredSkin) {
        Intrinsics.checkParameterIsNotNull((Object)skinLayer, (String)"skinLayer");
        Intrinsics.checkParameterIsNotNull((Object)desiredSkin, (String)"desiredSkin");
        String newSkin = Intrinsics.areEqual((Object)"default", (Object)desiredSkin) ? ThemeManagerImplKt.access$getMapMode(this.currentNightMode) : desiredSkin;
        List skins = new ArrayList(this.mapDataModel.getSkin());
        skins.set(skinLayer.getPosition(), newSkin);
        this.mapDataModel.setSkin(skins);
    }

    private final String getCurrentMapMode(Resources resources) {
        this.currentNightMode = resources.getConfiguration().uiMode & 0x30;
        return ThemeManagerImplKt.access$getMapMode(this.currentNightMode);
    }

    public ThemeManagerImpl(@NotNull Application app, @NotNull ExtendedMapDataModel mapDataModel) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        Intrinsics.checkParameterIsNotNull((Object)mapDataModel, (String)"mapDataModel");
        this.mapDataModel = mapDataModel;
        app.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                ThemeManager.SkinLayer skinLayer = ThemeManager.SkinLayer.DayNight.INSTANCE;
                Resources resources = activity.getResources();
                Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"activity.resources");
                this.setSkinAtLayer(skinLayer, this.getCurrentMapMode(resources));
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @Nullable Bundle outState) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            }
        });
        ThemeManager.SkinLayer skinLayer = ThemeManager.SkinLayer.DayNight.INSTANCE;
        Resources resources = app.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"app.resources");
        this.setSkinAtLayer(skinLayer, this.getCurrentMapMode(resources));
    }
}

