/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.cloud.sb.broker.context;

import com.swisscom.cloud.sb.broker.model.ServiceContext;
import com.swisscom.cloud.sb.broker.model.ServiceContextDetail;
import com.swisscom.cloud.sb.broker.model.ServiceInstance;
import com.swisscom.cloud.sb.broker.repository.ServiceContextDetailRepository;
import com.swisscom.cloud.sb.broker.repository.ServiceContextRepository;
import com.swisscom.cloud.sb.broker.repository.ServiceInstanceRepository;
import com.swisscom.cloud.sb.broker.util.servicecontext.ServiceContextHelper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.servicebroker.model.CloudFoundryContext;
import org.springframework.cloud.servicebroker.model.Context;
import org.springframework.cloud.servicebroker.model.KubernetesContext;
import org.springframework.stereotype.Service;

@Service
public class ServiceContextPersistenceService
implements GroovyObject {
    @Autowired
    private ServiceContextDetailRepository serviceContextDetailRepository;
    @Autowired
    private ServiceContextRepository serviceContextRepository;
    @Autowired
    private ServiceInstanceRepository serviceInstanceRepository;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ServiceContextPersistenceService() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public ServiceContext findOrCreate(Context context, String serviceInstanceGuid) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)context)) {
            return (ServiceContext)ScriptBytecodeAdapter.castToType(null, ServiceContext.class);
        }
        if (context instanceof CloudFoundryContext) {
            return this.findOrCreateCloudFoundryContext((CloudFoundryContext)ScriptBytecodeAdapter.asType((Object)context, CloudFoundryContext.class));
        }
        if (context instanceof KubernetesContext) {
            return this.findOrCreateKubernetesContext((KubernetesContext)ScriptBytecodeAdapter.asType((Object)context, KubernetesContext.class));
        }
        return this.setOrUpdateDynamicContext(context, serviceInstanceGuid);
    }

    private ServiceContext setOrUpdateDynamicContext(Context context, String serviceInstanceGuid) {
        ServiceInstance serviceInstance = this.serviceInstanceRepository.findByGuid(serviceInstanceGuid);
        ServiceContext serviceContext = new ServiceContext();
        String string = context.getPlatform();
        serviceContext.setPlatform(string);
        ServiceContext serviceContext2 = serviceContext;
        if (serviceInstance == null || serviceInstance.getServiceContext() == null) {
            Object object = this.serviceContextRepository.save(serviceContext2);
            serviceContext2 = (ServiceContext)ScriptBytecodeAdapter.castToType((Object)object, ServiceContext.class);
        } else {
            ServiceContext serviceContext3;
            serviceContext2 = serviceContext3 = serviceInstance.getServiceContext();
            if (ScriptBytecodeAdapter.compareNotEqual((Object)serviceContext2.getPlatform(), (Object)context.getPlatform())) {
                String string2 = context.getPlatform();
                serviceContext2.setPlatform(string2);
                Object object = this.serviceContextRepository.save(serviceContext2);
                serviceContext2 = (ServiceContext)ScriptBytecodeAdapter.castToType((Object)object, ServiceContext.class);
            }
        }
        this.setServiceContextDetails(context.getProperties(), serviceContext2);
        Object object = this.serviceContextRepository.save(serviceContext2);
        serviceContext2 = (ServiceContext)ScriptBytecodeAdapter.castToType((Object)object, ServiceContext.class);
        return serviceContext2;
    }

    private void setServiceContextDetails(Map<String, Object> newDetails, ServiceContext serviceContext) {
        Reference serviceContext2 = new Reference((Object)serviceContext);
        Reference existingDetails = new Reference((Object)DefaultGroovyMethods.toList((Iterable)((ServiceContext)serviceContext2.get()).getDetails()));
        public final class _setServiceContextDetails_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingDetails;
            private /* synthetic */ Reference serviceContext;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _setServiceContextDetails_closure1(Object _outerInstance, Object _thisObject, Reference existingDetails, Reference serviceContext) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.existingDetails = reference2 = existingDetails;
                this.serviceContext = reference = serviceContext;
            }

            public Object doCall(Object newDetail) {
                Reference newDetail2 = new Reference(newDetail);
                public final class _closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference newDetail;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure3(Object _outerInstance, Object _thisObject, Reference newDetail) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.newDetail = reference = newDetail;
                    }

                    public Object doCall(Object d) {
                        return ScriptBytecodeAdapter.compareEqual((Object)((ServiceContextDetail)d).getKey(), ((Map.Entry)this.newDetail.get()).getKey());
                    }

                    @Generated
                    public Object getNewDetail() {
                        return this.newDetail.get();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ServiceContextDetail matchedDetail = (ServiceContextDetail)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)this.existingDetails.get(), Collection.class)), (Closure)new _closure3((Object)this, this.getThisObject(), newDetail2)), ServiceContextDetail.class);
                if (matchedDetail == null) {
                    ((ServiceContext)this.serviceContext.get()).getDetails().add(((ServiceContextPersistenceService)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ServiceContextPersistenceService.class)).createServiceContextDetailRecord(((String)((Map.Entry)newDetail2.get()).getKey()).toString(), DefaultGroovyMethods.toString(((Map.Entry)newDetail2.get()).getValue()), (ServiceContext)ScriptBytecodeAdapter.castToType((Object)this.serviceContext.get(), ServiceContext.class)));
                } else if (ScriptBytecodeAdapter.compareNotEqual((Object)matchedDetail.getValue(), ((Map.Entry)newDetail2.get()).getValue())) {
                    Object v = ((Map.Entry)newDetail2.get()).getValue();
                    matchedDetail.setValue(ShortTypeHandling.castToString(v));
                    Object object = ((ServiceContextPersistenceService)this.getThisObject()).serviceContextDetailRepository.save(matchedDetail);
                    matchedDetail = (ServiceContextDetail)ScriptBytecodeAdapter.castToType((Object)object, ServiceContextDetail.class);
                }
                if (matchedDetail != null) {
                    return ((List)this.existingDetails.get()).remove(matchedDetail);
                }
                return null;
            }

            @Generated
            public List getExistingDetails() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.existingDetails.get(), List.class);
            }

            @Generated
            public ServiceContext getServiceContext() {
                return (ServiceContext)ScriptBytecodeAdapter.castToType((Object)this.serviceContext.get(), ServiceContext.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setServiceContextDetails_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(newDetails, (Closure)new _setServiceContextDetails_closure1(this, this, existingDetails, serviceContext2));
        public final class _setServiceContextDetails_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serviceContext;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _setServiceContextDetails_closure2(Object _outerInstance, Object _thisObject, Reference serviceContext) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serviceContext = reference = serviceContext;
            }

            public Object doCall(Object toDelete) {
                ((ServiceContextPersistenceService)this.getThisObject()).serviceContextDetailRepository.delete(toDelete);
                return ((ServiceContext)this.serviceContext.get()).getDetails().remove(toDelete);
            }

            @Generated
            public ServiceContext getServiceContext() {
                return (ServiceContext)ScriptBytecodeAdapter.castToType((Object)this.serviceContext.get(), ServiceContext.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setServiceContextDetails_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)((List)existingDetails.get()), (Closure)new _setServiceContextDetails_closure2(this, this, serviceContext2));
    }

    private ServiceContext findOrCreateCloudFoundryContext(CloudFoundryContext context) {
        ServiceContext existingServiceContext = this.serviceContextRepository.findCloudFoundryServiceContext(context.getOrganizationGuid(), context.getSpaceGuid());
        if (DefaultTypeTransformation.booleanUnbox((Object)existingServiceContext)) {
            return existingServiceContext;
        }
        return this.createCloudFoundryContext(context);
    }

    private ServiceContext createCloudFoundryContext(CloudFoundryContext context) {
        ServiceContext serviceContext = new ServiceContext();
        String string = CloudFoundryContext.CLOUD_FOUNDRY_PLATFORM;
        serviceContext.setPlatform(string);
        ServiceContext serviceContext2 = serviceContext;
        this.serviceContextRepository.saveAndFlush(serviceContext2);
        Set contextDetails = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        DefaultGroovyMethods.leftShift((Set)contextDetails, (Object)this.createServiceContextDetailRecord(ServiceContextHelper.CF_ORGANIZATION_GUID, context.getOrganizationGuid(), serviceContext2));
        DefaultGroovyMethods.leftShift((Set)contextDetails, (Object)this.createServiceContextDetailRecord(ServiceContextHelper.CF_SPACE_GUID, context.getSpaceGuid(), serviceContext2));
        this.serviceContextDetailRepository.flush();
        serviceContext2.getDetails().addAll(contextDetails);
        this.serviceContextRepository.merge(serviceContext2);
        this.serviceContextRepository.flush();
        return serviceContext2;
    }

    private ServiceContext findOrCreateKubernetesContext(KubernetesContext context) {
        ServiceContext existingServiceContext = this.serviceContextRepository.findKubernetesServiceContext(context.getNamespace());
        if (DefaultTypeTransformation.booleanUnbox((Object)existingServiceContext)) {
            return existingServiceContext;
        }
        return this.createKubernetesContext(context);
    }

    private ServiceContext createKubernetesContext(KubernetesContext context) {
        ServiceContext serviceContext = new ServiceContext();
        String string = KubernetesContext.KUBERNETES_PLATFORM;
        serviceContext.setPlatform(string);
        ServiceContext serviceContext2 = serviceContext;
        this.serviceContextRepository.saveAndFlush(serviceContext2);
        Set contextDetails = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        DefaultGroovyMethods.leftShift((Set)contextDetails, (Object)this.createServiceContextDetailRecord(ServiceContextHelper.KUBERNETES_NAMESPACE, context.getNamespace(), serviceContext2));
        this.serviceContextDetailRepository.flush();
        serviceContext2.getDetails().addAll(contextDetails);
        this.serviceContextRepository.merge(serviceContext2);
        return serviceContext2;
    }

    private ServiceContextDetail createServiceContextDetailRecord(String key, String value, ServiceContext serviceContext) {
        return (ServiceContextDetail)ScriptBytecodeAdapter.castToType((Object)this.serviceContextDetailRepository.saveAndFlush(ServiceContextDetail.of((String)key, (String)value, (ServiceContext)serviceContext)), ServiceContextDetail.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ServiceContextPersistenceService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

