/*
 * Decompiled with CFR 0.152.
 */
package de.robv.android.xposed;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import android.os.Environment;
import android.util.Log;
import com.android.internal.util.XmlUtils;
import de.robv.android.xposed.SELinuxHelper;
import de.robv.android.xposed.services.FileResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public final class XSharedPreferences
implements SharedPreferences {
    private static final String TAG = "XSharedPreferences";
    private final File mFile;
    private final String mFilename;
    private Map<String, Object> mMap;
    private boolean mLoaded = false;
    private long mLastModified;
    private long mFileSize;

    public XSharedPreferences(File prefFile) {
        this.mFile = prefFile;
        this.mFilename = this.mFile.getAbsolutePath();
        this.startLoadFromDisk();
    }

    public XSharedPreferences(String packageName) {
        this(packageName, packageName + "_preferences");
    }

    public XSharedPreferences(String packageName, String prefFileName) {
        this.mFile = new File(Environment.getDataDirectory(), "data/" + packageName + "/shared_prefs/" + prefFileName + ".xml");
        this.mFilename = this.mFile.getAbsolutePath();
        this.startLoadFromDisk();
    }

    @SuppressLint(value={"SetWorldReadable"})
    public boolean makeWorldReadable() {
        if (!SELinuxHelper.getAppDataFileService().hasDirectFileAccess()) {
            return false;
        }
        if (!this.mFile.exists()) {
            return false;
        }
        return this.mFile.setReadable(true, false);
    }

    public File getFile() {
        return this.mFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadFromDisk() {
        XSharedPreferences xSharedPreferences = this;
        synchronized (xSharedPreferences) {
            this.mLoaded = false;
        }
        new Thread("XSharedPreferences-load"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                XSharedPreferences xSharedPreferences = XSharedPreferences.this;
                synchronized (xSharedPreferences) {
                    XSharedPreferences.this.loadFromDiskLocked();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromDiskLocked() {
        if (this.mLoaded) {
            return;
        }
        Map<String, Object> map = null;
        FileResult result = null;
        try {
            result = SELinuxHelper.getAppDataFileService().getFileInputStream(this.mFilename, this.mFileSize, this.mLastModified);
            if (result.stream != null) {
                map = XmlUtils.readMapXml(result.stream);
                result.stream.close();
            } else {
                map = this.mMap;
            }
        }
        catch (XmlPullParserException e) {
            Log.w((String)TAG, (String)"getSharedPreferences", (Throwable)e);
        }
        catch (FileNotFoundException rethrown) {
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"getSharedPreferences", (Throwable)e);
        }
        finally {
            if (result != null && result.stream != null) {
                try {
                    result.stream.close();
                }
                catch (RuntimeException rethrown) {
                    throw rethrown;
                }
                catch (Exception rethrown) {}
            }
        }
        this.mLoaded = true;
        if (map != null) {
            this.mMap = map;
            this.mLastModified = result.mtime;
            this.mFileSize = result.size;
        } else {
            this.mMap = new HashMap<String, Object>();
        }
        this.notifyAll();
    }

    public synchronized void reload() {
        if (this.hasFileChanged()) {
            this.startLoadFromDisk();
        }
    }

    public synchronized boolean hasFileChanged() {
        try {
            FileResult result = SELinuxHelper.getAppDataFileService().statFile(this.mFilename);
            return this.mLastModified != result.mtime || this.mFileSize != result.size;
        }
        catch (FileNotFoundException ignored) {
            return true;
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"hasFileChanged", (Throwable)e);
            return true;
        }
    }

    private void awaitLoadedLocked() {
        while (!this.mLoaded) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ?> getAll() {
        XSharedPreferences xSharedPreferences = this;
        synchronized (xSharedPreferences) {
            this.awaitLoadedLocked();
            return new HashMap<String, Object>(this.mMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defValue) {
        XSharedPreferences xSharedPreferences = this;
        synchronized (xSharedPreferences) {
            this.awaitLoadedLocked();
            String v = (String)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getStringSet(String key, Set<String> defValues) {
        XSharedPreferences xSharedPreferences = this;
        synchronized (xSharedPreferences) {
            this.awaitLoadedLocked();
            Set<String> v = (Set<String>)this.mMap.get(key);
            return v != null ? v : defValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key, int defValue) {
        XSharedPreferences xSharedPreferences = this;
        synchronized (xSharedPreferences) {
            this.awaitLoadedLocked();
            Integer v = (Integer)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key, long defValue) {
        XSharedPreferences xSharedPreferences = this;
        synchronized (xSharedPreferences) {
            this.awaitLoadedLocked();
            Long v = (Long)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float defValue) {
        XSharedPreferences xSharedPreferences = this;
        synchronized (xSharedPreferences) {
            this.awaitLoadedLocked();
            Float v = (Float)this.mMap.get(key);
            return v != null ? v.floatValue() : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean defValue) {
        XSharedPreferences xSharedPreferences = this;
        synchronized (xSharedPreferences) {
            this.awaitLoadedLocked();
            Boolean v = (Boolean)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        XSharedPreferences xSharedPreferences = this;
        synchronized (xSharedPreferences) {
            this.awaitLoadedLocked();
            return this.mMap.containsKey(key);
        }
    }

    @Deprecated
    public SharedPreferences.Editor edit() {
        throw new UnsupportedOperationException("read-only implementation");
    }

    @Deprecated
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException("listeners are not supported in this implementation");
    }

    @Deprecated
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException("listeners are not supported in this implementation");
    }
}

