/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.suse.salt.netapi.config.ClientConfig;
import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.event.EventListener;
import com.suse.salt.netapi.exception.MessageTooBigException;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.parser.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

@ClientEndpoint
public class EventStream
implements AutoCloseable {
    private final List<EventListener> listeners = new ArrayList<EventListener>();
    private final int defaultBufferSize = 1024;
    private final int maxMessageLength;
    private final StringBuilder messageBuffer = new StringBuilder(1024);
    private final WebSocketContainer websocketContainer = ContainerProvider.getWebSocketContainer();
    private Session session;

    public EventStream(ClientConfig config, EventListener ... listeners) throws SaltException {
        this.maxMessageLength = config.get(ClientConfig.WEBSOCKET_MAX_MESSAGE_LENGTH) > 0 ? config.get(ClientConfig.WEBSOCKET_MAX_MESSAGE_LENGTH) : Integer.MAX_VALUE;
        Arrays.asList(listeners).forEach(this::addEventListener);
        this.initializeStream(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStream(ClientConfig config) throws SaltException {
        try {
            URI uri = config.get(ClientConfig.URL);
            uri = new URI(uri.getScheme() == "https" ? "wss" : "ws", uri.getSchemeSpecificPart(), uri.getFragment()).resolve("/ws/" + config.get(ClientConfig.TOKEN));
            this.websocketContainer.setDefaultMaxSessionIdleTimeout((long)config.get(ClientConfig.SOCKET_TIMEOUT).intValue());
            WebSocketContainer webSocketContainer = this.websocketContainer;
            synchronized (webSocketContainer) {
                this.session = this.websocketContainer.connectToServer((Object)this, uri);
                this.session.setMaxIdleTimeout((long)config.get(ClientConfig.SOCKET_TIMEOUT).intValue());
            }
        }
        catch (IOException | URISyntaxException | DeploymentException e) {
            throw new SaltException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventListener listener) {
        List<EventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(EventListener listener) {
        List<EventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getListenerCount() {
        List<EventListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.size();
        }
    }

    public boolean isEventStreamClosed() {
        return this.session == null || !this.session.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "The listener has closed the event stream"));
    }

    public void close(CloseReason closeReason) throws IOException {
        if (!this.isEventStreamClosed()) {
            this.session.close(closeReason);
        }
    }

    @OnOpen
    public void onOpen(Session session, EndpointConfig config) throws IOException {
        this.session = session;
        session.getBasicRemote().sendText("websocket client ready");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnMessage
    public void onMessage(String partialMessage, boolean last) throws MessageTooBigException {
        if (partialMessage.length() > this.maxMessageLength - this.messageBuffer.length()) {
            throw new MessageTooBigException(this.maxMessageLength);
        }
        if (last) {
            String message;
            if (this.messageBuffer.length() == 0) {
                message = partialMessage;
            } else {
                this.messageBuffer.append(partialMessage);
                message = this.messageBuffer.toString();
                this.messageBuffer.setLength(1024);
                this.messageBuffer.trimToSize();
                this.messageBuffer.setLength(0);
            }
            if (!message.equals("server received message")) {
                Event event = JsonParser.EVENTS.parse(message.substring(6));
                List<EventListener> list = this.listeners;
                synchronized (list) {
                    this.listeners.stream().forEach(listener -> listener.notify(event));
                }
            }
        } else {
            this.messageBuffer.append(partialMessage);
        }
    }

    @OnError
    public void onError(Throwable throwable) throws IOException {
        this.close(new CloseReason((CloseReason.CloseCode)(throwable instanceof MessageTooBigException ? CloseReason.CloseCodes.TOO_BIG : CloseReason.CloseCodes.CLOSED_ABNORMALLY), throwable.getMessage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        this.session = session;
        List<EventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.stream().forEach(listener -> listener.eventStreamClosed(closeReason));
            this.listeners.clear();
        }
    }
}

