/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.AuthModule;
import com.suse.salt.netapi.calls.Call;
import com.suse.salt.netapi.calls.Client;
import com.suse.salt.netapi.calls.WheelAsyncResult;
import com.suse.salt.netapi.calls.WheelResult;
import com.suse.salt.netapi.client.SaltClient;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.utils.ClientUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class WheelCall<R>
implements Call<R> {
    private final String functionName;
    private final Optional<Map<String, ?>> kwargs;
    private final TypeToken<R> returnType;

    public WheelCall(String functionName, Optional<Map<String, ?>> kwargs, TypeToken<R> returnType) {
        this.functionName = functionName;
        this.kwargs = kwargs;
        this.returnType = returnType;
    }

    public TypeToken<R> getReturnType() {
        return this.returnType;
    }

    @Override
    public Map<String, Object> getPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("fun", this.functionName);
        this.kwargs.ifPresent(payload::putAll);
        return payload;
    }

    public WheelAsyncResult<R> callAsync(SaltClient client) throws SaltException {
        Result wrapper = (Result)client.call(this, Client.WHEEL_ASYNC, "/", new TypeToken<Result<List<WheelAsyncResult<R>>>>(){});
        WheelAsyncResult result = (WheelAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public WheelAsyncResult<R> callAsync(SaltClient client, String username, String password, AuthModule authModule) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("username", username);
        customArgs.put("password", password);
        customArgs.put("eauth", authModule.getValue());
        Result wrapper = (Result)client.call(this, Client.WHEEL_ASYNC, "/run", Optional.of(customArgs), new TypeToken<Result<List<WheelAsyncResult<R>>>>(){});
        WheelAsyncResult result = (WheelAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public WheelResult<R> callSync(SaltClient client) throws SaltException {
        ParameterizedType wheelResult = ClientUtils.parameterizedType(null, WheelResult.class, new Type[]{this.getReturnType().getType()});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{wheelResult});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Result.class, new Type[]{listType});
        Result wrapper = (Result)client.call(this, Client.WHEEL, "/", TypeToken.get((Type)wrapperType));
        return (WheelResult)((List)wrapper.getResult()).get(0);
    }

    public WheelResult<R> callSync(SaltClient client, String username, String password, AuthModule authModule) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("username", username);
        customArgs.put("password", password);
        customArgs.put("eauth", authModule.getValue());
        ParameterizedType wheelResult = ClientUtils.parameterizedType(null, WheelResult.class, new Type[]{this.getReturnType().getType()});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{wheelResult});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Result.class, new Type[]{listType});
        Result wrapper = (Result)client.call(this, Client.WHEEL, "/run", Optional.of(customArgs), TypeToken.get((Type)wrapperType));
        return (WheelResult)((List)wrapper.getResult()).get(0);
    }
}

