/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls.modules;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.LocalCall;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Locate {
    private static final LocalCall<List<String>> VERSION = new LocalCall<List<String>>("locate.version", Optional.empty(), Optional.empty(), new TypeToken<List<String>>(){});
    private static final LocalCall<List<String>> UPDATEDB = new LocalCall<List<String>>("locate.updatedb", Optional.empty(), Optional.empty(), new TypeToken<List<String>>(){});
    private static final LocalCall<Stats> STATS = new LocalCall<Stats>("locate.stats", Optional.empty(), Optional.empty(), new TypeToken<Stats>(){});

    public static LocalCall<List<String>> version() {
        return VERSION;
    }

    public static LocalCall<List<String>> updatedb() {
        return UPDATEDB;
    }

    public static LocalCall<Stats> stats() {
        return STATS;
    }

    public static LocalCall<List<String>> locate(String pattern, Optional<String> database, Optional<Integer> limit, Optional<LocateOpts> options) {
        LinkedList<Object> args = new LinkedList<Object>();
        LinkedHashMap kwargs = new LinkedHashMap();
        args.add(pattern);
        args.add(database.orElse(""));
        args.add(limit.orElse(0));
        options.ifPresent(opts -> kwargs.putAll(opts.getOpts()));
        return new LocalCall<List<String>>("locate.locate", Optional.of(args), Optional.of(kwargs), new TypeToken<List<String>>(){});
    }

    public static class LocateOpts {
        private Map<String, Boolean> opts = new HashMap<String, Boolean>();

        public void setBasename(boolean basename) {
            this.opts.put("basename", basename);
        }

        public void setCount(boolean count) {
            this.opts.put("count", count);
        }

        public void setExisting(boolean existing) {
            this.opts.put("existing", existing);
        }

        public void setFollow(boolean follow) {
            this.opts.put("follow", follow);
        }

        public void setIgnore(boolean ignore) {
            this.opts.put("ignore", ignore);
        }

        public void setNofollow(boolean nofollow) {
            this.opts.put("nofollow", nofollow);
        }

        public void setWholename(boolean wholename) {
            this.opts.put("wholename", wholename);
        }

        public void setRegex(boolean regex) {
            this.opts.put("regex", regex);
        }

        Map<String, Boolean> getOpts() {
            return this.opts;
        }
    }

    public static class Stats {
        private long files;
        private long directories;
        @SerializedName(value="bytes in file names")
        private long fileNamesBytes;
        @SerializedName(value="bytes used to store database")
        private long databaseBytes;
        @SerializedName(value="database")
        private String databaseLocation;

        public long getFiles() {
            return this.files;
        }

        public long getDirectories() {
            return this.directories;
        }

        public long getFileNamesBytes() {
            return this.fileNamesBytes;
        }

        public long getDatabaseBytes() {
            return this.databaseBytes;
        }

        public String getDatabaseLocation() {
            return this.databaseLocation;
        }
    }
}

