/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.parser;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public class OptionalTypeAdapterFactory
implements TypeAdapterFactory {
    public <A> TypeAdapter<A> create(Gson gson, TypeToken<A> typeToken) {
        Type type = typeToken.getType();
        boolean isOptional = typeToken.getRawType() == Optional.class;
        boolean isParameterized = type instanceof ParameterizedType;
        if (isOptional && isParameterized) {
            Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
            TypeAdapter elementAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
            return this.optionalAdapter(elementAdapter);
        }
        return null;
    }

    private <A> TypeAdapter<Optional<A>> optionalAdapter(final TypeAdapter<A> innerAdapter) {
        return new TypeAdapter<Optional<A>>(){

            public Optional<A> read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return Optional.empty();
                }
                JsonElement json = (JsonElement)TypeAdapters.JSON_ELEMENT.read(in);
                try {
                    Object value = innerAdapter.fromJsonTree(json);
                    return Optional.of(value);
                }
                catch (JsonSyntaxException e) {
                    if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString() && json.getAsString().isEmpty()) {
                        return Optional.empty();
                    }
                    throw e;
                }
            }

            public void write(JsonWriter out, Optional<A> optional) throws IOException {
                innerAdapter.write(out, optional.orElse(null));
            }
        };
    }
}

