/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls.modules;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.LocalCall;
import com.suse.salt.netapi.results.GitResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;

public class Git {
    private Git() {
    }

    public static LocalCall<GitResult> status(String cwd, Optional<String> user) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(cwd));
        user.ifPresent(usr -> args.add((String)usr));
        return new LocalCall<GitResult>("git.status", Optional.of(args), Optional.of(Collections.emptyMap()), new TypeToken<GitResult>(){});
    }

    public static LocalCall<String> add(String cwd, String filename, String opts, String gitOpts, Optional<String> user) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(cwd, filename, opts, gitOpts));
        user.ifPresent(usr -> args.add((String)usr));
        return new LocalCall<String>("git.add", Optional.of(args), Optional.of(Collections.emptyMap()), new TypeToken<String>(){});
    }

    public static LocalCall<String> commit(String cwd, String message, String opts, String gitOpts, Optional<String> user, Optional<String> filename) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(cwd, message, opts, gitOpts));
        user.ifPresent(usr -> args.add((String)usr));
        filename.ifPresent(file -> args.add((String)file));
        return new LocalCall<String>("git.commit", Optional.of(args), Optional.of(Collections.emptyMap()), new TypeToken<String>(){});
    }

    public static LocalCall<Boolean> branch(String cwd, String branch, String opts, String gitOpts, Optional<String> user) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(cwd, branch, opts, gitOpts));
        user.ifPresent(usr -> args.add((String)usr));
        return new LocalCall<Boolean>("git.branch", Optional.of(args), Optional.of(Collections.emptyMap()), new TypeToken<Boolean>(){});
    }

    public static LocalCall<Boolean> clone(String cwd, String url, Optional<String> name, String opts, String gitOpts, Optional<String> user, Optional<String> httpsUser, Optional<String> httpsPass) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(cwd, url));
        args.add(name.orElse(null));
        args.add(opts);
        args.add(gitOpts);
        args.add(user.orElse(null));
        args.add(null);
        args.add(null);
        args.add(httpsUser.orElse(null));
        args.add(httpsPass.orElse(null));
        LocalCall<Boolean> run = new LocalCall<Boolean>("git.clone", Optional.of(args), Optional.of(Collections.emptyMap()), new TypeToken<Boolean>(){});
        if (httpsUser.isPresent()) {
            return run.withTimeouts(Optional.of(4), Optional.of(1));
        }
        return run;
    }
}

