/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls.modules;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.LocalCall;
import com.suse.salt.netapi.results.GitResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Git {
    private Git() {
    }

    public static LocalCall<GitResult> status(String cwd, Optional<String> user) {
        List<String> args = Arrays.asList(cwd);
        user.ifPresent(usr -> args.add((String)usr));
        return new LocalCall<GitResult>("git.status", Optional.of(args), Optional.of(Collections.emptyMap()), new TypeToken<GitResult>(){});
    }

    public static LocalCall<String> add(String cwd, String filename, String opts, String gitOpts, Optional<String> user) {
        List<String> args = Arrays.asList(cwd, filename, opts, gitOpts);
        user.ifPresent(usr -> args.add((String)usr));
        return new LocalCall<String>("git.add", Optional.of(args), Optional.of(Collections.emptyMap()), new TypeToken<String>(){});
    }

    public static LocalCall<String> commit(String cwd, String message, String opts, String gitOpts, Optional<String> user, Optional<String> filename) {
        List<String> args = Arrays.asList(cwd, message, opts, gitOpts);
        user.ifPresent(usr -> args.add((String)usr));
        filename.ifPresent(file -> args.add((String)file));
        return new LocalCall<String>("git.commit", Optional.of(args), Optional.of(Collections.emptyMap()), new TypeToken<String>(){});
    }

    public static LocalCall<Boolean> branch(String cwd, String branch, String opts, String gitOpts, Optional<String> user) {
        List<String> args = Arrays.asList(cwd, branch, opts, gitOpts);
        user.ifPresent(usr -> args.add((String)usr));
        return new LocalCall<Boolean>("git.branch", Optional.of(args), Optional.of(Collections.emptyMap()), new TypeToken<Boolean>(){});
    }
}

