/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls.modules;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.LocalCall;
import com.suse.salt.netapi.calls.modules.HashType;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public class File {
    private File() {
    }

    public static LocalCall<String> chown(String path, String user, String group) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("path", path);
        args.put("user", user);
        args.put("group", group);
        return new LocalCall<String>("file.chown", Optional.empty(), Optional.of(args), new TypeToken<String>(){});
    }

    public static LocalCall<String> chmod(String path, String mode) {
        return new LocalCall<String>("file.set_mode", Optional.of(Arrays.asList(path, mode)), Optional.empty(), new TypeToken<String>(){});
    }

    public static LocalCall<Boolean> copy(String src, String dst, boolean recurse, boolean removeExisting) {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("src", src);
        args.put("dst", dst);
        args.put("recurse", recurse);
        args.put("remove_existing", removeExisting);
        return new LocalCall<Boolean>("file.copy", Optional.empty(), Optional.of(args), new TypeToken<Boolean>(){});
    }

    public static LocalCall<Result> move(String src, String dst) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("src", src);
        args.put("dst", dst);
        return new LocalCall<Result>("file.move", Optional.empty(), Optional.of(args), new TypeToken<Result>(){});
    }

    public static LocalCall<Boolean> remove(String path) {
        return new LocalCall<Boolean>("file.remove", Optional.of(Collections.singletonList(path)), Optional.empty(), new TypeToken<Boolean>(){});
    }

    public static LocalCall<String> getHash(String path) {
        return File.getHash(path, Optional.empty(), Optional.empty());
    }

    public static LocalCall<String> getHash(String path, HashType form) {
        return File.getHash(path, Optional.of(form), Optional.empty());
    }

    public static LocalCall<String> getHash(String path, HashType form, long chunkSize) {
        return File.getHash(path, Optional.of(form), Optional.of(chunkSize));
    }

    private static LocalCall<String> getHash(String path, Optional<HashType> form, Optional<Long> chunkSize) {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("path", path);
        if (form.isPresent()) {
            args.put("form", form.get().getHashType());
        }
        if (chunkSize.isPresent()) {
            args.put("chunk_size", chunkSize.get());
        }
        return new LocalCall<String>("file.get_hash", Optional.empty(), Optional.of(args), new TypeToken<String>(){});
    }

    public static LocalCall<Boolean> directoryExists(String path) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("path", path);
        return new LocalCall<Boolean>("file.directory_exists", Optional.empty(), Optional.of(args), new TypeToken<Boolean>(){});
    }

    public static LocalCall<Boolean> fileExists(String path) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("path", path);
        return new LocalCall<Boolean>("file.file_exists", Optional.empty(), Optional.of(args), new TypeToken<Boolean>(){});
    }

    public static LocalCall<String> getMode(String path, boolean followSymlinks) {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("path", path);
        args.put("follow_symlinks", followSymlinks);
        return new LocalCall<String>("file.get_mode", Optional.empty(), Optional.of(args), new TypeToken<String>(){});
    }

    public static LocalCall<String> getUid(String path, boolean followSymlinks) {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("path", path);
        args.put("follow_symlinks", followSymlinks);
        return new LocalCall<String>("file.get_uid", Optional.empty(), Optional.of(args), new TypeToken<String>(){});
    }

    public static LocalCall<String> getUser(String path, boolean followSymlinks) {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("path", path);
        args.put("follow_symlinks", followSymlinks);
        return new LocalCall<String>("file.get_user", Optional.empty(), Optional.of(args), new TypeToken<String>(){});
    }

    public static LocalCall<String> mkdir(String path) {
        return File.mkdir(path, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static LocalCall<String> mkdir(String path, String mode) {
        return File.mkdir(path, Optional.empty(), Optional.empty(), Optional.of(mode));
    }

    public static LocalCall<String> mkdir(String path, String user, String group) {
        return File.mkdir(path, Optional.of(user), Optional.of(group), Optional.empty());
    }

    public static LocalCall<String> mkdir(String path, String user, String group, String mode) {
        return File.mkdir(path, Optional.of(user), Optional.of(group), Optional.of(mode));
    }

    private static LocalCall<String> mkdir(String path, Optional<String> user, Optional<String> group, Optional<String> mode) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("dir_path", path);
        if (user.isPresent()) {
            args.put("user", user.get());
        }
        if (group.isPresent()) {
            args.put("group", group.get());
        }
        if (mode.isPresent()) {
            args.put("mode", mode.get());
        }
        return new LocalCall<String>("file.mkdir", Optional.empty(), Optional.of(args), new TypeToken<String>(){});
    }

    public static LocalCall<List<String>> readdir(String path) {
        return new LocalCall<List<String>>("file.readdir", Optional.of(Collections.singletonList(path)), Optional.empty(), new TypeToken<List<String>>(){});
    }

    public static LocalCall<Boolean> rmdir(String path) {
        return new LocalCall<Boolean>("file.rmdir", Optional.of(Collections.singletonList(path)), Optional.empty(), new TypeToken<Boolean>(){});
    }

    public static LocalCall<Boolean> isLink(String path) {
        return new LocalCall<Boolean>("file.is_link", Optional.of(Collections.singletonList(path)), Optional.empty(), new TypeToken<Boolean>(){});
    }

    public static LocalCall<Boolean> symlink(String src, String path) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("src", src);
        args.put("path", path);
        return new LocalCall<Boolean>("file.symlink", Optional.empty(), Optional.of(args), new TypeToken<Boolean>(){});
    }

    public static class Result {
        private boolean result;
        private String comment;

        public boolean getResult() {
            return this.result;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

