/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls.modules;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.LocalCall;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Grains {
    private static LocalCall<List<String>> LS = new LocalCall<List<String>>("grains.ls", Optional.empty(), Optional.empty(), new TypeToken<List<String>>(){});

    private Grains() {
    }

    public static LocalCall<Map<String, Object>> items(boolean sanitize) {
        LinkedHashMap<String, Boolean> args = new LinkedHashMap<String, Boolean>();
        args.put("sanitize", sanitize);
        return new LocalCall<Map<String, Object>>("grains.items", Optional.empty(), Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }

    public static LocalCall<List<String>> ls() {
        return LS;
    }

    public static LocalCall<Map<String, Object>> item(boolean sanitize, String ... items) {
        LinkedHashMap<String, Boolean> args = new LinkedHashMap<String, Boolean>();
        args.put("sanitize", sanitize);
        return new LocalCall<Map<String, Object>>("grains.item", Optional.of(Arrays.asList(items)), Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }

    public static LocalCall<Boolean> hasValue(String key) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("key", key);
        return new LocalCall<Boolean>("grains.has_value", Optional.empty(), Optional.of(args), new TypeToken<Boolean>(){});
    }

    public static LocalCall<Map<String, Object>> set(String key, Optional<Map<String, Object>> extraArgs) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("key", key);
        extraArgs.ifPresent(args::putAll);
        return new LocalCall<Map<String, Object>>("grains.set", Optional.empty(), Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }

    public static LocalCall<Map<String, Object>> setValue(String key, String value, Optional<Boolean> destructive) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("key", key);
        args.put("val", value);
        destructive.ifPresent(dest -> args.put("destructive", (String)dest));
        return new LocalCall<Map<String, Object>>("grains.setval", Optional.empty(), Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }

    public static LocalCall<Map<String, Object>> setValues(Map<String, Object> grains, Optional<Boolean> destructive) {
        LinkedHashMap<String, Map<String, Object>> args = new LinkedHashMap<String, Map<String, Object>>();
        args.put("grains", grains);
        destructive.ifPresent(dest -> args.put("destructive", (Map<String, Object>)dest));
        return new LocalCall<Map<String, Object>>("grains.setvals", Optional.empty(), Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }

    public static LocalCall<Map<String, Object>> append(String key, String value, Optional<Boolean> convert, Optional<Boolean> delimiter) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("key", key);
        args.put("val", value);
        convert.ifPresent(cnvrt -> args.put("convert", (String)cnvrt));
        delimiter.ifPresent(dlmtr -> args.put("delimiter", (String)dlmtr));
        return new LocalCall<Map<String, Object>>("grains.append", Optional.empty(), Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }

    public static LocalCall<Map<String, Object>> deleteKey(String key) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("key", key);
        return new LocalCall<Map<String, Object>>("grains.delkey", Optional.empty(), Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }

    public static LocalCall<Map<String, Object>> deleteValue(String key, Optional<Boolean> destructive) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("key", key);
        destructive.ifPresent(dest -> args.put("destructive", (String)dest));
        return new LocalCall<Map<String, Object>>("grains.delval", Optional.empty(), Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }

    public static LocalCall<Map<String, Object>> remove(String key, String value, Optional<Boolean> delimiter) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("key", key);
        args.put("val", value);
        delimiter.ifPresent(dlmtr -> args.put("delimiter", (String)dlmtr));
        return new LocalCall<Map<String, Object>>("grains.remove", Optional.empty(), Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }
}

